/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.predicate;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.LegacySearchBuilder;
import ca.uhn.fhir.jpa.dao.predicate.BasePredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.IPredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinEnum;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.base.composite.BaseQuantityDt;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.param.QuantityParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class PredicateBuilderQuantity
extends BasePredicateBuilder
implements IPredicateBuilder {
    public PredicateBuilderQuantity(LegacySearchBuilder theSearchBuilder) {
        super(theSearchBuilder);
    }

    @Override
    public Predicate addPredicate(String theResourceName, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        From join = this.myQueryStack.createJoin(SearchBuilderJoinEnum.QUANTITY, theSearchParam.getName());
        if (theList.get(0).getMissing() != null) {
            this.addPredicateParamMissingForNonReference(theResourceName, theSearchParam.getName(), theList.get(0).getMissing(), join, theRequestPartitionId);
            return null;
        }
        ArrayList<Predicate> codePredicates = new ArrayList<Predicate>();
        this.addPartitionIdPredicate(theRequestPartitionId, join, codePredicates);
        for (IQueryParameterType iQueryParameterType : theList) {
            Predicate singleCode = this.createPredicateQuantity(iQueryParameterType, theResourceName, theSearchParam.getName(), this.myCriteriaBuilder, join, theOperation, theRequestPartitionId);
            codePredicates.add(singleCode);
        }
        Predicate retVal = this.myCriteriaBuilder.or(PredicateBuilderQuantity.toArray(codePredicates));
        this.myQueryStack.addPredicateWithImplicitTypeSelection(retVal);
        return retVal;
    }

    public Predicate createPredicateQuantity(IQueryParameterType theParam, String theResourceName, String theParamName, CriteriaBuilder theBuilder, From<?, ResourceIndexedSearchParamQuantity> theFrom, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateQuantity(theParam, theResourceName, theParamName, theBuilder, theFrom, null, theRequestPartitionId);
    }

    private Predicate createPredicateQuantity(IQueryParameterType theParam, String theResourceName, String theParamName, CriteriaBuilder theBuilder, From<?, ResourceIndexedSearchParamQuantity> theFrom, SearchFilterParser.CompareOperation operation, RequestPartitionId theRequestPartitionId) {
        Predicate hashPredicate;
        long hash;
        BigDecimal valueValue;
        String unitsValue;
        String systemValue;
        BaseQuantityDt param;
        ParamPrefixEnum cmpValue = null;
        if (operation == SearchFilterParser.CompareOperation.ne) {
            cmpValue = ParamPrefixEnum.NOT_EQUAL;
        } else if (operation == SearchFilterParser.CompareOperation.lt) {
            cmpValue = ParamPrefixEnum.LESSTHAN;
        } else if (operation == SearchFilterParser.CompareOperation.le) {
            cmpValue = ParamPrefixEnum.LESSTHAN_OR_EQUALS;
        } else if (operation == SearchFilterParser.CompareOperation.gt) {
            cmpValue = ParamPrefixEnum.GREATERTHAN;
        } else if (operation == SearchFilterParser.CompareOperation.ge) {
            cmpValue = ParamPrefixEnum.GREATERTHAN_OR_EQUALS;
        } else if (operation == SearchFilterParser.CompareOperation.eq) {
            cmpValue = ParamPrefixEnum.EQUAL;
        } else if (operation != null) {
            throw new IllegalArgumentException("Invalid operator specified for quantity type");
        }
        if (theParam instanceof BaseQuantityDt) {
            param = (BaseQuantityDt)theParam;
            systemValue = param.getSystemElement().getValueAsString();
            unitsValue = param.getUnitsElement().getValueAsString();
            if (operation == null) {
                cmpValue = ParamPrefixEnum.forValue((String)param.getComparatorElement().getValueAsString());
            }
            valueValue = (BigDecimal)param.getValueElement().getValue();
        } else if (theParam instanceof QuantityParam) {
            param = (QuantityParam)theParam;
            systemValue = param.getSystem();
            unitsValue = param.getUnits();
            if (operation == null) {
                cmpValue = param.getPrefix();
            }
            valueValue = param.getValue();
        } else {
            throw new IllegalArgumentException("Invalid quantity type: " + theParam.getClass());
        }
        if (this.myDontUseHashesForSearch) {
            Predicate system = null;
            if (!StringUtils.isBlank((CharSequence)systemValue)) {
                system = theBuilder.equal((Expression)theFrom.get("mySystem"), (Object)systemValue);
            }
            Predicate code = null;
            if (!StringUtils.isBlank((CharSequence)unitsValue)) {
                code = theBuilder.equal((Expression)theFrom.get("myUnits"), (Object)unitsValue);
            }
            cmpValue = (ParamPrefixEnum)ObjectUtils.defaultIfNull((Object)cmpValue, (Object)ParamPrefixEnum.EQUAL);
            Path path = theFrom.get("myValue");
            String invalidMessageName = "invalidQuantityPrefix";
            Predicate num = this.createPredicateNumeric(theResourceName, null, theFrom, theBuilder, theParam, cmpValue, valueValue, (Expression<BigDecimal>)path, invalidMessageName, theRequestPartitionId);
            Predicate singleCode = system == null && code == null ? num : (system == null ? theBuilder.and((Expression)code, (Expression)num) : (code == null ? theBuilder.and((Expression)system, (Expression)num) : theBuilder.and(new Predicate[]{system, code, num})));
            return this.combineParamIndexPredicateWithParamNamePredicate(theResourceName, theParamName, theFrom, singleCode, theRequestPartitionId);
        }
        if (!StringUtils.isBlank((CharSequence)systemValue) && !StringUtils.isBlank((CharSequence)unitsValue)) {
            hash = ResourceIndexedSearchParamQuantity.calculateHashSystemAndUnits((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)theRequestPartitionId, (String)theResourceName, (String)theParamName, (String)systemValue, (String)unitsValue);
            hashPredicate = this.myCriteriaBuilder.equal((Expression)theFrom.get("myHashIdentitySystemAndUnits"), (Object)hash);
        } else if (!StringUtils.isBlank((CharSequence)unitsValue)) {
            hash = ResourceIndexedSearchParamQuantity.calculateHashUnits((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)theRequestPartitionId, (String)theResourceName, (String)theParamName, (String)unitsValue);
            hashPredicate = this.myCriteriaBuilder.equal((Expression)theFrom.get("myHashIdentityAndUnits"), (Object)hash);
        } else {
            hash = BaseResourceIndexedSearchParam.calculateHashIdentity((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)theRequestPartitionId, (String)theResourceName, (String)theParamName);
            hashPredicate = this.myCriteriaBuilder.equal((Expression)theFrom.get("myHashIdentity"), (Object)hash);
        }
        cmpValue = (ParamPrefixEnum)ObjectUtils.defaultIfNull((Object)cmpValue, (Object)ParamPrefixEnum.EQUAL);
        Path path = theFrom.get("myValue");
        String invalidMessageName = "invalidQuantityPrefix";
        Predicate numericPredicate = this.createPredicateNumeric(theResourceName, null, theFrom, theBuilder, theParam, cmpValue, valueValue, (Expression<BigDecimal>)path, invalidMessageName, theRequestPartitionId);
        return theBuilder.and((Expression)hashPredicate, (Expression)numericPredicate);
    }
}

