/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.predicate;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeChildResourceDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.dao.LegacySearchBuilder;
import ca.uhn.fhir.jpa.dao.index.IdHelperService;
import ca.uhn.fhir.jpa.dao.predicate.BasePredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.PredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinEnum;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamDate;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamString;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.jpa.model.search.StorageProcessingMessage;
import ca.uhn.fhir.jpa.search.builder.QueryStack;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.ResourceMetaParams;
import ca.uhn.fhir.jpa.searchparam.util.JpaParamUtil;
import ca.uhn.fhir.jpa.searchparam.util.SourceParam;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.param.CompositeParam;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.HasParam;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.SpecialParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class PredicateBuilderReference
extends BasePredicateBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(PredicateBuilderReference.class);
    private final PredicateBuilder myPredicateBuilder;
    @Autowired
    IdHelperService myIdHelperService;
    @Autowired
    ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    MatchUrlService myMatchUrlService;
    @Autowired
    DaoRegistry myDaoRegistry;
    @Autowired
    PartitionSettings myPartitionSettings;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;

    public PredicateBuilderReference(LegacySearchBuilder theSearchBuilder, PredicateBuilder thePredicateBuilder) {
        super(theSearchBuilder);
        this.myPredicateBuilder = thePredicateBuilder;
    }

    public Predicate addPredicate(String theResourceName, String theParamName, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation operation, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        Predicate pidPredicate;
        Predicate pathPredicate;
        assert (!theParamName.contains("."));
        if (operation != null && operation != SearchFilterParser.CompareOperation.eq && operation != SearchFilterParser.CompareOperation.ne) {
            throw new InvalidRequestException("Invalid operator specified for reference predicate.  Supported operators for reference predicate are \"eq\" and \"ne\".");
        }
        if (theList.get(0).getMissing() != null) {
            this.addPredicateParamMissingForReference(theResourceName, theParamName, theList.get(0).getMissing(), theRequestPartitionId);
            return null;
        }
        From join = this.myQueryStack.createJoin(SearchBuilderJoinEnum.REFERENCE, theParamName);
        ArrayList<IIdType> targetIds = new ArrayList<IIdType>();
        ArrayList<String> targetQualifiedUrls = new ArrayList<String>();
        for (int orIdx = 0; orIdx < theList.size(); ++orIdx) {
            IQueryParameterType nextOr = theList.get(orIdx);
            if (nextOr instanceof ReferenceParam) {
                ReferenceParam ref = (ReferenceParam)nextOr;
                if (StringUtils.isBlank((CharSequence)ref.getChain())) {
                    IdDt dt = new IdDt(ref.getBaseUrl(), ref.getResourceType(), ref.getIdPart(), null);
                    if (dt.hasBaseUrl()) {
                        if (this.myDaoConfig.getTreatBaseUrlsAsLocal().contains(dt.getBaseUrl())) {
                            dt = dt.toUnqualified();
                            targetIds.add((IIdType)dt);
                            continue;
                        }
                        targetQualifiedUrls.add(dt.getValue());
                        continue;
                    }
                    targetIds.add((IIdType)dt);
                    continue;
                }
                return this.addPredicateReferenceWithChain(theResourceName, theParamName, theList, join, new ArrayList<Predicate>(), ref, theRequest, theRequestPartitionId);
            }
            throw new IllegalArgumentException("Invalid token type (expecting ReferenceParam): " + nextOr.getClass());
        }
        ArrayList<Predicate> codePredicates = new ArrayList<Predicate>();
        this.addPartitionIdPredicate(theRequestPartitionId, join, codePredicates);
        for (IIdType next : targetIds) {
            if (next.hasResourceType()) continue;
            this.warnAboutPerformanceOnUnqualifiedResources(theParamName, theRequest, null);
        }
        List<ResourcePersistentId> targetPids = this.myIdHelperService.resolveResourcePersistentIdsWithCache(theRequestPartitionId, targetIds);
        if (!targetPids.isEmpty()) {
            ourLog.debug("Searching for resource link with target PIDs: {}", targetPids);
            pathPredicate = operation == null || operation == SearchFilterParser.CompareOperation.eq ? this.createResourceLinkPathPredicate(theResourceName, theParamName, join) : this.createResourceLinkPathPredicate(theResourceName, theParamName, join).not();
            pidPredicate = operation == null || operation == SearchFilterParser.CompareOperation.eq ? (targetPids.size() == 1 ? this.myCriteriaBuilder.equal(join.get("myTargetResourcePid").as(Long.class), (Object)targetPids.get(0).getIdAsLong()) : join.get("myTargetResourcePid").in((Collection)ResourcePersistentId.toLongList(targetPids))) : join.get("myTargetResourcePid").in((Collection)ResourcePersistentId.toLongList(targetPids)).not();
            codePredicates.add(this.myCriteriaBuilder.and((Expression)pathPredicate, (Expression)pidPredicate));
        }
        if (!targetQualifiedUrls.isEmpty()) {
            ourLog.debug("Searching for resource link with target URLs: {}", targetQualifiedUrls);
            pathPredicate = operation == null || operation == SearchFilterParser.CompareOperation.eq ? this.createResourceLinkPathPredicate(theResourceName, theParamName, join) : this.createResourceLinkPathPredicate(theResourceName, theParamName, join).not();
            pidPredicate = operation == null || operation == SearchFilterParser.CompareOperation.eq ? join.get("myTargetResourceUrl").in(targetQualifiedUrls) : join.get("myTargetResourceUrl").in(targetQualifiedUrls).not();
            codePredicates.add(this.myCriteriaBuilder.and((Expression)pathPredicate, (Expression)pidPredicate));
        }
        if (codePredicates.size() > 0) {
            Predicate predicate = this.myCriteriaBuilder.or(PredicateBuilderReference.toArray(codePredicates));
            this.myQueryStack.addPredicateWithImplicitTypeSelection(predicate);
            return predicate;
        }
        return this.myQueryStack.addNeverMatchingPredicate();
    }

    private Predicate addPredicateReferenceWithChain(String theResourceName, String theParamName, List<? extends IQueryParameterType> theList, From<?, ResourceLink> theJoin, List<Predicate> theCodePredicates, ReferenceParam theReferenceParam, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        List<Class<? extends IBaseResource>> resourceTypes = this.determineCandidateResourceTypesForChain(theResourceName, theParamName, theReferenceParam);
        if ("_type".equals(theReferenceParam.getChain())) {
            return this.createChainPredicateOnType(theResourceName, theParamName, theJoin, theReferenceParam, resourceTypes);
        }
        boolean foundChainMatch = false;
        ArrayList<Class<? extends IBaseResource>> candidateTargetTypes = new ArrayList<Class<? extends IBaseResource>>();
        for (Class<? extends IBaseResource> nextType : resourceTypes) {
            String chain = theReferenceParam.getChain();
            String remainingChain = null;
            int chainDotIndex = chain.indexOf(46);
            if (chainDotIndex != -1) {
                remainingChain = chain.substring(chainDotIndex + 1);
                chain = chain.substring(0, chainDotIndex);
            }
            RuntimeResourceDefinition typeDef = this.myContext.getResourceDefinition(nextType);
            String subResourceName = typeDef.getName();
            IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(nextType);
            if (dao == null) {
                ourLog.debug("Don't have a DAO for type {}", (Object)nextType.getSimpleName());
                continue;
            }
            int qualifierIndex = chain.indexOf(58);
            String qualifier = null;
            if (qualifierIndex != -1) {
                qualifier = chain.substring(qualifierIndex);
                chain = chain.substring(0, qualifierIndex);
            }
            boolean isMeta = ResourceMetaParams.RESOURCE_META_PARAMS.containsKey(chain);
            RuntimeSearchParam param = null;
            if (!isMeta && (param = this.mySearchParamRegistry.getActiveSearchParam(subResourceName, chain)) == null) {
                ourLog.debug("Type {} doesn't have search param {}", (Object)subResourceName, (Object)param);
                continue;
            }
            ArrayList orValues = Lists.newArrayList();
            for (IQueryParameterType iQueryParameterType : theList) {
                String nextValue = iQueryParameterType.getValueAsQueryToken(this.myContext);
                IQueryParameterType chainValue = this.mapReferenceChainToRawParamType(remainingChain, param, theParamName, qualifier, nextType, chain, isMeta, nextValue);
                if (chainValue == null) continue;
                foundChainMatch = true;
                orValues.add(chainValue);
            }
            if (!foundChainMatch) continue;
            Subquery<Long> subQ = this.createLinkSubquery(chain, subResourceName, orValues, theRequest, theRequestPartitionId);
            Predicate predicate = this.createResourceLinkPathPredicate(theResourceName, theParamName, theJoin);
            Predicate pidPredicate = theJoin.get("myTargetResourcePid").in(new Expression[]{subQ});
            Predicate andPredicate = this.myCriteriaBuilder.and((Expression)predicate, (Expression)pidPredicate);
            theCodePredicates.add(andPredicate);
            candidateTargetTypes.add(nextType);
        }
        if (!foundChainMatch) {
            throw new InvalidRequestException(this.myContext.getLocalizer().getMessage(BaseHapiFhirResourceDao.class, "invalidParameterChain", new Object[]{theParamName + '.' + theReferenceParam.getChain()}));
        }
        if (candidateTargetTypes.size() > 1) {
            this.warnAboutPerformanceOnUnqualifiedResources(theParamName, theRequest, candidateTargetTypes);
        }
        Predicate predicate = this.myCriteriaBuilder.or(PredicateBuilderReference.toArray(theCodePredicates));
        this.myQueryStack.addPredicateWithImplicitTypeSelection(predicate);
        return predicate;
    }

    private Predicate createChainPredicateOnType(String theResourceName, String theParamName, From<?, ResourceLink> theJoin, ReferenceParam theReferenceParam, List<Class<? extends IBaseResource>> theResourceTypes) {
        Class wantedType;
        String typeValue = theReferenceParam.getValue();
        try {
            wantedType = this.myContext.getResourceDefinition(typeValue).getImplementingClass();
        }
        catch (DataFormatException e) {
            throw this.newInvalidResourceTypeException(typeValue);
        }
        if (!theResourceTypes.contains(wantedType)) {
            throw this.newInvalidTargetTypeForChainException(theResourceName, theParamName, typeValue);
        }
        Predicate pathPredicate = this.createResourceLinkPathPredicate(theResourceName, theParamName, theJoin);
        Predicate sourceTypeParameter = this.myCriteriaBuilder.equal((Expression)theJoin.get("mySourceResourceType"), (Object)this.myResourceName);
        Predicate targetTypeParameter = this.myCriteriaBuilder.equal((Expression)theJoin.get("myTargetResourceType"), (Object)typeValue);
        Predicate composite = this.myCriteriaBuilder.and(new Predicate[]{pathPredicate, sourceTypeParameter, targetTypeParameter});
        this.myQueryStack.addPredicate(composite);
        return composite;
    }

    @Nonnull
    private List<Class<? extends IBaseResource>> determineCandidateResourceTypesForChain(String theResourceName, String theParamName, ReferenceParam theReferenceParam) {
        ArrayList<Class<? extends IBaseResource>> resourceTypes;
        block16: {
            block15: {
                if (theReferenceParam.hasResourceType()) break block15;
                RuntimeSearchParam param = this.mySearchParamRegistry.getActiveSearchParam(theResourceName, theParamName);
                resourceTypes = new ArrayList<Class<? extends IBaseResource>>();
                if (param.hasTargets()) {
                    Set targetTypes = param.getTargets();
                    for (String next : targetTypes) {
                        resourceTypes.add(this.myContext.getResourceDefinition(next).getImplementingClass());
                    }
                }
                if (resourceTypes.isEmpty()) {
                    BaseRuntimeChildDefinition def;
                    RuntimeSearchParam searchParamByName = this.mySearchParamRegistry.getActiveSearchParam(theResourceName, theParamName);
                    if (searchParamByName == null) {
                        throw new InternalErrorException("Could not find parameter " + theParamName);
                    }
                    String paramPath = searchParamByName.getPath();
                    if (paramPath.endsWith(".as(Reference)")) {
                        paramPath = paramPath.substring(0, paramPath.length() - ".as(Reference)".length()) + "Reference";
                    }
                    if (paramPath.contains(".extension(")) {
                        int startIdx = paramPath.indexOf(".extension(");
                        int endIdx = paramPath.indexOf(41, startIdx);
                        if (startIdx != -1 && endIdx != -1) {
                            paramPath = paramPath.substring(0, startIdx + 10) + paramPath.substring(endIdx + 1);
                        }
                    }
                    if ((def = this.myContext.newTerser().getDefinition(this.myResourceType, paramPath)) instanceof RuntimeChildChoiceDefinition) {
                        RuntimeChildChoiceDefinition choiceDef = (RuntimeChildChoiceDefinition)def;
                        resourceTypes.addAll(choiceDef.getResourceTypes());
                    } else if (def instanceof RuntimeChildResourceDefinition) {
                        RuntimeChildResourceDefinition resDef = (RuntimeChildResourceDefinition)def;
                        resourceTypes.addAll(resDef.getResourceTypes());
                        if (resourceTypes.size() == 1 && ((Class)resourceTypes.get(0)).isInterface()) {
                            throw new InvalidRequestException("Unable to perform search for unqualified chain '" + theParamName + "' as this SearchParameter does not declare any target types. Add a qualifier of the form '" + theParamName + ":[ResourceType]' to perform this search.");
                        }
                    } else {
                        throw new ConfigurationException("Property " + paramPath + " of type " + this.myResourceName + " is not a resource: " + def.getClass());
                    }
                }
                if (!resourceTypes.isEmpty()) break block16;
                for (BaseRuntimeElementDefinition next : this.myContext.getElementDefinitions()) {
                    if (!(next instanceof RuntimeResourceDefinition)) continue;
                    RuntimeResourceDefinition nextResDef = (RuntimeResourceDefinition)next;
                    resourceTypes.add(nextResDef.getImplementingClass());
                }
                break block16;
            }
            try {
                RuntimeResourceDefinition resDef = this.myContext.getResourceDefinition(theReferenceParam.getResourceType());
                resourceTypes = new ArrayList(1);
                resourceTypes.add(resDef.getImplementingClass());
            }
            catch (DataFormatException e) {
                throw this.newInvalidResourceTypeException(theReferenceParam.getResourceType());
            }
        }
        return resourceTypes;
    }

    private void warnAboutPerformanceOnUnqualifiedResources(String theParamName, RequestDetails theRequest, @Nullable List<Class<? extends IBaseResource>> theCandidateTargetTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append("This search uses an unqualified resource(a parameter in a chain without a resource type). ");
        builder.append("This is less efficient than using a qualified type. ");
        if (theCandidateTargetTypes != null) {
            builder.append("[" + theParamName + "] resolves to [" + theCandidateTargetTypes.stream().map(Class::getSimpleName).collect(Collectors.joining(",")) + "].");
            builder.append("If you know what you're looking for, try qualifying it using the form ");
            builder.append(theCandidateTargetTypes.stream().map(cls -> "[" + cls.getSimpleName() + ":" + theParamName + "]").collect(Collectors.joining(" or ")));
        } else {
            builder.append("If you know what you're looking for, try qualifying it using the form: '");
            builder.append(theParamName).append(":[resourceType]");
            builder.append("'");
        }
        String message = builder.toString();
        StorageProcessingMessage msg = new StorageProcessingMessage().setMessage(message);
        HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(StorageProcessingMessage.class, (Object)msg);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.JPA_PERFTRACE_WARNING, (HookParams)params);
    }

    Predicate createResourceLinkPathPredicate(String theResourceName, String theParamName, From<?, ? extends ResourceLink> from) {
        RuntimeSearchParam param = this.mySearchParamRegistry.getActiveSearchParam(theResourceName, theParamName);
        ArrayList path = param.getPathsSplit();
        path = new ArrayList(path);
        ListIterator iter = path.listIterator();
        while (iter.hasNext()) {
            String nextPath = StringUtils.trim((String)((String)iter.next()));
            if (nextPath.contains(theResourceName + ".")) continue;
            iter.remove();
        }
        return from.get("mySourcePath").in(path);
    }

    private IQueryParameterType mapReferenceChainToRawParamType(String remainingChain, RuntimeSearchParam param, String theParamName, String qualifier, Class<? extends IBaseResource> nextType, String chain, boolean isMeta, String resourceId) {
        IQueryParameterType chainValue;
        if (remainingChain != null) {
            if (param == null || param.getParamType() != RestSearchParameterTypeEnum.REFERENCE) {
                ourLog.debug("Type {} parameter {} is not a reference, can not chain {}", new Object[]{nextType.getSimpleName(), chain, remainingChain});
                return null;
            }
            chainValue = new ReferenceParam();
            chainValue.setValueAsQueryToken(this.myContext, theParamName, qualifier, resourceId);
            ((ReferenceParam)chainValue).setChain(remainingChain);
        } else if (isMeta) {
            IQueryParameterType type = this.myMatchUrlService.newInstanceType(chain);
            type.setValueAsQueryToken(this.myContext, theParamName, qualifier, resourceId);
            chainValue = type;
        } else {
            chainValue = this.toParameterType(param, qualifier, resourceId);
        }
        return chainValue;
    }

    Subquery<Long> createLinkSubquery(String theChain, String theSubResourceName, List<IQueryParameterType> theOrValues, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        RuntimeSearchParam nextParamDef = this.mySearchParamRegistry.getActiveSearchParam(theSubResourceName, theChain);
        if (nextParamDef != null && !theChain.startsWith("_")) {
            this.myQueryStack.pushIndexTableSubQuery();
        } else {
            this.myQueryStack.pushResourceTableSubQuery(theSubResourceName);
        }
        ArrayList<List<IQueryParameterType>> andOrParams = new ArrayList<List<IQueryParameterType>>();
        andOrParams.add(theOrValues);
        this.searchForIdsWithAndOr(theSubResourceName, theChain, andOrParams, theRequest, theRequestPartitionId);
        return (Subquery)this.myQueryStack.pop();
    }

    void searchForIdsWithAndOr(String theResourceName, String theParamName, List<List<IQueryParameterType>> theAndOrParams, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        if (theAndOrParams.isEmpty()) {
            return;
        }
        block10 : switch (theParamName) {
            case "_id": {
                this.myPredicateBuilder.addPredicateResourceId(theAndOrParams, theResourceName, theRequestPartitionId);
                break;
            }
            case "_language": {
                this.addPredicateLanguage(theAndOrParams, null);
                break;
            }
            case "_has": {
                this.addPredicateHas(theResourceName, theAndOrParams, theRequest, theRequestPartitionId);
                break;
            }
            case "_tag": 
            case "_profile": 
            case "_security": {
                this.myPredicateBuilder.addPredicateTag(theAndOrParams, theParamName, theRequestPartitionId);
                break;
            }
            case "_source": {
                this.addPredicateSource(theAndOrParams, theRequest);
                break;
            }
            default: {
                RuntimeSearchParam nextParamDef = this.mySearchParamRegistry.getActiveSearchParam(theResourceName, theParamName);
                if (nextParamDef != null) {
                    if (this.myPartitionSettings.isPartitioningEnabled() && this.myPartitionSettings.isIncludePartitionInSearchHashes() && theRequestPartitionId.isAllPartitions()) {
                        throw new PreconditionFailedException("This server is not configured to support search against all partitions");
                    }
                    switch (nextParamDef.getParamType()) {
                        case DATE: {
                            for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                                SearchFilterParser.CompareOperation operation = null;
                                if (nextAnd.size() > 0) {
                                    DateParam param = (DateParam)nextAnd.get(0);
                                    operation = QueryStack.toOperation(param.getPrefix());
                                }
                                this.myPredicateBuilder.addPredicateDate(theResourceName, nextParamDef, nextAnd, operation, theRequestPartitionId);
                            }
                            break block10;
                        }
                        case QUANTITY: {
                            for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                                this.myPredicateBuilder.addPredicateQuantity(theResourceName, nextParamDef, nextAnd, null, theRequestPartitionId);
                            }
                            break block10;
                        }
                        case REFERENCE: {
                            for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                                this.addPredicate(theResourceName, theParamName, nextAnd, null, theRequest, theRequestPartitionId);
                            }
                            break block10;
                        }
                        case STRING: {
                            for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                                this.myPredicateBuilder.addPredicateString(theResourceName, nextParamDef, nextAnd, SearchFilterParser.CompareOperation.sw, theRequestPartitionId);
                            }
                            break block10;
                        }
                        case TOKEN: {
                            for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                                if ("Location.position".equals(nextParamDef.getPath())) {
                                    this.myPredicateBuilder.addPredicateCoords(theResourceName, nextParamDef, nextAnd, theRequestPartitionId);
                                    continue;
                                }
                                this.myPredicateBuilder.addPredicateToken(theResourceName, nextParamDef, nextAnd, null, theRequestPartitionId);
                            }
                            break block10;
                        }
                        case NUMBER: {
                            for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                                this.myPredicateBuilder.addPredicateNumber(theResourceName, nextParamDef, nextAnd, null, theRequestPartitionId);
                            }
                            break block10;
                        }
                        case COMPOSITE: {
                            for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                                this.addPredicateComposite(theResourceName, nextParamDef, nextAnd, theRequestPartitionId);
                            }
                            break block10;
                        }
                        case URI: {
                            for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                                this.myPredicateBuilder.addPredicateUri(theResourceName, nextParamDef, nextAnd, SearchFilterParser.CompareOperation.eq, theRequestPartitionId);
                            }
                            break block10;
                        }
                        case HAS: 
                        case SPECIAL: {
                            for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                                if (!"Location.position".equals(nextParamDef.getPath())) continue;
                                this.myPredicateBuilder.addPredicateCoords(theResourceName, nextParamDef, nextAnd, theRequestPartitionId);
                            }
                        }
                    }
                    break;
                }
                if ("_content".equals(theParamName) || "_text".equals(theParamName)) break;
                if ("_filter".equals(theParamName)) {
                    SearchFilterParser.Filter filter;
                    if (!(theAndOrParams.get(0).get(0) instanceof StringParam)) break;
                    String filterString = ((StringParam)theAndOrParams.get(0).get(0)).getValue();
                    try {
                        filter = SearchFilterParser.parse(filterString);
                    }
                    catch (SearchFilterParser.FilterSyntaxException theE) {
                        throw new InvalidRequestException("Error parsing _filter syntax: " + theE.getMessage());
                    }
                    if (filter == null) break;
                    if (!this.myDaoConfig.isFilterParameterEnabled()) {
                        throw new InvalidRequestException("_filter parameter is disabled on this server");
                    }
                    ArrayList<Predicate> holdPredicates = new ArrayList<Predicate>(this.myQueryStack.getPredicates());
                    Predicate filterPredicate = this.processFilter(filter, theResourceName, theRequest, theRequestPartitionId);
                    this.myQueryStack.clearPredicates();
                    this.myQueryStack.addPredicates(holdPredicates);
                    this.myQueryStack.addPredicate(filterPredicate);
                    this.myQueryStack.clearHasImplicitTypeSelection();
                    break;
                }
                Collection validNames = this.mySearchParamRegistry.getValidSearchParameterNamesIncludingMeta(theResourceName);
                String msg = this.myContext.getLocalizer().getMessageSanitized(BaseHapiFhirResourceDao.class, "invalidSearchParameter", new Object[]{theParamName, theResourceName, validNames});
                throw new InvalidRequestException(msg);
            }
        }
    }

    private Predicate processFilter(SearchFilterParser.Filter theFilter, String theResourceName, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        if (theFilter instanceof SearchFilterParser.FilterParameter) {
            return this.processFilterParameter((SearchFilterParser.FilterParameter)theFilter, theResourceName, theRequest, theRequestPartitionId);
        }
        if (theFilter instanceof SearchFilterParser.FilterLogical) {
            Predicate xPredicate = this.processFilter(((SearchFilterParser.FilterLogical)theFilter).getFilter1(), theResourceName, theRequest, theRequestPartitionId);
            Predicate yPredicate = this.processFilter(((SearchFilterParser.FilterLogical)theFilter).getFilter2(), theResourceName, theRequest, theRequestPartitionId);
            if (((SearchFilterParser.FilterLogical)theFilter).getOperation() == SearchFilterParser.FilterLogicalOperation.and) {
                return this.myCriteriaBuilder.and((Expression)xPredicate, (Expression)yPredicate);
            }
            if (((SearchFilterParser.FilterLogical)theFilter).getOperation() == SearchFilterParser.FilterLogicalOperation.or) {
                return this.myCriteriaBuilder.or((Expression)xPredicate, (Expression)yPredicate);
            }
        } else if (theFilter instanceof SearchFilterParser.FilterParameterGroup) {
            return this.processFilter(((SearchFilterParser.FilterParameterGroup)theFilter).getContained(), theResourceName, theRequest, theRequestPartitionId);
        }
        return null;
    }

    private Predicate processFilterParameter(SearchFilterParser.FilterParameter theFilter, String theResourceName, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        if (theFilter.getParamPath().getName().equals("_source")) {
            TokenParam param = new TokenParam();
            param.setValueAsQueryToken(null, null, null, theFilter.getValue());
            return this.addPredicateSource(Collections.singletonList(param), theFilter.getOperation(), theRequest);
        }
        if (theFilter.getParamPath().getName().equals("_id")) {
            TokenParam param = new TokenParam();
            param.setValueAsQueryToken(null, null, null, theFilter.getValue());
            return this.myPredicateBuilder.addPredicateResourceId(Collections.singletonList(Collections.singletonList(param)), this.myResourceName, theFilter.getOperation(), theRequestPartitionId);
        }
        if (theFilter.getParamPath().getName().equals("_language")) {
            return this.addPredicateLanguage(Collections.singletonList(Collections.singletonList(new StringParam(theFilter.getValue()))), theFilter.getOperation());
        }
        RuntimeSearchParam searchParam = this.mySearchParamRegistry.getActiveSearchParam(theResourceName, theFilter.getParamPath().getName());
        if (searchParam == null) {
            throw new InvalidRequestException("Invalid search parameter specified, " + theFilter.getParamPath().getName() + ", for resource type " + theResourceName);
        }
        RestSearchParameterTypeEnum typeEnum = searchParam.getParamType();
        if (typeEnum == RestSearchParameterTypeEnum.URI) {
            return this.myPredicateBuilder.addPredicateUri(theResourceName, searchParam, Collections.singletonList(new UriParam(theFilter.getValue())), theFilter.getOperation(), theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.STRING) {
            return this.myPredicateBuilder.addPredicateString(theResourceName, searchParam, Collections.singletonList(new StringParam(theFilter.getValue())), theFilter.getOperation(), theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.DATE) {
            return this.myPredicateBuilder.addPredicateDate(theResourceName, searchParam, Collections.singletonList(new DateParam(QueryStack.fromOperation(theFilter.getOperation()), theFilter.getValue())), theFilter.getOperation(), theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.NUMBER) {
            return this.myPredicateBuilder.addPredicateNumber(theResourceName, searchParam, Collections.singletonList(new NumberParam(theFilter.getValue())), theFilter.getOperation(), theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.REFERENCE) {
            String paramName = theFilter.getParamPath().getName();
            SearchFilterParser.CompareOperation operation = theFilter.getOperation();
            String resourceType = null;
            String chain = theFilter.getParamPath().getNext() != null ? theFilter.getParamPath().getNext().toString() : null;
            String value = theFilter.getValue();
            ReferenceParam referenceParam = new ReferenceParam(resourceType, chain, value);
            return this.addPredicate(theResourceName, paramName, Collections.singletonList(referenceParam), operation, theRequest, theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.QUANTITY) {
            return this.myPredicateBuilder.addPredicateQuantity(theResourceName, searchParam, Collections.singletonList(new QuantityParam(theFilter.getValue())), theFilter.getOperation(), theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.COMPOSITE) {
            throw new InvalidRequestException("Composite search parameters not currently supported with _filter clauses");
        }
        if (typeEnum == RestSearchParameterTypeEnum.TOKEN) {
            TokenParam param = new TokenParam();
            param.setValueAsQueryToken(null, null, null, theFilter.getValue());
            return this.myPredicateBuilder.addPredicateToken(theResourceName, searchParam, Collections.singletonList(param), theFilter.getOperation(), theRequestPartitionId);
        }
        return null;
    }

    private IQueryParameterType toParameterType(RuntimeSearchParam theParam) {
        DateParam qp;
        switch (theParam.getParamType()) {
            case DATE: {
                qp = new DateParam();
                break;
            }
            case NUMBER: {
                qp = new NumberParam();
                break;
            }
            case QUANTITY: {
                qp = new QuantityParam();
                break;
            }
            case STRING: {
                qp = new StringParam();
                break;
            }
            case TOKEN: {
                qp = new TokenParam();
                break;
            }
            case COMPOSITE: {
                List compositeOf = JpaParamUtil.resolveComponentParameters((ISearchParamRegistry)this.mySearchParamRegistry, (RuntimeSearchParam)theParam);
                if (compositeOf.size() != 2) {
                    throw new InternalErrorException("Parameter " + theParam.getName() + " has " + compositeOf.size() + " composite parts. Don't know how handlt this.");
                }
                IQueryParameterType leftParam = this.toParameterType((RuntimeSearchParam)compositeOf.get(0));
                IQueryParameterType rightParam = this.toParameterType((RuntimeSearchParam)compositeOf.get(1));
                qp = new CompositeParam(leftParam, rightParam);
                break;
            }
            case REFERENCE: {
                qp = new ReferenceParam();
                break;
            }
            case SPECIAL: {
                if ("Location.position".equals(theParam.getPath())) {
                    qp = new SpecialParam();
                    break;
                }
                throw new InternalErrorException("Don't know how to convert param type: " + theParam.getParamType());
            }
            default: {
                throw new InternalErrorException("Don't know how to convert param type: " + theParam.getParamType());
            }
        }
        return qp;
    }

    private IQueryParameterType toParameterType(RuntimeSearchParam theParam, String theQualifier, String theValueAsQueryToken) {
        IQueryParameterType qp = this.toParameterType(theParam);
        qp.setValueAsQueryToken(this.myContext, theParam.getName(), theQualifier, theValueAsQueryToken);
        return qp;
    }

    private Predicate addPredicateLanguage(List<List<IQueryParameterType>> theList, SearchFilterParser.CompareOperation operation) {
        for (List<IQueryParameterType> nextList : theList) {
            Predicate predicate;
            HashSet<String> values = new HashSet<String>();
            for (IQueryParameterType next : nextList) {
                if (next instanceof StringParam) {
                    String nextValue = ((StringParam)next).getValue();
                    if (StringUtils.isBlank((CharSequence)nextValue)) continue;
                    values.add(nextValue);
                    continue;
                }
                throw new InternalErrorException("Language parameter must be of type " + StringParam.class.getCanonicalName() + " - Got " + next.getClass().getCanonicalName());
            }
            if (values.isEmpty()) continue;
            if (operation == null || operation == SearchFilterParser.CompareOperation.eq) {
                predicate = this.myQueryStack.get("myLanguage").as(String.class).in(values);
            } else if (operation == SearchFilterParser.CompareOperation.ne) {
                predicate = this.myQueryStack.get("myLanguage").as(String.class).in(values).not();
            } else {
                throw new InvalidRequestException("Unsupported operator specified in language query, only \"eq\" and \"ne\" are supported");
            }
            this.myQueryStack.addPredicate(predicate);
            if (operation == null) continue;
            return predicate;
        }
        return null;
    }

    private void addPredicateSource(List<List<IQueryParameterType>> theAndOrParams, RequestDetails theRequest) {
        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
            this.addPredicateSource(nextAnd, SearchFilterParser.CompareOperation.eq, theRequest);
        }
    }

    private Predicate addPredicateSource(List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestDetails theRequest) {
        assert (theOperation == SearchFilterParser.CompareOperation.eq);
        if (this.myDaoConfig.getStoreMetaSourceInformation() == DaoConfig.StoreMetaSourceInformationEnum.NONE) {
            String msg = this.myContext.getLocalizer().getMessage(LegacySearchBuilder.class, "sourceParamDisabled", new Object[0]);
            throw new InvalidRequestException(msg);
        }
        From join = this.myQueryStack.createJoin(SearchBuilderJoinEnum.PROVENANCE, "_source");
        ArrayList<Predicate> codePredicates = new ArrayList<Predicate>();
        for (IQueryParameterType iQueryParameterType : theList) {
            SourceParam sourceParameter = new SourceParam(iQueryParameterType.getValueAsQueryToken(this.myContext));
            String sourceUri = sourceParameter.getSourceUri();
            String requestId = sourceParameter.getRequestId();
            Predicate sourceUriPredicate = this.myCriteriaBuilder.equal((Expression)join.get("mySourceUri"), (Object)sourceUri);
            Predicate requestIdPredicate = this.myCriteriaBuilder.equal((Expression)join.get("myRequestId"), (Object)requestId);
            if (StringUtils.isNotBlank((CharSequence)sourceUri) && StringUtils.isNotBlank((CharSequence)requestId)) {
                codePredicates.add(this.myCriteriaBuilder.and((Expression)sourceUriPredicate, (Expression)requestIdPredicate));
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)sourceUri)) {
                codePredicates.add(sourceUriPredicate);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)requestId)) continue;
            codePredicates.add(requestIdPredicate);
        }
        Predicate retVal = this.myCriteriaBuilder.or(PredicateBuilderReference.toArray(codePredicates));
        this.myQueryStack.addPredicate(retVal);
        return retVal;
    }

    private void addPredicateHas(String theResourceType, List<List<IQueryParameterType>> theHasParameters, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        for (List<IQueryParameterType> nextOrList : theHasParameters) {
            String targetResourceType = null;
            String paramReference = null;
            String parameterName = null;
            String paramName = null;
            ArrayList<QualifiedParamList> parameters = new ArrayList<QualifiedParamList>();
            for (IQueryParameterType nextParam : nextOrList) {
                HasParam next = (HasParam)nextParam;
                targetResourceType = next.getTargetResourceType();
                paramReference = next.getReferenceFieldName();
                parameterName = next.getParameterName();
                paramName = parameterName.replaceAll("\\..*", "");
                parameters.add(QualifiedParamList.singleton(null, (String)next.getValueAsQueryToken(this.myContext)));
            }
            if (paramName == null) continue;
            try {
                RuntimeResourceDefinition targetResourceDefinition = this.myContext.getResourceDefinition(targetResourceType);
            }
            catch (DataFormatException e) {
                throw new InvalidRequestException("Invalid resource type: " + targetResourceType);
            }
            ArrayList orValues = Lists.newArrayList();
            if (paramName.startsWith("_has:")) {
                ourLog.trace("Handing double _has query: {}", (Object)paramName);
                String qualifier = paramName.substring(4);
                paramName = "_has";
                for (IQueryParameterType next : nextOrList) {
                    HasParam nextHasParam = new HasParam();
                    nextHasParam.setValueAsQueryToken(this.myContext, "_has", qualifier, next.getValueAsQueryToken(this.myContext));
                    orValues.add(nextHasParam);
                }
            } else {
                RuntimeSearchParam owningParameterDef = this.mySearchParamRegistry.getActiveSearchParam(targetResourceType, paramName);
                if (owningParameterDef == null) {
                    throw new InvalidRequestException("Unknown parameter name: " + targetResourceType + ':' + parameterName);
                }
                RuntimeSearchParam joiningParameterDef = this.mySearchParamRegistry.getActiveSearchParam(targetResourceType, paramReference);
                if (joiningParameterDef == null) {
                    throw new InvalidRequestException("Unknown parameter name: " + targetResourceType + ':' + paramReference);
                }
                IQueryParameterAnd parsedParam = JpaParamUtil.parseQueryParams((ISearchParamRegistry)this.mySearchParamRegistry, (FhirContext)this.myContext, (RuntimeSearchParam)owningParameterDef, (String)paramName, parameters);
                for (IQueryParameterOr next : parsedParam.getValuesAsQueryTokens()) {
                    orValues.addAll(next.getValuesAsQueryTokens());
                }
            }
            if (parameterName.contains(".")) {
                String chainedPartOfParameter = this.getChainedPart(parameterName);
                orValues.stream().filter(qp -> qp instanceof ReferenceParam).map(qp -> (ReferenceParam)qp).forEach(rp -> rp.setChain(this.getChainedPart(chainedPartOfParameter)));
            }
            Subquery<Long> subQ = this.myPredicateBuilder.createLinkSubquery(paramName, targetResourceType, orValues, theRequest, theRequestPartitionId);
            Join join = (Join)this.myQueryStack.createJoin(SearchBuilderJoinEnum.HAS, "_has");
            Predicate pathPredicate = this.myPredicateBuilder.createResourceLinkPathPredicate(targetResourceType, paramReference, join);
            Predicate sourceTypePredicate = this.myCriteriaBuilder.equal((Expression)join.get("myTargetResourceType"), (Object)theResourceType);
            Predicate sourcePidPredicate = join.get("mySourceResourcePid").in(new Expression[]{subQ});
            Predicate andPredicate = this.myCriteriaBuilder.and(new Predicate[]{pathPredicate, sourcePidPredicate, sourceTypePredicate});
            this.myQueryStack.addPredicate(andPredicate);
        }
    }

    private String getChainedPart(String parameter) {
        return parameter.substring(parameter.indexOf(".") + 1);
    }

    private void addPredicateComposite(String theResourceName, RuntimeSearchParam theParamDef, List<? extends IQueryParameterType> theNextAnd, RequestPartitionId theRequestPartitionId) {
        IQueryParameterType or = theNextAnd.get(0);
        if (!(or instanceof CompositeParam)) {
            throw new InvalidRequestException("Invalid type for composite param (must be " + CompositeParam.class.getSimpleName() + ": " + or.getClass());
        }
        CompositeParam cp = (CompositeParam)or;
        List componentParams = JpaParamUtil.resolveComponentParameters((ISearchParamRegistry)this.mySearchParamRegistry, (RuntimeSearchParam)theParamDef);
        RuntimeSearchParam left = (RuntimeSearchParam)componentParams.get(0);
        IQueryParameterType leftValue = cp.getLeftValue();
        this.myQueryStack.addPredicate(this.createCompositeParamPart(theResourceName, this.myQueryStack.getRootForComposite(), left, leftValue, theRequestPartitionId));
        RuntimeSearchParam right = (RuntimeSearchParam)componentParams.get(1);
        IQueryParameterType rightValue = cp.getRightValue();
        this.myQueryStack.addPredicate(this.createCompositeParamPart(theResourceName, this.myQueryStack.getRootForComposite(), right, rightValue, theRequestPartitionId));
    }

    private Predicate createCompositeParamPart(String theResourceName, Root<?> theRoot, RuntimeSearchParam theParam, IQueryParameterType leftValue, RequestPartitionId theRequestPartitionId) {
        Predicate retVal = null;
        switch (theParam.getParamType()) {
            case STRING: {
                Join stringJoin = theRoot.join("myParamsString", JoinType.INNER);
                retVal = this.myPredicateBuilder.createPredicateString(leftValue, theResourceName, theParam, this.myCriteriaBuilder, (From<ResourceIndexedSearchParamString, ResourceIndexedSearchParamString>)stringJoin, theRequestPartitionId);
                break;
            }
            case TOKEN: {
                Join tokenJoin = theRoot.join("myParamsToken", JoinType.INNER);
                List<IQueryParameterType> tokens = Collections.singletonList(leftValue);
                Collection<Predicate> tokenPredicates = this.myPredicateBuilder.createPredicateToken(tokens, theResourceName, theParam, this.myCriteriaBuilder, (From<ResourceIndexedSearchParamToken, ResourceIndexedSearchParamToken>)tokenJoin, theRequestPartitionId);
                retVal = this.myCriteriaBuilder.and(tokenPredicates.toArray(new Predicate[0]));
                break;
            }
            case DATE: {
                Join dateJoin = theRoot.join("myParamsDate", JoinType.INNER);
                retVal = this.myPredicateBuilder.createPredicateDate(leftValue, theResourceName, theParam.getName(), this.myCriteriaBuilder, (From<ResourceIndexedSearchParamDate, ResourceIndexedSearchParamDate>)dateJoin, theRequestPartitionId);
                break;
            }
            case QUANTITY: {
                Join dateJoin = theRoot.join("myParamsQuantity", JoinType.INNER);
                retVal = this.myPredicateBuilder.createPredicateQuantity(leftValue, theResourceName, theParam.getName(), this.myCriteriaBuilder, (From<ResourceIndexedSearchParamQuantity, ResourceIndexedSearchParamQuantity>)dateJoin, theRequestPartitionId);
                break;
            }
        }
        if (retVal == null) {
            throw new InvalidRequestException("Don't know how to handle composite parameter with type of " + theParam.getParamType());
        }
        return retVal;
    }

    @Nonnull
    private InvalidRequestException newInvalidTargetTypeForChainException(String theResourceName, String theParamName, String theTypeValue) {
        String searchParamName = theResourceName + ":" + theParamName;
        String msg = this.myContext.getLocalizer().getMessage(PredicateBuilderReference.class, "invalidTargetTypeForChain", new Object[]{theTypeValue, searchParamName});
        return new InvalidRequestException(msg);
    }

    @Nonnull
    private InvalidRequestException newInvalidResourceTypeException(String theResourceType) {
        String msg = this.myContext.getLocalizer().getMessageSanitized(PredicateBuilderReference.class, "invalidResourceType", new Object[]{theResourceType});
        throw new InvalidRequestException(msg);
    }
}

