/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.predicate;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.LegacySearchBuilder;
import ca.uhn.fhir.jpa.dao.index.IdHelperService;
import ca.uhn.fhir.jpa.dao.predicate.BasePredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.IdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class PredicateBuilderResourceId
extends BasePredicateBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(PredicateBuilderResourceId.class);
    @Autowired
    IdHelperService myIdHelperService;

    public PredicateBuilderResourceId(LegacySearchBuilder theSearchBuilder) {
        super(theSearchBuilder);
    }

    @Nullable
    Predicate addPredicateResourceId(List<List<IQueryParameterType>> theValues, String theResourceName, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        Predicate nextPredicate = this.createPredicate(theResourceName, theValues, theOperation, theRequestPartitionId);
        if (nextPredicate != null) {
            this.myQueryStack.addPredicate(nextPredicate);
            return nextPredicate;
        }
        return null;
    }

    @Nullable
    private Predicate createPredicate(String theResourceName, List<List<IQueryParameterType>> theValues, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        Predicate nextPredicate = null;
        HashSet<ResourcePersistentId> allOrPids = null;
        for (List<IQueryParameterType> nextValue : theValues) {
            HashSet<ResourcePersistentId> orPids = new HashSet<ResourcePersistentId>();
            boolean haveValue = false;
            for (IQueryParameterType next : nextValue) {
                String value = next.getValueAsQueryToken(this.myContext);
                if (value != null && value.startsWith("|")) {
                    value = value.substring(1);
                }
                IdType valueAsId = new IdType(value);
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                haveValue = true;
                try {
                    ResourcePersistentId pid = this.myIdHelperService.resolveResourcePersistentIds(theRequestPartitionId, theResourceName, valueAsId.getIdPart());
                    orPids.add(pid);
                }
                catch (ResourceNotFoundException e) {
                    ourLog.debug("Resource ID {} was requested but does not exist", (Object)valueAsId.getIdPart());
                }
            }
            if (!haveValue) continue;
            if (allOrPids == null) {
                allOrPids = orPids;
                continue;
            }
            allOrPids.retainAll(orPids);
        }
        if (allOrPids != null && allOrPids.isEmpty()) {
            nextPredicate = this.myCriteriaBuilder.equal(this.myQueryStack.getResourcePidColumn(), (Object)-1);
        } else if (allOrPids != null) {
            SearchFilterParser.CompareOperation operation = (SearchFilterParser.CompareOperation)((Object)ObjectUtils.defaultIfNull((Object)((Object)theOperation), (Object)((Object)SearchFilterParser.CompareOperation.eq)));
            assert (operation == SearchFilterParser.CompareOperation.eq || operation == SearchFilterParser.CompareOperation.ne);
            ArrayList<Predicate> codePredicates = new ArrayList<Predicate>();
            switch (operation) {
                default: {
                    codePredicates.add(this.myQueryStack.getResourcePidColumn().in((Collection)ResourcePersistentId.toLongList(allOrPids)));
                    nextPredicate = this.myCriteriaBuilder.and(PredicateBuilderResourceId.toArray(codePredicates));
                    break;
                }
                case ne: {
                    codePredicates.add(this.myQueryStack.getResourcePidColumn().in((Collection)ResourcePersistentId.toLongList(allOrPids)).not());
                    nextPredicate = this.myCriteriaBuilder.and(PredicateBuilderResourceId.toArray(codePredicates));
                }
            }
        }
        return nextPredicate;
    }
}

