/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.predicate;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.LegacySearchBuilder;
import ca.uhn.fhir.jpa.dao.predicate.BasePredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.IPredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinEnum;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamString;
import ca.uhn.fhir.model.api.IPrimitiveDatatype;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class PredicateBuilderString
extends BasePredicateBuilder
implements IPredicateBuilder {
    public PredicateBuilderString(LegacySearchBuilder theSearchBuilder) {
        super(theSearchBuilder);
    }

    @Override
    public Predicate addPredicate(String theResourceName, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        From join = this.myQueryStack.createJoin(SearchBuilderJoinEnum.STRING, theSearchParam.getName());
        if (theList.get(0).getMissing() != null) {
            this.addPredicateParamMissingForNonReference(theResourceName, theSearchParam.getName(), theList.get(0).getMissing(), join, theRequestPartitionId);
            return null;
        }
        ArrayList<Predicate> codePredicates = new ArrayList<Predicate>();
        this.addPartitionIdPredicate(theRequestPartitionId, join, codePredicates);
        for (IQueryParameterType iQueryParameterType : theList) {
            Predicate singleCode = this.createPredicateString(iQueryParameterType, theResourceName, theSearchParam, this.myCriteriaBuilder, join, theOperation, theRequestPartitionId);
            codePredicates.add(singleCode);
        }
        Predicate retVal = this.myCriteriaBuilder.or(PredicateBuilderString.toArray(codePredicates));
        this.myQueryStack.addPredicateWithImplicitTypeSelection(retVal);
        return retVal;
    }

    public Predicate createPredicateString(IQueryParameterType theParameter, String theResourceName, RuntimeSearchParam theSearchParam, CriteriaBuilder theBuilder, From<?, ResourceIndexedSearchParamString> theFrom, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateString(theParameter, theResourceName, theSearchParam, theBuilder, theFrom, null, theRequestPartitionId);
    }

    private Predicate createPredicateString(IQueryParameterType theParameter, String theResourceName, RuntimeSearchParam theSearchParam, CriteriaBuilder theBuilder, From<?, ResourceIndexedSearchParamString> theFrom, SearchFilterParser.CompareOperation operation, RequestPartitionId theRequestPartitionId) {
        Predicate predicate;
        boolean exactMatch;
        String rawSearchTerm;
        TokenParam id;
        String paramName = theSearchParam.getName();
        if (theParameter instanceof TokenParam) {
            id = (TokenParam)theParameter;
            if (!id.isText()) {
                throw new IllegalStateException("Trying to process a text search on a non-text token parameter");
            }
            rawSearchTerm = id.getValue();
        } else if (theParameter instanceof StringParam) {
            id = (StringParam)theParameter;
            rawSearchTerm = id.getValue();
            if (id.isContains()) {
                if (!this.myDaoConfig.isAllowContainsSearches()) {
                    throw new MethodNotAllowedException(":contains modifier is disabled on this server");
                }
            } else {
                rawSearchTerm = theSearchParam.encode(rawSearchTerm);
            }
        } else if (theParameter instanceof IPrimitiveDatatype) {
            id = (IPrimitiveDatatype)theParameter;
            rawSearchTerm = id.getValueAsString();
        } else {
            throw new IllegalArgumentException("Invalid token type: " + theParameter.getClass());
        }
        if (rawSearchTerm.length() > 200) {
            throw new InvalidRequestException("Parameter[" + paramName + "] has length (" + rawSearchTerm.length() + ") that is longer than maximum allowed (" + 200 + "): " + rawSearchTerm);
        }
        if (this.myDontUseHashesForSearch) {
            String likeExpression = StringUtil.normalizeStringForSearchIndexing((String)rawSearchTerm);
            likeExpression = this.myDaoConfig.isAllowContainsSearches() ? (theParameter instanceof StringParam ? (((StringParam)theParameter).isContains() ? PredicateBuilderString.createLeftAndRightMatchLikeExpression(likeExpression) : PredicateBuilderString.createLeftMatchLikeExpression(likeExpression)) : PredicateBuilderString.createLeftMatchLikeExpression(likeExpression)) : PredicateBuilderString.createLeftMatchLikeExpression(likeExpression);
            Predicate singleCode = theBuilder.like(theFrom.get("myValueNormalized").as(String.class), likeExpression);
            if (theParameter instanceof StringParam && ((StringParam)theParameter).isExact()) {
                Predicate exactCode = theBuilder.equal((Expression)theFrom.get("myValueExact"), (Object)rawSearchTerm);
                singleCode = theBuilder.and((Expression)singleCode, (Expression)exactCode);
            }
            return this.combineParamIndexPredicateWithParamNamePredicate(theResourceName, paramName, theFrom, singleCode, theRequestPartitionId);
        }
        boolean bl = exactMatch = theParameter instanceof StringParam && ((StringParam)theParameter).isExact();
        if (exactMatch) {
            Long hash = ResourceIndexedSearchParamString.calculateHashExact((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)theRequestPartitionId, (String)theResourceName, (String)paramName, (String)rawSearchTerm);
            return theBuilder.equal(theFrom.get("myHashExact").as(Long.class), (Object)hash);
        }
        String normalizedString = StringUtil.normalizeStringForSearchIndexing((String)rawSearchTerm);
        String likeExpression = theParameter instanceof StringParam && (((StringParam)theParameter).isContains() && this.myDaoConfig.isAllowContainsSearches() || operation == SearchFilterParser.CompareOperation.co) ? PredicateBuilderString.createLeftAndRightMatchLikeExpression(normalizedString) : (operation != SearchFilterParser.CompareOperation.ne && operation != SearchFilterParser.CompareOperation.gt && operation != SearchFilterParser.CompareOperation.lt && operation != SearchFilterParser.CompareOperation.ge && operation != SearchFilterParser.CompareOperation.le ? (operation == SearchFilterParser.CompareOperation.ew ? PredicateBuilderString.createRightMatchLikeExpression(normalizedString) : PredicateBuilderString.createLeftMatchLikeExpression(normalizedString)) : normalizedString);
        if (operation == null || operation == SearchFilterParser.CompareOperation.sw) {
            Long hash = ResourceIndexedSearchParamString.calculateHashNormalized((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)theRequestPartitionId, (ModelConfig)this.myDaoConfig.getModelConfig(), (String)theResourceName, (String)paramName, (String)normalizedString);
            Predicate hashCode = theBuilder.equal(theFrom.get("myHashNormalizedPrefix").as(Long.class), (Object)hash);
            Predicate singleCode = theBuilder.like(theFrom.get("myValueNormalized").as(String.class), likeExpression);
            predicate = theBuilder.and((Expression)hashCode, (Expression)singleCode);
        } else if (operation == SearchFilterParser.CompareOperation.ew || operation == SearchFilterParser.CompareOperation.co) {
            Predicate singleCode = theBuilder.like(theFrom.get("myValueNormalized").as(String.class), likeExpression);
            predicate = this.combineParamIndexPredicateWithParamNamePredicate(theResourceName, paramName, theFrom, singleCode, theRequestPartitionId);
        } else if (operation == SearchFilterParser.CompareOperation.eq) {
            Long hash = ResourceIndexedSearchParamString.calculateHashNormalized((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)theRequestPartitionId, (ModelConfig)this.myDaoConfig.getModelConfig(), (String)theResourceName, (String)paramName, (String)normalizedString);
            Predicate hashCode = theBuilder.equal(theFrom.get("myHashNormalizedPrefix").as(Long.class), (Object)hash);
            Predicate singleCode = theBuilder.like(theFrom.get("myValueNormalized").as(String.class), normalizedString);
            predicate = theBuilder.and((Expression)hashCode, (Expression)singleCode);
        } else if (operation == SearchFilterParser.CompareOperation.ne) {
            Predicate singleCode = theBuilder.notEqual(theFrom.get("myValueNormalized").as(String.class), (Object)likeExpression);
            predicate = this.combineParamIndexPredicateWithParamNamePredicate(theResourceName, paramName, theFrom, singleCode, theRequestPartitionId);
        } else if (operation == SearchFilterParser.CompareOperation.gt) {
            Predicate singleCode = theBuilder.greaterThan(theFrom.get("myValueNormalized").as(String.class), (Comparable)((Object)likeExpression));
            predicate = this.combineParamIndexPredicateWithParamNamePredicate(theResourceName, paramName, theFrom, singleCode, theRequestPartitionId);
        } else if (operation == SearchFilterParser.CompareOperation.lt) {
            Predicate singleCode = theBuilder.lessThan(theFrom.get("myValueNormalized").as(String.class), (Comparable)((Object)likeExpression));
            predicate = this.combineParamIndexPredicateWithParamNamePredicate(theResourceName, paramName, theFrom, singleCode, theRequestPartitionId);
        } else if (operation == SearchFilterParser.CompareOperation.ge) {
            Predicate singleCode = theBuilder.greaterThanOrEqualTo(theFrom.get("myValueNormalized").as(String.class), (Comparable)((Object)likeExpression));
            predicate = this.combineParamIndexPredicateWithParamNamePredicate(theResourceName, paramName, theFrom, singleCode, theRequestPartitionId);
        } else if (operation == SearchFilterParser.CompareOperation.le) {
            Predicate singleCode = theBuilder.lessThanOrEqualTo(theFrom.get("myValueNormalized").as(String.class), (Comparable)((Object)likeExpression));
            predicate = this.combineParamIndexPredicateWithParamNamePredicate(theResourceName, paramName, theFrom, singleCode, theRequestPartitionId);
        } else {
            throw new IllegalArgumentException("Don't yet know how to handle operation " + (Object)((Object)operation) + " on a string");
        }
        return predicate;
    }
}

