/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.predicate;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.LegacySearchBuilder;
import ca.uhn.fhir.jpa.dao.predicate.BasePredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinEnum;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.jpa.model.entity.TagTypeEnum;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.TokenParamModifier;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class PredicateBuilderTag
extends BasePredicateBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(PredicateBuilderTag.class);

    public PredicateBuilderTag(LegacySearchBuilder theSearchBuilder) {
        super(theSearchBuilder);
    }

    void addPredicateTag(List<List<IQueryParameterType>> theList, String theParamName, RequestPartitionId theRequestPartitionId) {
        TagTypeEnum tagType;
        if ("_tag".equals(theParamName)) {
            tagType = TagTypeEnum.TAG;
        } else if ("_profile".equals(theParamName)) {
            tagType = TagTypeEnum.PROFILE;
        } else if ("_security".equals(theParamName)) {
            tagType = TagTypeEnum.SECURITY_LABEL;
        } else {
            throw new IllegalArgumentException("Param name: " + theParamName);
        }
        ArrayList notTags = Lists.newArrayList();
        for (List<IQueryParameterType> nextAndParams : theList) {
            for (IQueryParameterType nextOrParams : nextAndParams) {
                TokenParam param;
                if (!(nextOrParams instanceof TokenParam) || (param = (TokenParam)nextOrParams).getModifier() != TokenParamModifier.NOT || !StringUtils.isNotBlank((CharSequence)param.getSystem()) && !StringUtils.isNotBlank((CharSequence)param.getValue())) continue;
                notTags.add(Pair.of((Object)param.getSystem(), (Object)param.getValue()));
            }
        }
        for (List<IQueryParameterType> nextAndParams : theList) {
            boolean haveTags = false;
            for (IQueryParameterType nextParamUncasted : nextAndParams) {
                TokenParam nextParam;
                if (nextParamUncasted instanceof TokenParam) {
                    nextParam = (TokenParam)nextParamUncasted;
                    if (StringUtils.isNotBlank((CharSequence)nextParam.getValue())) {
                        haveTags = true;
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)nextParam.getSystem())) continue;
                    throw new InvalidRequestException("Invalid " + theParamName + " parameter (must supply a value/code and not just a system): " + nextParam.getValueAsQueryToken(this.myContext));
                }
                nextParam = (UriParam)nextParamUncasted;
                if (!StringUtils.isNotBlank((CharSequence)nextParam.getValue())) continue;
                haveTags = true;
            }
            if (!haveTags) continue;
            boolean paramInverted = false;
            ArrayList tokens = Lists.newArrayList();
            for (IQueryParameterType nextOrParams : nextAndParams) {
                String system;
                String code;
                TokenParam nextParam;
                if (nextOrParams instanceof TokenParam) {
                    nextParam = (TokenParam)nextOrParams;
                    code = nextParam.getValue();
                    system = nextParam.getSystem();
                    if (nextParam.getModifier() == TokenParamModifier.NOT) {
                        paramInverted = true;
                    }
                } else {
                    nextParam = (UriParam)nextOrParams;
                    code = nextParam.getValue();
                    system = null;
                }
                if (!StringUtils.isNotBlank((CharSequence)code)) continue;
                tokens.add(Pair.of((Object)system, (Object)code));
            }
            if (tokens.isEmpty()) continue;
            if (paramInverted) {
                ourLog.debug("Searching for _tag:not");
                Subquery<Long> subQ = this.myQueryStack.subqueryForTagNegation();
                Root subQfrom = subQ.from(ResourceTag.class);
                subQ.select(subQfrom.get("myResourceId").as(Long.class));
                this.myQueryStack.addPredicate(this.myCriteriaBuilder.not((Expression)this.myCriteriaBuilder.in(this.myQueryStack.get("myId")).value(subQ)));
                Subquery defJoin = subQ.subquery(Long.class);
                Root defJoinFrom = defJoin.from(TagDefinition.class);
                defJoin.select(defJoinFrom.get("myId").as(Long.class));
                subQ.where((Expression)subQfrom.get("myTagId").as(Long.class).in(new Expression[]{defJoin}));
                Predicate tagListPredicate = this.createPredicateTagList((Path<TagDefinition>)defJoinFrom, this.myCriteriaBuilder, tagType, tokens);
                defJoin.where((Expression)tagListPredicate);
                continue;
            }
            From tagJoin = this.myQueryStack.createJoin(SearchBuilderJoinEnum.RESOURCE_TAGS, null);
            Join defJoin = tagJoin.join("myTag");
            Predicate tagListPredicate = this.createPredicateTagList((Path<TagDefinition>)defJoin, this.myCriteriaBuilder, tagType, tokens);
            ArrayList predicates = Lists.newArrayList((Object[])new Predicate[]{tagListPredicate});
            if (theRequestPartitionId != null) {
                this.addPartitionIdPredicate(theRequestPartitionId, tagJoin, predicates);
            }
            this.myQueryStack.addPredicates(predicates);
        }
    }

    private Predicate createPredicateTagList(Path<TagDefinition> theDefJoin, CriteriaBuilder theBuilder, TagTypeEnum theTagType, List<Pair<String, String>> theTokens) {
        Predicate typePredicate = theBuilder.equal((Expression)theDefJoin.get("myTagType"), (Object)theTagType);
        ArrayList orPredicates = Lists.newArrayList();
        for (Pair<String, String> next : theTokens) {
            Predicate codePredicate = theBuilder.equal((Expression)theDefJoin.get("myCode"), next.getRight());
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)next.getLeft()))) {
                Predicate systemPredicate = theBuilder.equal((Expression)theDefJoin.get("mySystem"), next.getLeft());
                orPredicates.add(theBuilder.and(new Predicate[]{typePredicate, systemPredicate, codePredicate}));
                continue;
            }
            orPredicates.add(theBuilder.and((Expression)typePredicate, (Expression)codePredicate));
        }
        return theBuilder.or(PredicateBuilderTag.toArray(orPredicates));
    }
}

