/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.predicate;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.LegacySearchBuilder;
import ca.uhn.fhir.jpa.dao.predicate.BasePredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.IPredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.PredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinEnum;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderTokenModeEnum;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.searchparam.extractor.BaseSearchParamExtractor;
import ca.uhn.fhir.jpa.term.api.ITermReadSvc;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.base.composite.BaseIdentifierDt;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.TokenParamModifier;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.util.FhirVersionIndependentConcept;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.query.criteria.internal.CriteriaBuilderImpl;
import org.hibernate.query.criteria.internal.predicate.BooleanStaticAssertionPredicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class PredicateBuilderToken
extends BasePredicateBuilder
implements IPredicateBuilder {
    private final PredicateBuilder myPredicateBuilder;
    @Autowired
    private ITermReadSvc myTerminologySvc;
    @Autowired
    private ModelConfig myModelConfig;

    public PredicateBuilderToken(LegacySearchBuilder theSearchBuilder, PredicateBuilder thePredicateBuilder) {
        super(theSearchBuilder);
        this.myPredicateBuilder = thePredicateBuilder;
    }

    @Override
    public Predicate addPredicate(String theResourceName, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        if (theList.get(0).getMissing() != null) {
            From join = this.myQueryStack.createJoin(SearchBuilderJoinEnum.TOKEN, theSearchParam.getName());
            this.addPredicateParamMissingForNonReference(theResourceName, theSearchParam.getName(), theList.get(0).getMissing(), join, theRequestPartitionId);
            return null;
        }
        ArrayList<Predicate> codePredicates = new ArrayList<Predicate>();
        ArrayList<IQueryParameterType> tokens = new ArrayList<IQueryParameterType>();
        for (IQueryParameterType iQueryParameterType : theList) {
            TokenParam id;
            if (iQueryParameterType instanceof TokenParam && (id = (TokenParam)iQueryParameterType).isText()) {
                boolean tokenTextIndexingEnabled = BaseSearchParamExtractor.tokenTextIndexingEnabledForSearchParam((ModelConfig)this.myModelConfig, (RuntimeSearchParam)theSearchParam);
                if (!tokenTextIndexingEnabled) {
                    String msg = this.myModelConfig.isSuppressStringIndexingInTokens() ? this.myContext.getLocalizer().getMessage(PredicateBuilderToken.class, "textModifierDisabledForServer", new Object[0]) : this.myContext.getLocalizer().getMessage(PredicateBuilderToken.class, "textModifierDisabledForSearchParam", new Object[0]);
                    throw new MethodNotAllowedException(msg);
                }
                this.myPredicateBuilder.addPredicateString(theResourceName, theSearchParam, theList, theOperation, theRequestPartitionId);
                break;
            }
            tokens.add(iQueryParameterType);
        }
        if (tokens.isEmpty()) {
            return null;
        }
        From join = this.myQueryStack.createJoin(SearchBuilderJoinEnum.TOKEN, theSearchParam.getName());
        this.addPartitionIdPredicate(theRequestPartitionId, join, codePredicates);
        Collection<Predicate> collection = this.createPredicateToken(tokens, theResourceName, theSearchParam, this.myCriteriaBuilder, join, theOperation, theRequestPartitionId);
        assert (collection != null);
        codePredicates.addAll(collection);
        Predicate spPredicate = this.myCriteriaBuilder.or(PredicateBuilderToken.toArray(codePredicates));
        this.myQueryStack.addPredicateWithImplicitTypeSelection(spPredicate);
        return spPredicate;
    }

    public Collection<Predicate> createPredicateToken(Collection<IQueryParameterType> theParameters, String theResourceName, RuntimeSearchParam theSearchParam, CriteriaBuilder theBuilder, From<?, ResourceIndexedSearchParamToken> theFrom, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateToken(theParameters, theResourceName, theSearchParam, theBuilder, theFrom, null, theRequestPartitionId);
    }

    private Collection<Predicate> createPredicateToken(Collection<IQueryParameterType> theParameters, String theResourceName, RuntimeSearchParam theSearchParam, CriteriaBuilder theBuilder, From<?, ResourceIndexedSearchParamToken> theFrom, SearchFilterParser.CompareOperation operation, RequestPartitionId theRequestPartitionId) {
        List<FhirVersionIndependentConcept> systemAndCodeCodes;
        List<FhirVersionIndependentConcept> codeOnlyCodes;
        ArrayList<FhirVersionIndependentConcept> codes = new ArrayList<FhirVersionIndependentConcept>();
        String paramName = theSearchParam.getName();
        TokenParamModifier modifier = null;
        for (IQueryParameterType nextParameter : theParameters) {
            String code;
            String system;
            TokenParam id;
            if (nextParameter instanceof TokenParam) {
                id = (TokenParam)nextParameter;
                system = id.getSystem();
                code = id.getValue();
                modifier = id.getModifier();
            } else if (nextParameter instanceof BaseIdentifierDt) {
                id = (BaseIdentifierDt)nextParameter;
                system = id.getSystemElement().getValueAsString();
                code = (String)id.getValueElement().getValue();
            } else if (nextParameter instanceof BaseCodingDt) {
                id = (BaseCodingDt)nextParameter;
                system = id.getSystemElement().getValueAsString();
                code = (String)id.getCodeElement().getValue();
            } else if (nextParameter instanceof NumberParam) {
                NumberParam number = (NumberParam)nextParameter;
                system = null;
                code = number.getValueAsQueryToken(this.myContext);
            } else {
                throw new IllegalArgumentException("Invalid token type: " + nextParameter.getClass());
            }
            if (system != null && system.length() > 200) {
                throw new InvalidRequestException("Parameter[" + paramName + "] has system (" + system.length() + ") that is longer than maximum allowed (" + 200 + "): " + system);
            }
            if (code != null && code.length() > 200) {
                throw new InvalidRequestException("Parameter[" + paramName + "] has code (" + code.length() + ") that is longer than maximum allowed (" + 200 + "): " + code);
            }
            if (modifier == TokenParamModifier.IN) {
                codes.addAll(this.myTerminologySvc.expandValueSetIntoConceptList(null, code));
                continue;
            }
            if (modifier == TokenParamModifier.ABOVE) {
                system = this.determineSystemIfMissing(theSearchParam, code, system);
                this.validateHaveSystemAndCodeForToken(paramName, code, system);
                codes.addAll(this.myTerminologySvc.findCodesAbove(system, code));
                continue;
            }
            if (modifier == TokenParamModifier.BELOW) {
                system = this.determineSystemIfMissing(theSearchParam, code, system);
                this.validateHaveSystemAndCodeForToken(paramName, code, system);
                codes.addAll(this.myTerminologySvc.findCodesBelow(system, code));
                continue;
            }
            codes.add(new FhirVersionIndependentConcept(system, code));
        }
        List sortedCodesList = codes.stream().filter(t -> t.getCode() != null || t.getSystem() != null).sorted().distinct().collect(Collectors.toList());
        if (codes.isEmpty()) {
            return Collections.singletonList(new BooleanStaticAssertionPredicate((CriteriaBuilderImpl)theBuilder, Boolean.valueOf(false)));
        }
        ArrayList<Predicate> retVal = new ArrayList<Predicate>();
        List<FhirVersionIndependentConcept> systemOnlyCodes = sortedCodesList.stream().filter(t -> StringUtils.isBlank((CharSequence)t.getCode())).collect(Collectors.toList());
        if (!systemOnlyCodes.isEmpty()) {
            retVal.add(this.addPredicate(theResourceName, paramName, theBuilder, theFrom, systemOnlyCodes, modifier, SearchBuilderTokenModeEnum.SYSTEM_ONLY, theRequestPartitionId));
        }
        if (!(codeOnlyCodes = sortedCodesList.stream().filter(t -> t.getSystem() == null).collect(Collectors.toList())).isEmpty()) {
            retVal.add(this.addPredicate(theResourceName, paramName, theBuilder, theFrom, codeOnlyCodes, modifier, SearchBuilderTokenModeEnum.VALUE_ONLY, theRequestPartitionId));
        }
        if (!(systemAndCodeCodes = sortedCodesList.stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.getCode()) && t.getSystem() != null).collect(Collectors.toList())).isEmpty()) {
            retVal.add(this.addPredicate(theResourceName, paramName, theBuilder, theFrom, systemAndCodeCodes, modifier, SearchBuilderTokenModeEnum.SYSTEM_AND_VALUE, theRequestPartitionId));
        }
        return retVal;
    }

    private String determineSystemIfMissing(RuntimeSearchParam theSearchParam, String code, String theSystem) {
        String retVal = theSystem;
        if (retVal == null && theSearchParam != null) {
            HashSet valueSetUris = Sets.newHashSet();
            for (String nextPath : theSearchParam.getPathsSplit()) {
                String valueSet;
                BaseRuntimeChildDefinition def = this.myContext.newTerser().getDefinition(this.myResourceType, nextPath);
                if (!(def instanceof BaseRuntimeDeclaredChildDefinition) || !StringUtils.isNotBlank((CharSequence)(valueSet = ((BaseRuntimeDeclaredChildDefinition)def).getBindingValueSet()))) continue;
                valueSetUris.add(valueSet);
            }
            if (valueSetUris.size() == 1) {
                String valueSet = (String)valueSetUris.iterator().next();
                ValueSetExpansionOptions options = new ValueSetExpansionOptions().setFailOnMissingCodeSystem(false);
                List<FhirVersionIndependentConcept> candidateCodes = this.myTerminologySvc.expandValueSetIntoConceptList(options, valueSet);
                for (FhirVersionIndependentConcept nextCandidate : candidateCodes) {
                    if (!nextCandidate.getCode().equals(code)) continue;
                    retVal = nextCandidate.getSystem();
                    break;
                }
            }
        }
        return retVal;
    }

    private void validateHaveSystemAndCodeForToken(String theParamName, String theCode, String theSystem) {
        String systemDesc = (String)StringUtils.defaultIfBlank((CharSequence)theSystem, (CharSequence)"(missing)");
        String codeDesc = (String)StringUtils.defaultIfBlank((CharSequence)theCode, (CharSequence)"(missing)");
        if (StringUtils.isBlank((CharSequence)theCode)) {
            String msg = this.myContext.getLocalizer().getMessage(LegacySearchBuilder.class, "invalidCodeMissingSystem", new Object[]{theParamName, systemDesc, codeDesc});
            throw new InvalidRequestException(msg);
        }
        if (StringUtils.isBlank((CharSequence)theSystem)) {
            String msg = this.myContext.getLocalizer().getMessage(LegacySearchBuilder.class, "invalidCodeMissingCode", new Object[]{theParamName, systemDesc, codeDesc});
            throw new InvalidRequestException(msg);
        }
    }

    private Predicate addPredicate(String theResourceName, String theParamName, CriteriaBuilder theBuilder, From<?, ResourceIndexedSearchParamToken> theFrom, List<FhirVersionIndependentConcept> theTokens, TokenParamModifier theModifier, SearchBuilderTokenModeEnum theTokenMode, RequestPartitionId theRequestPartitionId) {
        List values;
        Expression hashField;
        if (this.myDontUseHashesForSearch) {
            Path systemExpression = theFrom.get("mySystem");
            Path valueExpression = theFrom.get("myValue");
            ArrayList<Predicate> orPredicates = new ArrayList<Predicate>();
            switch (theTokenMode) {
                case SYSTEM_ONLY: {
                    List systems = theTokens.stream().map(t -> t.getSystem()).collect(Collectors.toList());
                    Predicate orPredicate = systemExpression.in(systems);
                    orPredicates.add(orPredicate);
                    break;
                }
                case VALUE_ONLY: {
                    List codes = theTokens.stream().map(t -> t.getCode()).collect(Collectors.toList());
                    Predicate orPredicate = valueExpression.in(codes);
                    orPredicates.add(orPredicate);
                    break;
                }
                case SYSTEM_AND_VALUE: {
                    for (FhirVersionIndependentConcept next : theTokens) {
                        orPredicates.add(theBuilder.and(this.toEqualOrIsNullPredicate(systemExpression, next.getSystem()), this.toEqualOrIsNullPredicate(valueExpression, next.getCode())));
                    }
                    break;
                }
            }
            Predicate or = theBuilder.or(orPredicates.toArray(new Predicate[0]));
            if (theModifier == TokenParamModifier.NOT) {
                or = theBuilder.not((Expression)or);
            }
            return this.combineParamIndexPredicateWithParamNamePredicate(theResourceName, theParamName, theFrom, or, theRequestPartitionId);
        }
        switch (theTokenMode) {
            case SYSTEM_ONLY: {
                hashField = theFrom.get("myHashSystem").as(Long.class);
                values = theTokens.stream().map(t -> ResourceIndexedSearchParamToken.calculateHashSystem((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)theRequestPartitionId, (String)theResourceName, (String)theParamName, (String)t.getSystem())).collect(Collectors.toList());
                break;
            }
            case VALUE_ONLY: {
                hashField = theFrom.get("myHashValue").as(Long.class);
                values = theTokens.stream().map(t -> ResourceIndexedSearchParamToken.calculateHashValue((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)theRequestPartitionId, (String)theResourceName, (String)theParamName, (String)t.getCode())).collect(Collectors.toList());
                break;
            }
            default: {
                hashField = theFrom.get("myHashSystemAndValue").as(Long.class);
                values = theTokens.stream().map(t -> ResourceIndexedSearchParamToken.calculateHashSystemAndValue((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)theRequestPartitionId, (String)theResourceName, (String)theParamName, (String)t.getSystem(), (String)t.getCode())).collect(Collectors.toList());
            }
        }
        Predicate predicate = hashField.in(values);
        if (theModifier == TokenParamModifier.NOT) {
            Predicate identityPredicate = theBuilder.equal(theFrom.get("myHashIdentity").as(Long.class), (Object)BaseResourceIndexedSearchParam.calculateHashIdentity((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)theRequestPartitionId, (String)theResourceName, (String)theParamName));
            Predicate disjunctionPredicate = theBuilder.not((Expression)predicate);
            predicate = theBuilder.and((Expression)identityPredicate, (Expression)disjunctionPredicate);
        }
        return predicate;
    }

    private <T> Expression<Boolean> toEqualOrIsNullPredicate(Path<T> theExpression, T theCode) {
        if (theCode == null) {
            return this.myCriteriaBuilder.isNull(theExpression);
        }
        return this.myCriteriaBuilder.equal(theExpression, theCode);
    }
}

