/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.predicate;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.LegacySearchBuilder;
import ca.uhn.fhir.jpa.dao.data.IResourceIndexedSearchParamUriDao;
import ca.uhn.fhir.jpa.dao.predicate.BasePredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.IPredicateBuilder;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinEnum;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamUri;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.param.UriParamQualifierEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class PredicateBuilderUri
extends BasePredicateBuilder
implements IPredicateBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(PredicateBuilderUri.class);
    @Autowired
    private IResourceIndexedSearchParamUriDao myResourceIndexedSearchParamUriDao;

    public PredicateBuilderUri(LegacySearchBuilder theSearchBuilder) {
        super(theSearchBuilder);
    }

    @Override
    public Predicate addPredicate(String theResourceName, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation operation, RequestPartitionId theRequestPartitionId) {
        String paramName = theSearchParam.getName();
        From join = this.myQueryStack.createJoin(SearchBuilderJoinEnum.URI, paramName);
        if (theList.get(0).getMissing() != null) {
            this.addPredicateParamMissingForNonReference(theResourceName, paramName, theList.get(0).getMissing(), join, theRequestPartitionId);
            return null;
        }
        ArrayList<Predicate> codePredicates = new ArrayList<Predicate>();
        this.addPartitionIdPredicate(theRequestPartitionId, join, codePredicates);
        for (IQueryParameterType iQueryParameterType : theList) {
            if (iQueryParameterType instanceof UriParam) {
                Predicate uriPredicate;
                UriParam param = (UriParam)iQueryParameterType;
                String value = param.getValue();
                if (value == null) continue;
                if (param.getQualifier() == UriParamQualifierEnum.ABOVE) {
                    ourLog.info("Searching for candidate URI:above parameters for Resource[{}] param[{}]", (Object)this.myResourceName, (Object)paramName);
                    Collection<String> candidates = this.myResourceIndexedSearchParamUriDao.findAllByResourceTypeAndParamName(this.myResourceName, paramName);
                    ArrayList<String> toFind = new ArrayList<String>();
                    for (String next : candidates) {
                        if (value.length() < next.length() || !value.startsWith(next)) continue;
                        toFind.add(next);
                    }
                    if (toFind.isEmpty()) continue;
                    Predicate uriPredicate2 = join.get("myUri").as(String.class).in(toFind);
                    Predicate hashAndUriPredicate = this.combineParamIndexPredicateWithParamNamePredicate(theResourceName, paramName, join, uriPredicate2, theRequestPartitionId);
                    codePredicates.add(hashAndUriPredicate);
                    continue;
                }
                if (param.getQualifier() == UriParamQualifierEnum.BELOW) {
                    uriPredicate = this.myCriteriaBuilder.like(join.get("myUri").as(String.class), PredicateBuilderUri.createLeftMatchLikeExpression(value));
                    Predicate hashAndUriPredicate = this.combineParamIndexPredicateWithParamNamePredicate(theResourceName, paramName, join, uriPredicate, theRequestPartitionId);
                    codePredicates.add(hashAndUriPredicate);
                    continue;
                }
                if (this.myDontUseHashesForSearch) {
                    Predicate predicate = this.myCriteriaBuilder.equal(join.get("myUri").as(String.class), (Object)value);
                    codePredicates.add(predicate);
                    continue;
                }
                uriPredicate = null;
                if (operation == null || operation == SearchFilterParser.CompareOperation.eq) {
                    long hashUri = ResourceIndexedSearchParamUri.calculateHashUri((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)theRequestPartitionId, (String)theResourceName, (String)paramName, (String)value);
                    Predicate hashPredicate = this.myCriteriaBuilder.equal((Expression)join.get("myHashUri"), (Object)hashUri);
                    codePredicates.add(hashPredicate);
                } else if (operation == SearchFilterParser.CompareOperation.ne) {
                    uriPredicate = this.myCriteriaBuilder.notEqual(join.get("myUri").as(String.class), (Object)value);
                } else if (operation == SearchFilterParser.CompareOperation.co) {
                    uriPredicate = this.myCriteriaBuilder.like(join.get("myUri").as(String.class), PredicateBuilderUri.createLeftAndRightMatchLikeExpression(value));
                } else if (operation == SearchFilterParser.CompareOperation.gt) {
                    uriPredicate = this.myCriteriaBuilder.greaterThan(join.get("myUri").as(String.class), (Comparable)((Object)value));
                } else if (operation == SearchFilterParser.CompareOperation.lt) {
                    uriPredicate = this.myCriteriaBuilder.lessThan(join.get("myUri").as(String.class), (Comparable)((Object)value));
                } else if (operation == SearchFilterParser.CompareOperation.ge) {
                    uriPredicate = this.myCriteriaBuilder.greaterThanOrEqualTo(join.get("myUri").as(String.class), (Comparable)((Object)value));
                } else if (operation == SearchFilterParser.CompareOperation.le) {
                    uriPredicate = this.myCriteriaBuilder.lessThanOrEqualTo(join.get("myUri").as(String.class), (Comparable)((Object)value));
                } else if (operation == SearchFilterParser.CompareOperation.sw) {
                    uriPredicate = this.myCriteriaBuilder.like(join.get("myUri").as(String.class), PredicateBuilderUri.createLeftMatchLikeExpression(value));
                } else if (operation == SearchFilterParser.CompareOperation.ew) {
                    uriPredicate = this.myCriteriaBuilder.like(join.get("myUri").as(String.class), PredicateBuilderUri.createRightMatchLikeExpression(value));
                } else {
                    throw new IllegalArgumentException(String.format("Unsupported operator specified in _filter clause, %s", operation.toString()));
                }
                if (uriPredicate == null) continue;
                long hashIdentity = BaseResourceIndexedSearchParam.calculateHashIdentity((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)theRequestPartitionId, (String)theResourceName, (String)paramName);
                Predicate hashIdentityPredicate = this.myCriteriaBuilder.equal((Expression)join.get("myHashIdentity"), (Object)hashIdentity);
                codePredicates.add(this.myCriteriaBuilder.and((Expression)hashIdentityPredicate, (Expression)uriPredicate));
                continue;
            }
            throw new IllegalArgumentException("Invalid URI type: " + iQueryParameterType.getClass());
        }
        if (codePredicates.isEmpty()) {
            Predicate predicate = this.myCriteriaBuilder.isNull(join.get("myMissing").as(String.class));
            this.myQueryStack.addPredicateWithImplicitTypeSelection(predicate);
            return null;
        }
        Predicate orPredicate = this.myCriteriaBuilder.or(PredicateBuilderUri.toArray(codePredicates));
        Predicate predicate = this.combineParamIndexPredicateWithParamNamePredicate(theResourceName, paramName, join, orPredicate, theRequestPartitionId);
        this.myQueryStack.addPredicateWithImplicitTypeSelection(predicate);
        return predicate;
    }
}

