/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.predicate.querystack;

import ca.uhn.fhir.jpa.dao.predicate.IndexJoins;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinEnum;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinKey;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;

abstract class QueryRootEntry {
    private final ArrayList<Predicate> myPredicates = new ArrayList();
    private final IndexJoins myIndexJoins = new IndexJoins();
    private final CriteriaBuilder myCriteriaBuilder;
    private boolean myHasImplicitTypeSelection;
    private Map<String, From<?, ResourceIndexedSearchParamDate>> myJoinMap;

    QueryRootEntry(CriteriaBuilder theCriteriaBuilder) {
        this.myCriteriaBuilder = theCriteriaBuilder;
    }

    boolean isHasImplicitTypeSelection() {
        return this.myHasImplicitTypeSelection;
    }

    void setHasImplicitTypeSelection(boolean theHasImplicitTypeSelection) {
        this.myHasImplicitTypeSelection = theHasImplicitTypeSelection;
    }

    Optional<Join<?, ?>> getIndexJoin(SearchBuilderJoinKey theKey) {
        return Optional.ofNullable(this.myIndexJoins.get(theKey));
    }

    void addPredicate(Predicate thePredicate) {
        this.myPredicates.add(thePredicate);
    }

    void addPredicates(List<Predicate> thePredicates) {
        this.myPredicates.addAll(thePredicates);
    }

    Predicate addNeverMatchingPredicate() {
        Predicate predicate = this.myCriteriaBuilder.equal(this.getResourcePidColumn(), (Object)-1L);
        this.clearPredicates();
        this.addPredicate(predicate);
        return predicate;
    }

    Predicate[] getPredicateArray() {
        return this.myPredicates.toArray(new Predicate[0]);
    }

    void putIndex(SearchBuilderJoinKey theKey, Join<?, ?> theJoin) {
        this.myIndexJoins.put(theKey, theJoin);
    }

    void clearPredicates() {
        this.myPredicates.clear();
    }

    List<Predicate> getPredicates() {
        return Collections.unmodifiableList(this.myPredicates);
    }

    <Y> Path<Y> get(String theAttributeName) {
        return this.getRoot().get(theAttributeName);
    }

    AbstractQuery<Long> pop() {
        Predicate[] predicateArray = this.getPredicateArray();
        if (predicateArray.length == 1) {
            this.getQueryRoot().where((Expression)predicateArray[0]);
        } else {
            this.getQueryRoot().where((Expression)this.myCriteriaBuilder.and(predicateArray));
        }
        return this.getQueryRoot();
    }

    public Map<String, From<?, ResourceIndexedSearchParamDate>> getJoinMap() {
        Map<String, From<?, ResourceIndexedSearchParamDate>> retVal = this.myJoinMap;
        if (retVal == null) {
            this.myJoinMap = retVal = new HashMap();
        }
        return retVal;
    }

    abstract void orderBy(List<Order> var1);

    abstract Expression<Date> getLastUpdatedColumn();

    abstract <T> From<?, T> createJoin(SearchBuilderJoinEnum var1, String var2);

    abstract AbstractQuery<Long> getQueryRoot();

    abstract Root<?> getRoot();

    abstract Expression<Long> getResourcePidColumn();

    abstract Subquery<Long> subqueryForTagNegation();
}

