/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.predicate.querystack;

import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinEnum;
import ca.uhn.fhir.jpa.dao.predicate.querystack.QueryRootEntry;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamCoords;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamDate;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamNumber;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamString;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamUri;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.apache.commons.lang3.Validate;

public class QueryRootEntryIndexTable
extends QueryRootEntry {
    private final Subquery<Long> myQuery;
    private Root<? extends BaseResourceIndex> myRoot;
    private SearchBuilderJoinEnum myParamType;
    private Expression<Long> myResourcePidColumn;

    public QueryRootEntryIndexTable(CriteriaBuilder theCriteriaBuilder, QueryRootEntry theParent) {
        super(theCriteriaBuilder);
        AbstractQuery<Long> queryRoot = theParent.getQueryRoot();
        this.myQuery = queryRoot.subquery(Long.class);
    }

    @Override
    void orderBy(List<Order> theOrders) {
        throw new IllegalStateException();
    }

    @Override
    Expression<Date> getLastUpdatedColumn() {
        return this.getRoot().get("myUpdated").as(Date.class);
    }

    @Override
    <T> From<?, T> createJoin(SearchBuilderJoinEnum theType, String theSearchParameterName) {
        if (this.myParamType == null) {
            switch (theType) {
                case REFERENCE: {
                    this.myRoot = this.myQuery.from(ResourceLink.class);
                    this.myResourcePidColumn = this.myRoot.get("mySourceResourcePid").as(Long.class);
                    this.myParamType = SearchBuilderJoinEnum.REFERENCE;
                    break;
                }
                case NUMBER: {
                    this.myRoot = this.myQuery.from(ResourceIndexedSearchParamNumber.class);
                    this.myResourcePidColumn = this.myRoot.get("myResourcePid").as(Long.class);
                    this.myParamType = SearchBuilderJoinEnum.NUMBER;
                    break;
                }
                case DATE: {
                    this.myRoot = this.myQuery.from(ResourceIndexedSearchParamDate.class);
                    this.myResourcePidColumn = this.myRoot.get("myResourcePid").as(Long.class);
                    this.myParamType = SearchBuilderJoinEnum.DATE;
                    break;
                }
                case STRING: {
                    this.myRoot = this.myQuery.from(ResourceIndexedSearchParamString.class);
                    this.myResourcePidColumn = this.myRoot.get("myResourcePid").as(Long.class);
                    this.myParamType = SearchBuilderJoinEnum.STRING;
                    break;
                }
                case TOKEN: {
                    this.myRoot = this.myQuery.from(ResourceIndexedSearchParamToken.class);
                    this.myResourcePidColumn = this.myRoot.get("myResourcePid").as(Long.class);
                    this.myParamType = SearchBuilderJoinEnum.TOKEN;
                    break;
                }
                case QUANTITY: {
                    this.myRoot = this.myQuery.from(ResourceIndexedSearchParamQuantity.class);
                    this.myResourcePidColumn = this.myRoot.get("myResourcePid").as(Long.class);
                    this.myParamType = SearchBuilderJoinEnum.QUANTITY;
                    break;
                }
                case URI: {
                    this.myRoot = this.myQuery.from(ResourceIndexedSearchParamUri.class);
                    this.myResourcePidColumn = this.myRoot.get("myResourcePid").as(Long.class);
                    this.myParamType = SearchBuilderJoinEnum.URI;
                    break;
                }
                case COORDS: {
                    this.myRoot = this.myQuery.from(ResourceIndexedSearchParamCoords.class);
                    this.myResourcePidColumn = this.myRoot.get("myResourcePid").as(Long.class);
                    this.myParamType = SearchBuilderJoinEnum.COORDS;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.myQuery.select(this.myResourcePidColumn);
        }
        Validate.isTrue((theType == this.myParamType ? 1 : 0) != 0, (String)"Wanted %s but got %s for %s", (Object[])new Object[]{this.myParamType, theType, theSearchParameterName});
        return this.myRoot;
    }

    @Override
    AbstractQuery<Long> getQueryRoot() {
        Validate.isTrue((this.myQuery != null ? 1 : 0) != 0);
        return this.myQuery;
    }

    @Override
    Root<?> getRoot() {
        Validate.isTrue((this.myRoot != null ? 1 : 0) != 0);
        return this.myRoot;
    }

    @Override
    public Expression<Long> getResourcePidColumn() {
        Validate.isTrue((this.myResourcePidColumn != null ? 1 : 0) != 0);
        return this.myResourcePidColumn;
    }

    @Override
    public Subquery<Long> subqueryForTagNegation() {
        throw new IllegalStateException();
    }
}

