/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.predicate.querystack;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinEnum;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinKey;
import ca.uhn.fhir.jpa.dao.predicate.querystack.QueryRootEntry;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;

class QueryRootEntryResourceTable
extends QueryRootEntry {
    private final CriteriaBuilder myCriteriaBuilder;
    private final AbstractQuery<Long> myQuery;
    private final SearchParameterMap mySearchParameterMap;
    private final RequestPartitionId myRequestPartitionId;
    private final String myResourceType;
    private final Root<ResourceTable> myResourceTableRoot;

    @Override
    AbstractQuery<Long> pop() {
        if (!this.isHasImplicitTypeSelection()) {
            if (this.mySearchParameterMap.getEverythingMode() == null) {
                this.addPredicate(this.myCriteriaBuilder.equal((Expression)this.getRoot().get("myResourceType"), (Object)this.myResourceType));
            }
            this.addPredicate(this.myCriteriaBuilder.isNull((Expression)this.getRoot().get("myDeleted")));
            if (!this.myRequestPartitionId.isAllPartitions()) {
                if (!this.myRequestPartitionId.isDefaultPartition()) {
                    this.addPredicate(this.getRoot().get("myPartitionIdValue").as(Integer.class).in((Collection)this.myRequestPartitionId.getPartitionIds()));
                } else {
                    this.addPredicate(this.myCriteriaBuilder.isNull(this.getRoot().get("myPartitionIdValue").as(Integer.class)));
                }
            }
        }
        return super.pop();
    }

    QueryRootEntryResourceTable(CriteriaBuilder theCriteriaBuilder, boolean theDistinct, boolean theCountQuery, SearchParameterMap theSearchParameterMap, String theResourceType, RequestPartitionId theRequestPartitionId) {
        super(theCriteriaBuilder);
        this.myCriteriaBuilder = theCriteriaBuilder;
        this.mySearchParameterMap = theSearchParameterMap;
        this.myRequestPartitionId = theRequestPartitionId;
        this.myResourceType = theResourceType;
        CriteriaQuery query = this.myCriteriaBuilder.createQuery(Long.class);
        this.myResourceTableRoot = query.from(ResourceTable.class);
        if (theCountQuery) {
            query.multiselect(new Selection[]{this.myCriteriaBuilder.countDistinct(this.myResourceTableRoot)});
        } else if (theDistinct) {
            query.distinct(true).multiselect(new Selection[]{this.get("myId").as(Long.class)});
        } else {
            query.multiselect(new Selection[]{this.get("myId").as(Long.class)});
        }
        this.myQuery = query;
    }

    QueryRootEntryResourceTable(CriteriaBuilder theCriteriaBuilder, QueryRootEntry theParent, SearchParameterMap theSearchParameterMap, String theResourceType, RequestPartitionId theRequestPartitionId) {
        super(theCriteriaBuilder);
        Subquery query;
        this.myCriteriaBuilder = theCriteriaBuilder;
        this.mySearchParameterMap = theSearchParameterMap;
        this.myRequestPartitionId = theRequestPartitionId;
        this.myResourceType = theResourceType;
        AbstractQuery<Long> queryRoot = theParent.getQueryRoot();
        this.myQuery = query = queryRoot.subquery(Long.class);
        this.myResourceTableRoot = this.myQuery.from(ResourceTable.class);
        query.select(this.myResourceTableRoot.get("myId").as(Long.class));
    }

    @Override
    void orderBy(List<Order> theOrders) {
        assert (this.myQuery instanceof CriteriaQuery);
        ((CriteriaQuery)this.myQuery).orderBy(theOrders);
    }

    @Override
    Expression<Date> getLastUpdatedColumn() {
        return this.myResourceTableRoot.get("myUpdated").as(Date.class);
    }

    @Override
    <T> From<?, T> createJoin(SearchBuilderJoinEnum theType, String theSearchParameterName) {
        Join join = null;
        switch (theType) {
            case DATE: {
                join = this.myResourceTableRoot.join("myParamsDate", JoinType.LEFT);
                break;
            }
            case NUMBER: {
                join = this.myResourceTableRoot.join("myParamsNumber", JoinType.LEFT);
                break;
            }
            case QUANTITY: {
                join = this.myResourceTableRoot.join("myParamsQuantity", JoinType.LEFT);
                break;
            }
            case REFERENCE: {
                join = this.myResourceTableRoot.join("myResourceLinks", JoinType.LEFT);
                break;
            }
            case STRING: {
                join = this.myResourceTableRoot.join("myParamsString", JoinType.LEFT);
                break;
            }
            case URI: {
                join = this.myResourceTableRoot.join("myParamsUri", JoinType.LEFT);
                break;
            }
            case TOKEN: {
                join = this.myResourceTableRoot.join("myParamsToken", JoinType.LEFT);
                break;
            }
            case COORDS: {
                join = this.myResourceTableRoot.join("myParamsCoords", JoinType.LEFT);
                break;
            }
            case HAS: {
                join = this.myResourceTableRoot.join("myResourceLinksAsTarget", JoinType.LEFT);
                break;
            }
            case PROVENANCE: {
                join = this.myResourceTableRoot.join("myProvenance", JoinType.LEFT);
                break;
            }
            case FORCED_ID: {
                join = this.myResourceTableRoot.join("myForcedId", JoinType.LEFT);
                break;
            }
            case PRESENCE: {
                join = this.myResourceTableRoot.join("mySearchParamPresents", JoinType.LEFT);
                break;
            }
            case COMPOSITE_UNIQUE: {
                join = this.myResourceTableRoot.join("myParamsComboStringUnique", JoinType.LEFT);
                break;
            }
            case RESOURCE_TAGS: {
                join = this.myResourceTableRoot.join("myTags", JoinType.LEFT);
            }
        }
        SearchBuilderJoinKey key = new SearchBuilderJoinKey(theSearchParameterName, theType);
        this.putIndex(key, join);
        return join;
    }

    @Override
    AbstractQuery<Long> getQueryRoot() {
        return this.myQuery;
    }

    Root<ResourceTable> getRoot() {
        return this.myResourceTableRoot;
    }

    @Override
    public Expression<Long> getResourcePidColumn() {
        return this.myResourceTableRoot.get("myId").as(Long.class);
    }

    @Override
    public Subquery<Long> subqueryForTagNegation() {
        return this.myQuery.subquery(Long.class);
    }
}

