/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.predicate.querystack;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinEnum;
import ca.uhn.fhir.jpa.dao.predicate.SearchBuilderJoinKey;
import ca.uhn.fhir.jpa.dao.predicate.querystack.QueryRootEntry;
import ca.uhn.fhir.jpa.dao.predicate.querystack.QueryRootEntryIndexTable;
import ca.uhn.fhir.jpa.dao.predicate.querystack.QueryRootEntryResourceTable;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamDate;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class QueryStack {
    private final Stack<QueryRootEntry> myQueryRootStack = new Stack();
    private final CriteriaBuilder myCriteriaBuilder;
    private final SearchParameterMap mySearchParameterMap;
    private final RequestPartitionId myRequestPartitionId;
    private final String myResourceType;

    public QueryStack(CriteriaBuilder theCriteriaBuilder, String theResourceType, SearchParameterMap theSearchParameterMap, RequestPartitionId theRequestPartitionId) {
        assert (theCriteriaBuilder != null);
        assert (StringUtils.isNotBlank((CharSequence)theResourceType));
        assert (theSearchParameterMap != null);
        assert (theRequestPartitionId != null);
        this.myCriteriaBuilder = theCriteriaBuilder;
        this.mySearchParameterMap = theSearchParameterMap;
        this.myRequestPartitionId = theRequestPartitionId;
        this.myResourceType = theResourceType;
    }

    public void pushResourceTableQuery() {
        assert (this.myQueryRootStack.isEmpty());
        this.myQueryRootStack.push(new QueryRootEntryResourceTable(this.myCriteriaBuilder, false, false, this.mySearchParameterMap, this.myResourceType, this.myRequestPartitionId));
    }

    public void pushResourceTableDistinctQuery() {
        assert (this.myQueryRootStack.isEmpty());
        this.myQueryRootStack.push(new QueryRootEntryResourceTable(this.myCriteriaBuilder, true, false, this.mySearchParameterMap, this.myResourceType, this.myRequestPartitionId));
    }

    public void pushResourceTableCountQuery() {
        assert (this.myQueryRootStack.isEmpty());
        this.myQueryRootStack.push(new QueryRootEntryResourceTable(this.myCriteriaBuilder, false, true, this.mySearchParameterMap, this.myResourceType, this.myRequestPartitionId));
    }

    public void pushResourceTableSubQuery(String theResourceType) {
        assert (!this.myQueryRootStack.isEmpty());
        this.myQueryRootStack.push(new QueryRootEntryResourceTable(this.myCriteriaBuilder, this.top(), this.mySearchParameterMap, theResourceType, this.myRequestPartitionId));
    }

    public void pushIndexTableSubQuery() {
        assert (!this.myQueryRootStack.isEmpty());
        this.myQueryRootStack.push(new QueryRootEntryIndexTable(this.myCriteriaBuilder, this.top()));
    }

    public AbstractQuery<Long> pop() {
        QueryRootEntry element = this.myQueryRootStack.pop();
        return element.pop();
    }

    public <T> From<?, T> createJoin(SearchBuilderJoinEnum theType, String theSearchParameterName) {
        return this.top().createJoin(theType, theSearchParameterName);
    }

    public Optional<Join<?, ?>> getExistingJoin(SearchBuilderJoinKey theKey) {
        return this.top().getIndexJoin(theKey);
    }

    public <Y> Path<Y> get(String theAttributeName) {
        return this.top().get(theAttributeName);
    }

    public void addPredicate(Predicate thePredicate) {
        this.top().addPredicate(thePredicate);
    }

    public void addPredicateWithImplicitTypeSelection(Predicate thePredicate) {
        this.setHasImplicitTypeSelection();
        this.addPredicate(thePredicate);
    }

    public void addPredicatesWithImplicitTypeSelection(List<Predicate> thePredicates) {
        this.setHasImplicitTypeSelection();
        this.addPredicates(thePredicates);
    }

    public void addPredicates(List<Predicate> thePredicates) {
        this.top().addPredicates(thePredicates);
    }

    public void clearPredicates() {
        this.top().clearPredicates();
    }

    public List<Predicate> getPredicates() {
        return this.top().getPredicates();
    }

    private void setHasImplicitTypeSelection() {
        this.top().setHasImplicitTypeSelection(true);
    }

    public void clearHasImplicitTypeSelection() {
        this.top().setHasImplicitTypeSelection(false);
    }

    public boolean isEmpty() {
        return this.myQueryRootStack.isEmpty();
    }

    public void orderBy(List<Order> theOrders) {
        this.top().orderBy(theOrders);
    }

    public Expression<Date> getLastUpdatedColumn() {
        return this.top().getLastUpdatedColumn();
    }

    public Expression<Long> getResourcePidColumn() {
        return this.top().getResourcePidColumn();
    }

    public Subquery<Long> subqueryForTagNegation() {
        return this.top().subqueryForTagNegation();
    }

    private QueryRootEntry top() {
        Validate.isTrue((!this.myQueryRootStack.empty() ? 1 : 0) != 0);
        return this.myQueryRootStack.peek();
    }

    public Root<?> getRootForComposite() {
        return this.top().getRoot();
    }

    public Predicate addNeverMatchingPredicate() {
        return this.top().addNeverMatchingPredicate();
    }

    public Map<String, From<?, ResourceIndexedSearchParamDate>> getJoinMap() {
        return this.top().getJoinMap();
    }
}

