/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.r4;

import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoValueSet;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.dao.FhirResourceDaoValueSetDstu2;
import ca.uhn.fhir.jpa.dao.dstu3.FhirResourceDaoValueSetDstu3;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import java.util.Date;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ValueSet;

public class FhirResourceDaoValueSetR4
extends BaseHapiFhirResourceDao<ValueSet>
implements IFhirResourceDaoValueSet<ValueSet, Coding, CodeableConcept> {
    public ValueSet expand(IIdType theId, ValueSetExpansionOptions theOptions, RequestDetails theRequestDetails) {
        ValueSet source = (ValueSet)this.read(theId, theRequestDetails);
        return this.expand(source, theOptions);
    }

    public ValueSet expandByIdentifier(String theUri, ValueSetExpansionOptions theOptions) {
        return this.myTerminologySvc.expandValueSet(theOptions, theUri);
    }

    public ValueSet expand(ValueSet theSource, ValueSetExpansionOptions theOptions) {
        return this.myTerminologySvc.expandValueSet(theOptions, theSource);
    }

    public IValidationSupport.CodeValidationResult validateCode(IPrimitiveType<String> theValueSetIdentifier, IIdType theId, IPrimitiveType<String> theCode, IPrimitiveType<String> theSystem, IPrimitiveType<String> theDisplay, Coding theCoding, CodeableConcept theCodeableConcept, RequestDetails theRequestDetails) {
        return this.myTerminologySvc.validateCode(FhirResourceDaoValueSetDstu3.vsValidateCodeOptions(), theId, FhirResourceDaoValueSetDstu2.toStringOrNull(theValueSetIdentifier), FhirResourceDaoValueSetDstu2.toStringOrNull(theSystem), FhirResourceDaoValueSetDstu2.toStringOrNull(theCode), FhirResourceDaoValueSetDstu2.toStringOrNull(theDisplay), (IBaseDatatype)theCoding, (IBaseDatatype)theCodeableConcept);
    }

    public void purgeCaches() {
    }

    @Override
    public ResourceTable updateEntity(RequestDetails theRequestDetails, IBaseResource theResource, IBasePersistedResource theEntity, Date theDeletedTimestampOrNull, boolean thePerformIndexing, boolean theUpdateVersion, TransactionDetails theTransactionDetails, boolean theForceUpdate, boolean theCreateNewHistoryEntry) {
        ResourceTable retVal = super.updateEntity(theRequestDetails, theResource, theEntity, theDeletedTimestampOrNull, thePerformIndexing, theUpdateVersion, theTransactionDetails, theForceUpdate, theCreateNewHistoryEntry);
        if (this.getConfig().isPreExpandValueSets() && !retVal.isUnchangedInCurrentOperation()) {
            if (retVal.getDeleted() == null) {
                ValueSet valueSet = (ValueSet)theResource;
                this.myTerminologySvc.storeTermValueSet(retVal, valueSet);
            } else {
                this.myTerminologySvc.deleteValueSetAndChildren(retVal);
            }
        }
        return retVal;
    }
}

