/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.r5;

import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoConceptMap;
import ca.uhn.fhir.jpa.api.model.TranslationRequest;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.term.api.ITermConceptMappingSvc;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import java.util.Date;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_40_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r5.model.Resource;
import org.springframework.beans.factory.annotation.Autowired;

public class FhirResourceDaoConceptMapR5
extends BaseHapiFhirResourceDao<org.hl7.fhir.r5.model.ConceptMap>
implements IFhirResourceDaoConceptMap<org.hl7.fhir.r5.model.ConceptMap> {
    @Autowired
    private ITermConceptMappingSvc myTermConceptMappingSvc;

    public TranslateConceptResults translate(TranslationRequest theTranslationRequest, RequestDetails theRequestDetails) {
        if (theTranslationRequest.hasReverse() && theTranslationRequest.getReverseAsBoolean()) {
            return this.myTermConceptMappingSvc.translateWithReverse(theTranslationRequest);
        }
        return this.myTermConceptMappingSvc.translate(theTranslationRequest);
    }

    @Override
    public ResourceTable updateEntity(RequestDetails theRequestDetails, IBaseResource theResource, IBasePersistedResource theEntity, Date theDeletedTimestampOrNull, boolean thePerformIndexing, boolean theUpdateVersion, TransactionDetails theTransactionDetails, boolean theForceUpdate, boolean theCreateNewHistoryEntry) {
        ResourceTable retVal = super.updateEntity(theRequestDetails, theResource, theEntity, theDeletedTimestampOrNull, thePerformIndexing, theUpdateVersion, theTransactionDetails, theForceUpdate, theCreateNewHistoryEntry);
        if (!retVal.isUnchangedInCurrentOperation()) {
            if (retVal.getDeleted() == null) {
                org.hl7.fhir.r5.model.ConceptMap conceptMap = (org.hl7.fhir.r5.model.ConceptMap)theResource;
                this.myTermConceptMappingSvc.storeTermConceptMapAndChildren(retVal, (ConceptMap)VersionConvertorFactory_40_50.convertResource((Resource)conceptMap, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false))));
            } else {
                this.myTermConceptMappingSvc.deleteConceptMapAndChildren(retVal);
            }
        }
        return retVal;
    }
}

