/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.r5;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDaoObservation;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.api.CacheControlDirective;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.model.Observation;
import org.springframework.beans.factory.annotation.Autowired;

public class FhirResourceDaoObservationR5
extends BaseHapiFhirResourceDaoObservation<Observation> {
    @Autowired
    private IRequestPartitionHelperSvc myPartitionHelperSvc;

    public IBundleProvider observationsLastN(SearchParameterMap theSearchParameterMap, RequestDetails theRequestDetails, HttpServletResponse theServletResponse) {
        this.updateSearchParamsForLastn(theSearchParameterMap, theRequestDetails);
        RequestPartitionId requestPartitionId = this.myPartitionHelperSvc.determineReadPartitionForRequestForSearchType(theRequestDetails, this.getResourceName(), theSearchParameterMap, null);
        return this.mySearchCoordinatorSvc.registerSearch((IFhirResourceDao)this, theSearchParameterMap, this.getResourceName(), new CacheControlDirective().parse(theRequestDetails.getHeaders("Cache-Control")), theRequestDetails, requestPartitionId);
    }

    @Override
    protected String getEffectiveParamName() {
        return "date";
    }

    @Override
    protected String getCodeParamName() {
        return "code";
    }

    @Override
    protected String getSubjectParamName() {
        return "subject";
    }

    @Override
    protected String getPatientParamName() {
        return "patient";
    }

    @Override
    public ResourceTable updateEntity(RequestDetails theRequest, IBaseResource theResource, IBasePersistedResource theEntity, Date theDeletedTimestampOrNull, boolean thePerformIndexing, boolean theUpdateVersion, TransactionDetails theTransactionDetails, boolean theForceUpdate, boolean theCreateNewHistoryEntry) {
        return this.updateObservationEntity(theRequest, theResource, theEntity, theDeletedTimestampOrNull, thePerformIndexing, theUpdateVersion, theTransactionDetails, theForceUpdate, theCreateNewHistoryEntry);
    }
}

