/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.tx;

import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.model.ResourceVersionConflictResolutionStrategy;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirDao;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class HapiTransactionService {
    private static final Logger ourLog = LoggerFactory.getLogger(HapiTransactionService.class);
    @Autowired
    protected IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    protected PlatformTransactionManager myTransactionManager;
    protected TransactionTemplate myTxTemplate;

    @VisibleForTesting
    public void setInterceptorBroadcaster(IInterceptorBroadcaster theInterceptorBroadcaster) {
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
    }

    @VisibleForTesting
    public void setTransactionManager(PlatformTransactionManager theTransactionManager) {
        this.myTransactionManager = theTransactionManager;
    }

    @PostConstruct
    public void start() {
        this.myTxTemplate = new TransactionTemplate(this.myTransactionManager);
    }

    public <T> T execute(RequestDetails theRequestDetails, TransactionDetails theTransactionDetails, TransactionCallback<T> theCallback) {
        return this.execute(theRequestDetails, theTransactionDetails, theCallback, null);
    }

    public <T> T execute(RequestDetails theRequestDetails, TransactionDetails theTransactionDetails, TransactionCallback<T> theCallback, Runnable theOnRollback) {
        int i = 0;
        while (true) {
            try {
                return this.doExecuteCallback(theCallback);
            }
            catch (ResourceVersionConflictException | DataIntegrityViolationException e) {
                HookParams params;
                ResourceVersionConflictResolutionStrategy conflictResolutionStrategy;
                ourLog.debug("Version conflict detected", e);
                if (theOnRollback != null) {
                    theOnRollback.run();
                }
                int maxRetries = 0;
                if (e.getMessage().contains("HFJ_TAG_DEF") || e.getMessage().contains("hfj_tag_def") || e.getMessage().contains("HFJ_RES_TAG") || e.getMessage().contains("hfj_res_tag")) {
                    maxRetries = 3;
                }
                if (maxRetries == 0 && (conflictResolutionStrategy = (ResourceVersionConflictResolutionStrategy)CompositeInterceptorBroadcaster.doCallHooksAndReturnObject((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.STORAGE_VERSION_CONFLICT, (HookParams)(params = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails)))) != null && conflictResolutionStrategy.isRetry()) {
                    maxRetries = conflictResolutionStrategy.getMaxRetries();
                }
                if (i >= maxRetries) {
                    IBaseOperationOutcome oo = null;
                    if (e instanceof ResourceVersionConflictException) {
                        oo = ((ResourceVersionConflictException)e).getOperationOutcome();
                    }
                    if (maxRetries > 0) {
                        String msg = "Max retries (" + maxRetries + ") exceeded for version conflict: " + e.getMessage();
                        ourLog.info(msg, (Object)maxRetries);
                        throw new ResourceVersionConflictException(msg);
                    }
                    throw new ResourceVersionConflictException(e.getMessage(), e, oo);
                }
                theTransactionDetails.getRollbackUndoActions().forEach(t -> t.run());
                theTransactionDetails.clearRollbackUndoActions();
                theTransactionDetails.clearResolvedItems();
                theTransactionDetails.clearUserData(BaseHapiFhirDao.XACT_USERDATA_KEY_RESOLVED_TAG_DEFINITIONS);
                theTransactionDetails.clearUserData(BaseHapiFhirDao.XACT_USERDATA_KEY_EXISTING_SEARCH_PARAMS);
                double sleepAmount = 250.0 * (double)i * Math.random();
                long sleepAmountLong = (long)sleepAmount;
                HapiTransactionService.sleepAtLeast(sleepAmountLong, false);
                ourLog.info("About to start a transaction retry due to conflict or constraint error. Sleeping {}ms first.", (Object)sleepAmountLong);
                ++i;
                continue;
            }
            break;
        }
    }

    @Nullable
    protected <T> T doExecuteCallback(TransactionCallback<T> theCallback) {
        try {
            return (T)this.myTxTemplate.execute(theCallback);
        }
        catch (MyException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new InternalErrorException((Throwable)e);
        }
    }

    public static void sleepAtLeast(long theMillis, boolean theLogProgress) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() <= start + theMillis) {
            try {
                long timeSinceStarted = System.currentTimeMillis() - start;
                long timeToSleep = Math.max(0L, theMillis - timeSinceStarted);
                if (theLogProgress) {
                    ourLog.info("Sleeping for {}ms", (Object)timeToSleep);
                }
                Thread.sleep(timeToSleep);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ourLog.error("Interrupted", (Throwable)e);
            }
        }
    }

    static class MyException
    extends RuntimeException {
        public MyException(Throwable theThrowable) {
            super(theThrowable);
        }
    }
}

