/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.delete;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.batch.api.IBatchJobSubmitter;
import ca.uhn.fhir.jpa.batch.job.PartitionedUrlValidator;
import ca.uhn.fhir.jpa.batch.job.model.RequestListJson;
import ca.uhn.fhir.jpa.batch.reader.ReverseCronologicalBatchResourcePidReader;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IDeleteExpungeJobSubmitter;
import ca.uhn.fhir.rest.server.exceptions.ForbiddenOperationException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import java.util.List;
import javax.transaction.Transactional;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DeleteExpungeJobSubmitterImpl
implements IDeleteExpungeJobSubmitter {
    @Autowired
    private IBatchJobSubmitter myBatchJobSubmitter;
    @Autowired
    @Qualifier(value="deleteExpungeJob")
    private Job myDeleteExpungeJob;
    @Autowired
    FhirContext myFhirContext;
    @Autowired
    MatchUrlService myMatchUrlService;
    @Autowired
    IRequestPartitionHelperSvc myRequestPartitionHelperSvc;
    @Autowired
    DaoConfig myDaoConfig;
    @Autowired
    PartitionedUrlValidator myPartitionedUrlValidator;
    @Autowired
    IInterceptorBroadcaster myInterceptorBroadcaster;

    @Transactional(value=Transactional.TxType.NEVER)
    public JobExecution submitJob(Integer theBatchSize, List<String> theUrlsToDeleteExpunge, RequestDetails theRequest) throws JobParametersInvalidException {
        if (theBatchSize == null) {
            theBatchSize = this.myDaoConfig.getExpungeBatchSize();
        }
        RequestListJson requestListJson = this.myPartitionedUrlValidator.buildRequestListJson(theRequest, theUrlsToDeleteExpunge);
        if (!this.myDaoConfig.canDeleteExpunge()) {
            throw new ForbiddenOperationException("Delete Expunge not allowed:  " + this.myDaoConfig.cannotDeleteExpungeReason());
        }
        for (String url : theUrlsToDeleteExpunge) {
            HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(String.class, (Object)url);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PRE_DELETE_EXPUNGE, (HookParams)params);
        }
        JobParameters jobParameters = ReverseCronologicalBatchResourcePidReader.buildJobParameters("$delete-expunge", theBatchSize, requestListJson);
        return this.myBatchJobSubmitter.runJob(this.myDeleteExpungeJob, jobParameters);
    }
}

