/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.delete.job;

import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.batch.job.MultiUrlProcessorJobConfig;
import ca.uhn.fhir.jpa.delete.job.DeleteExpungeProcessor;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.listener.ExecutionContextPromotionListener;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class DeleteExpungeJobConfig
extends MultiUrlProcessorJobConfig {
    public static final String DELETE_EXPUNGE_URL_LIST_STEP_NAME = "delete-expunge-url-list-step";
    @Autowired
    private StepBuilderFactory myStepBuilderFactory;
    @Autowired
    private JobBuilderFactory myJobBuilderFactory;

    @Bean(name={"deleteExpungeJob"})
    @Lazy
    public Job deleteExpungeJob(MatchUrlService theMatchUrlService, DaoRegistry theDaoRegistry) {
        return ((JobBuilder)this.myJobBuilderFactory.get("deleteExpungeJob").validator(this.multiUrlProcessorParameterValidator(theMatchUrlService, theDaoRegistry))).start(this.deleteExpungeUrlListStep()).build();
    }

    @Bean
    public Step deleteExpungeUrlListStep() {
        return ((AbstractTaskletStepBuilder)this.myStepBuilderFactory.get(DELETE_EXPUNGE_URL_LIST_STEP_NAME).chunk(1).reader((ItemReader)this.reverseCronologicalBatchResourcePidReader()).processor((ItemProcessor)this.deleteExpungeProcessor()).writer((ItemWriter)this.sqlExecutorWriter()).listener((Object)this.pidCountRecorderListener()).listener((StepExecutionListener)this.deleteExpungePromotionListener())).build();
    }

    @Bean
    public ExecutionContextPromotionListener deleteExpungePromotionListener() {
        ExecutionContextPromotionListener listener = new ExecutionContextPromotionListener();
        listener.setKeys(new String[]{"entity.total.updated-or-deleted", "resource.total.processed"});
        return listener;
    }

    @Bean
    @StepScope
    public DeleteExpungeProcessor deleteExpungeProcessor() {
        return new DeleteExpungeProcessor();
    }
}

