/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.delete.job;

import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.dao.data.IResourceLinkDao;
import ca.uhn.fhir.jpa.dao.expunge.PartitionRunner;
import ca.uhn.fhir.jpa.dao.expunge.ResourceForeignKey;
import ca.uhn.fhir.jpa.dao.expunge.ResourceTableFKProvider;
import ca.uhn.fhir.jpa.dao.index.IdHelperService;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;

public class DeleteExpungeProcessor
implements ItemProcessor<List<Long>, List<String>> {
    private static final Logger ourLog = LoggerFactory.getLogger(DeleteExpungeProcessor.class);
    public static final String PROCESS_NAME = "Delete Expunging";
    public static final String THREAD_PREFIX = "delete-expunge";
    @Autowired
    ResourceTableFKProvider myResourceTableFKProvider;
    @Autowired
    DaoConfig myDaoConfig;
    @Autowired
    IdHelperService myIdHelper;
    @Autowired
    IResourceLinkDao myResourceLinkDao;

    public List<String> process(List<Long> thePids) throws Exception {
        this.validateOkToDeleteAndExpunge((Slice<Long>)new SliceImpl(thePids));
        ArrayList<String> retval = new ArrayList<String>();
        String pidListString = thePids.toString().replace("[", "(").replace("]", ")");
        List<ResourceForeignKey> resourceForeignKeys = this.myResourceTableFKProvider.getResourceForeignKeys();
        for (ResourceForeignKey resourceForeignKey : resourceForeignKeys) {
            retval.add(this.deleteRecordsByColumnSql(pidListString, resourceForeignKey));
        }
        ResourceForeignKey resourceTablePk = new ResourceForeignKey("HFJ_RESOURCE", "RES_ID");
        retval.add(this.deleteRecordsByColumnSql(pidListString, resourceTablePk));
        return retval;
    }

    public void validateOkToDeleteAndExpunge(Slice<Long> thePids) {
        if (!this.myDaoConfig.isEnforceReferentialIntegrityOnDelete()) {
            ourLog.info("Referential integrity on delete disabled.  Skipping referential integrity check.");
            return;
        }
        List conflictResourceLinks = Collections.synchronizedList(new ArrayList());
        PartitionRunner partitionRunner = new PartitionRunner(PROCESS_NAME, THREAD_PREFIX, this.myDaoConfig.getExpungeBatchSize(), this.myDaoConfig.getExpungeThreadCount());
        partitionRunner.runInPartitionedThreads(thePids, someTargetPids -> this.findResourceLinksWithTargetPidIn(thePids.getContent(), (List<Long>)someTargetPids, conflictResourceLinks));
        if (conflictResourceLinks.isEmpty()) {
            return;
        }
        ResourceLink firstConflict = (ResourceLink)conflictResourceLinks.get(0);
        String sourceResourceId = this.myIdHelper.resourceIdFromPidOrThrowException(firstConflict.getSourceResourcePid()).toVersionless().getValue();
        String targetResourceId = this.myIdHelper.resourceIdFromPidOrThrowException(firstConflict.getTargetResourcePid()).toVersionless().getValue();
        throw new InvalidRequestException("DELETE with _expunge=true failed.  Unable to delete " + targetResourceId + " because " + sourceResourceId + " refers to it via the path " + firstConflict.getSourcePath());
    }

    public void findResourceLinksWithTargetPidIn(List<Long> theAllTargetPids, List<Long> theSomeTargetPids, List<ResourceLink> theConflictResourceLinks) {
        if (theConflictResourceLinks.isEmpty()) {
            List conflictResourceLinks = this.myResourceLinkDao.findWithTargetPidIn(theSomeTargetPids).stream().filter(link -> !theAllTargetPids.contains(link.getSourceResourcePid())).collect(Collectors.toList());
            theConflictResourceLinks.addAll(conflictResourceLinks);
        }
    }

    private String deleteRecordsByColumnSql(String thePidListString, ResourceForeignKey theResourceForeignKey) {
        return "DELETE FROM " + theResourceForeignKey.table + " WHERE " + theResourceForeignKey.key + " IN " + thePidListString;
    }
}

