/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.builder.ToStringBuilder;

@Entity
@Table(name="MPI_LINK", uniqueConstraints={@UniqueConstraint(name="IDX_EMPI_PERSON_TGT", columnNames={"PERSON_PID", "TARGET_PID"})})
public class MdmLink {
    public static final int VERSION_LENGTH = 16;
    private static final int MATCH_RESULT_LENGTH = 16;
    private static final int LINK_SOURCE_LENGTH = 16;
    public static final int SOURCE_TYPE_LENGTH = 40;
    @SequenceGenerator(name="SEQ_EMPI_LINK_ID", sequenceName="SEQ_EMPI_LINK_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_EMPI_LINK_ID")
    @Id
    @Column(name="PID")
    private Long myId;
    @ManyToOne(optional=false, fetch=FetchType.LAZY, cascade={})
    @JoinColumn(name="GOLDEN_RESOURCE_PID", referencedColumnName="RES_ID", foreignKey=@ForeignKey(name="FK_EMPI_LINK_GOLDEN_RESOURCE"), insertable=false, updatable=false, nullable=false)
    private ResourceTable myGoldenResource;
    @Column(name="GOLDEN_RESOURCE_PID", nullable=false)
    private Long myGoldenResourcePid;
    @Deprecated
    @ManyToOne(optional=false, fetch=FetchType.LAZY, cascade={})
    @JoinColumn(name="PERSON_PID", referencedColumnName="RES_ID", foreignKey=@ForeignKey(name="FK_EMPI_LINK_PERSON"), insertable=false, updatable=false, nullable=false)
    private ResourceTable myPerson;
    @Deprecated
    @Column(name="PERSON_PID", nullable=false)
    private Long myPersonPid;
    @ManyToOne(optional=false, fetch=FetchType.LAZY, cascade={})
    @JoinColumn(name="TARGET_PID", referencedColumnName="RES_ID", foreignKey=@ForeignKey(name="FK_EMPI_LINK_TARGET"), insertable=false, updatable=false, nullable=false)
    private ResourceTable mySource;
    @Column(name="TARGET_PID", updatable=false, nullable=false)
    private Long mySourcePid;
    @Column(name="MATCH_RESULT", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private MdmMatchResultEnum myMatchResult;
    @Column(name="LINK_SOURCE", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private MdmLinkSourceEnum myLinkSource;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED", nullable=false)
    private Date myCreated;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="UPDATED", nullable=false)
    private Date myUpdated;
    @Column(name="VERSION", nullable=false, length=16)
    private String myVersion;
    @Column(name="EID_MATCH")
    private Boolean myEidMatch;
    @Column(name="NEW_PERSON")
    private Boolean myHadToCreateNewGoldenResource;
    @Column(name="VECTOR")
    private Long myVector;
    @Column(name="SCORE")
    private Double myScore;
    @Column(name="RULE_COUNT")
    private Long myRuleCount;
    @Column(name="TARGET_TYPE", nullable=true, length=40)
    private String myMdmSourceType;

    public MdmLink() {
    }

    public MdmLink(String theVersion) {
        this.myVersion = theVersion;
    }

    public Long getId() {
        return this.myId;
    }

    public MdmLink setId(Long theId) {
        this.myId = theId;
        return this;
    }

    public ResourceTable getGoldenResource() {
        return this.myGoldenResource;
    }

    public MdmLink setGoldenResource(ResourceTable theGoldenResource) {
        this.myGoldenResource = theGoldenResource;
        this.myGoldenResourcePid = theGoldenResource.getId();
        this.myPerson = theGoldenResource;
        this.myPersonPid = theGoldenResource.getId();
        return this;
    }

    public Long getGoldenResourcePid() {
        return this.myGoldenResourcePid;
    }

    @Deprecated
    public MdmLink setPersonPid(Long thePersonPid) {
        this.myPersonPid = thePersonPid;
        return this;
    }

    public MdmLink setGoldenResourcePid(Long theGoldenResourcePid) {
        this.setPersonPid(theGoldenResourcePid);
        this.myGoldenResourcePid = theGoldenResourcePid;
        return this;
    }

    public ResourceTable getSource() {
        return this.mySource;
    }

    public MdmLink setSource(ResourceTable theSource) {
        this.mySource = theSource;
        this.mySourcePid = theSource.getId();
        return this;
    }

    public Long getSourcePid() {
        return this.mySourcePid;
    }

    public MdmLink setSourcePid(Long theSourcePid) {
        this.mySourcePid = theSourcePid;
        return this;
    }

    public MdmMatchResultEnum getMatchResult() {
        return this.myMatchResult;
    }

    public MdmLink setMatchResult(MdmMatchResultEnum theMatchResult) {
        this.myMatchResult = theMatchResult;
        return this;
    }

    public boolean isNoMatch() {
        return this.myMatchResult == MdmMatchResultEnum.NO_MATCH;
    }

    public boolean isMatch() {
        return this.myMatchResult == MdmMatchResultEnum.MATCH;
    }

    public boolean isPossibleMatch() {
        return this.myMatchResult == MdmMatchResultEnum.POSSIBLE_MATCH;
    }

    public boolean isRedirect() {
        return this.myMatchResult == MdmMatchResultEnum.REDIRECT;
    }

    public boolean isPossibleDuplicate() {
        return this.myMatchResult == MdmMatchResultEnum.POSSIBLE_DUPLICATE;
    }

    public MdmLinkSourceEnum getLinkSource() {
        return this.myLinkSource;
    }

    public MdmLink setLinkSource(MdmLinkSourceEnum theLinkSource) {
        this.myLinkSource = theLinkSource;
        return this;
    }

    public boolean isAuto() {
        return this.myLinkSource == MdmLinkSourceEnum.AUTO;
    }

    public boolean isManual() {
        return this.myLinkSource == MdmLinkSourceEnum.MANUAL;
    }

    public Date getCreated() {
        return this.myCreated;
    }

    public MdmLink setCreated(Date theCreated) {
        this.myCreated = theCreated;
        return this;
    }

    public Date getUpdated() {
        return this.myUpdated;
    }

    public MdmLink setUpdated(Date theUpdated) {
        this.myUpdated = theUpdated;
        return this;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public MdmLink setVersion(String theVersion) {
        this.myVersion = theVersion;
        return this;
    }

    public Long getVector() {
        return this.myVector;
    }

    public MdmLink setVector(Long theVector) {
        this.myVector = theVector;
        return this;
    }

    public Double getScore() {
        return this.myScore;
    }

    public MdmLink setScore(Double theScore) {
        this.myScore = theScore;
        return this;
    }

    public Boolean getEidMatch() {
        return this.myEidMatch;
    }

    public boolean isEidMatchPresent() {
        return this.myEidMatch != null && this.myEidMatch != false;
    }

    public MdmLink setEidMatch(Boolean theEidMatch) {
        this.myEidMatch = theEidMatch;
        return this;
    }

    public boolean getHadToCreateNewGoldenResource() {
        return this.myHadToCreateNewGoldenResource != null && this.myHadToCreateNewGoldenResource != false;
    }

    public MdmLink setHadToCreateNewGoldenResource(Boolean theHadToCreateNewResource) {
        this.myHadToCreateNewGoldenResource = theHadToCreateNewResource;
        return this;
    }

    public MdmLink setMdmSourceType(String mdmSourceType) {
        this.myMdmSourceType = mdmSourceType;
        return this;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("myId", (Object)this.myId).append("myGoldenResource", (Object)this.myGoldenResourcePid).append("mySourcePid", (Object)this.mySourcePid).append("myMdmSourceType", (Object)this.myMdmSourceType).append("myMatchResult", (Object)this.myMatchResult).append("myLinkSource", (Object)this.myLinkSource).append("myEidMatch", (Object)this.myEidMatch).append("myHadToCreateNewResource", (Object)this.myHadToCreateNewGoldenResource).append("myScore", (Object)this.myScore).append("myRuleCount", (Object)this.myRuleCount).toString();
    }

    public String getMdmSourceType() {
        return this.myMdmSourceType;
    }

    public Long getRuleCount() {
        return this.myRuleCount;
    }

    public void setRuleCount(Long theRuleCount) {
        this.myRuleCount = theRuleCount;
    }
}

