/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.graphql;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirDao;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateOrListParam;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.NumberOrListParam;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.QuantityOrListParam;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceOrListParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.SpecialOrListParam;
import ca.uhn.fhir.rest.param.SpecialParam;
import ca.uhn.fhir.rest.param.StringOrListParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.NotImplementedOperationException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.utilities.graphql.Argument;
import org.hl7.fhir.utilities.graphql.IGraphQLStorageServices;
import org.hl7.fhir.utilities.graphql.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class JpaStorageServices
extends BaseHapiFhirDao<IBaseResource>
implements IGraphQLStorageServices {
    private static final int MAX_SEARCH_SIZE = 500;
    private static final Logger ourLog = LoggerFactory.getLogger(JpaStorageServices.class);

    private IFhirResourceDao<? extends IBaseResource> getDao(String theResourceType) {
        RuntimeResourceDefinition typeDef = this.getContext().getResourceDefinition(theResourceType);
        return this.myDaoRegistry.getResourceDaoOrNull(typeDef.getImplementingClass());
    }

    private String graphqlArgumentToSearchParam(String name) {
        if (name.startsWith("_")) {
            return name;
        }
        return name.replaceAll("_", "-");
    }

    private String searchParamToGraphqlArgument(String name) {
        return name.replaceAll("-", "_");
    }

    @Transactional(propagation=Propagation.NEVER)
    public void listResources(Object theAppInfo, String theType, List<Argument> theSearchParams, List<IBaseResource> theMatches) throws FHIRException {
        FhirContext fhirContext = this.getContext();
        RuntimeResourceDefinition typeDef = fhirContext.getResourceDefinition(theType);
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDaoOrNull(typeDef.getImplementingClass());
        SearchParameterMap params = new SearchParameterMap();
        params.setLoadSynchronousUpTo(Integer.valueOf(500));
        Map searchParams = this.mySearchParamRegistry.getActiveSearchParams(typeDef.getName());
        for (Argument nextArgument : theSearchParams) {
            NumberOrListParam queryParam;
            if (nextArgument.getName().equals("_filter")) {
                String value = ((Value)nextArgument.getValues().get(0)).getValue();
                params.add("_filter", (IQueryParameterType)new StringParam(value));
                continue;
            }
            String searchParamName = this.graphqlArgumentToSearchParam(nextArgument.getName());
            RuntimeSearchParam searchParam = (RuntimeSearchParam)searchParams.get(searchParamName);
            if (searchParam == null) {
                Set graphqlArguments = searchParams.keySet().stream().map(this::searchParamToGraphqlArgument).collect(Collectors.toSet());
                String msg = this.getContext().getLocalizer().getMessageSanitized(JpaStorageServices.class, "invalidGraphqlArgument", new Object[]{nextArgument.getName(), new TreeSet(graphqlArguments)});
                throw new InvalidRequestException(msg);
            }
            switch (searchParam.getParamType()) {
                case NUMBER: {
                    NumberOrListParam numberOrListParam = new NumberOrListParam();
                    for (Value value : nextArgument.getValues()) {
                        numberOrListParam.addOr(new NumberParam(value.getValue()));
                    }
                    queryParam = numberOrListParam;
                    break;
                }
                case DATE: {
                    Value value;
                    DateOrListParam dateOrListParam = new DateOrListParam();
                    value = nextArgument.getValues().iterator();
                    while (value.hasNext()) {
                        Value value2 = (Value)value.next();
                        dateOrListParam.addOr(new DateParam(value2.getValue()));
                    }
                    queryParam = dateOrListParam;
                    break;
                }
                case STRING: {
                    StringOrListParam stringOrListParam = new StringOrListParam();
                    for (Value value : nextArgument.getValues()) {
                        stringOrListParam.addOr(new StringParam(value.getValue()));
                    }
                    queryParam = stringOrListParam;
                    break;
                }
                case TOKEN: {
                    Value value;
                    TokenOrListParam tokenOrListParam = new TokenOrListParam();
                    value = nextArgument.getValues().iterator();
                    while (value.hasNext()) {
                        Value value3 = (Value)value.next();
                        TokenParam tokenParam = new TokenParam();
                        tokenParam.setValueAsQueryToken(fhirContext, searchParamName, null, value3.getValue());
                        tokenOrListParam.addOr(tokenParam);
                    }
                    queryParam = tokenOrListParam;
                    break;
                }
                case REFERENCE: {
                    ReferenceOrListParam referenceOrListParam = new ReferenceOrListParam();
                    for (Value value : nextArgument.getValues()) {
                        referenceOrListParam.addOr(new ReferenceParam(value.getValue()));
                    }
                    queryParam = referenceOrListParam;
                    break;
                }
                case QUANTITY: {
                    Value value;
                    QuantityOrListParam quantityOrListParam = new QuantityOrListParam();
                    value = nextArgument.getValues().iterator();
                    while (value.hasNext()) {
                        Value value4 = (Value)value.next();
                        quantityOrListParam.addOr(new QuantityParam(value4.getValue()));
                    }
                    queryParam = quantityOrListParam;
                    break;
                }
                case SPECIAL: {
                    SpecialOrListParam specialOrListParam = new SpecialOrListParam();
                    for (Value value : nextArgument.getValues()) {
                        specialOrListParam.addOr(new SpecialParam().setValue(value.getValue()));
                    }
                    queryParam = specialOrListParam;
                    break;
                }
                default: {
                    throw new InvalidRequestException(String.format("%s parameters are not yet supported in GraphQL", searchParam.getParamType()));
                }
            }
            params.add(searchParamName, (IQueryParameterOr)queryParam);
        }
        RequestDetails requestDetails = (RequestDetails)theAppInfo;
        IBundleProvider response = dao.search(params, requestDetails);
        int size = response.size();
        if (response.preferredPageSize() != null && response.preferredPageSize() < size) {
            size = response.preferredPageSize();
        }
        theMatches.addAll(response.getResources(0, size));
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public IBaseResource lookup(Object theAppInfo, String theType, String theId) throws FHIRException {
        IIdType refId = this.getContext().getVersion().newIdType();
        refId.setValue(theType + "/" + theId);
        return this.lookup(theAppInfo, refId);
    }

    private IBaseResource lookup(Object theAppInfo, IIdType theRefId) {
        IFhirResourceDao<? extends IBaseResource> dao = this.getDao(theRefId.getResourceType());
        RequestDetails requestDetails = (RequestDetails)theAppInfo;
        return dao.read(theRefId, requestDetails, false);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public IGraphQLStorageServices.ReferenceResolution lookup(Object theAppInfo, IBaseResource theContext, IBaseReference theReference) throws FHIRException {
        IBaseResource outcome = this.lookup(theAppInfo, theReference.getReferenceElement());
        if (outcome == null) {
            return null;
        }
        return new IGraphQLStorageServices.ReferenceResolution(theContext, outcome);
    }

    @Transactional(propagation=Propagation.NEVER)
    public IBaseBundle search(Object theAppInfo, String theType, List<Argument> theSearchParams) throws FHIRException {
        throw new NotImplementedOperationException("Not yet able to handle this GraphQL request");
    }

    @Override
    @Nullable
    protected String getResourceName() {
        return null;
    }
}

