/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.interceptor;

import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.util.ICallable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.hl7.fhir.instance.model.api.IBaseResource;

@NotThreadSafe
public class JpaPreResourceAccessDetails
implements IPreResourceAccessDetails {
    private final List<ResourcePersistentId> myResourcePids;
    private final boolean[] myBlocked;
    private final ICallable<ISearchBuilder> mySearchBuilderSupplier;
    private List<IBaseResource> myResources;

    public JpaPreResourceAccessDetails(List<ResourcePersistentId> theResourcePids, ICallable<ISearchBuilder> theSearchBuilderSupplier) {
        this.myResourcePids = theResourcePids;
        this.myBlocked = new boolean[this.myResourcePids.size()];
        this.mySearchBuilderSupplier = theSearchBuilderSupplier;
    }

    public int size() {
        return this.myResourcePids.size();
    }

    public IBaseResource getResource(int theIndex) {
        if (this.myResources == null) {
            this.myResources = new ArrayList<IBaseResource>(this.myResourcePids.size());
            ((ISearchBuilder)this.mySearchBuilderSupplier.call()).loadResourcesByPid(this.myResourcePids, Collections.emptySet(), this.myResources, false, null);
        }
        return this.myResources.get(theIndex);
    }

    public void setDontReturnResourceAtIndex(int theIndex) {
        this.myBlocked[theIndex] = true;
    }

    public boolean isDontReturnResourceAtIndex(int theIndex) {
        return this.myBlocked[theIndex];
    }
}

