/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.interceptor;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.dao.mdm.MdmLinkExpandSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.param.ReferenceParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Interceptor
public class MdmSearchExpandingInterceptor {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private MdmLinkExpandSvc myMdmLinkExpandSvc;
    @Autowired
    private DaoConfig myDaoConfig;

    @Hook(value=Pointcut.STORAGE_PRESEARCH_REGISTERED)
    public void hook(SearchParameterMap theSearchParameterMap) {
        if (this.myDaoConfig.isAllowMdmExpansion()) {
            for (List andList : theSearchParameterMap.values()) {
                for (List orList : andList) {
                    this.expandAnyReferenceParameters(orList);
                }
            }
        }
    }

    private void expandAnyReferenceParameters(List<IQueryParameterType> orList) {
        ArrayList<ReferenceParam> toRemove = new ArrayList<ReferenceParam>();
        ArrayList toAdd = new ArrayList();
        for (IQueryParameterType iQueryParameterType : orList) {
            ReferenceParam refParam;
            if (!(iQueryParameterType instanceof ReferenceParam) || !(refParam = (ReferenceParam)iQueryParameterType).isMdmExpand()) continue;
            ourLog.debug("Found a reference parameter to expand: {}", (Object)refParam);
            Set<String> expandedResourceIds = this.myMdmLinkExpandSvc.expandMdmBySourceResourceId((IIdType)new IdDt(refParam.getValue()));
            if (expandedResourceIds.isEmpty()) {
                expandedResourceIds = this.myMdmLinkExpandSvc.expandMdmByGoldenResourceId(new IdDt(refParam.getValue()));
            }
            if (expandedResourceIds.isEmpty()) continue;
            ourLog.debug("Parameter has been expanded to: {}", (Object)String.join((CharSequence)", ", expandedResourceIds));
            toRemove.add(refParam);
            expandedResourceIds.stream().map(resourceId -> new ReferenceParam(refParam.getResourceType() + "/" + resourceId)).forEach(toAdd::add);
        }
        orList.removeAll(toRemove);
        orList.addAll(toAdd);
    }
}

