/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.interceptor;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails;
import ca.uhn.fhir.jpa.model.search.StorageProcessingMessage;
import ca.uhn.fhir.util.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@Interceptor
public class PerformanceTracingLoggingInterceptor {
    private static final Logger ourLog = LoggerFactory.getLogger(PerformanceTracingLoggingInterceptor.class);
    private final Logger myLog;
    private final Level myLevel;

    public PerformanceTracingLoggingInterceptor() {
        this(Level.INFO);
    }

    public PerformanceTracingLoggingInterceptor(Level theLevel) {
        this(ourLog, theLevel);
    }

    public PerformanceTracingLoggingInterceptor(Logger theLog, Level theLevel) {
        this.myLog = theLog;
        this.myLevel = theLevel;
    }

    @Hook(value=Pointcut.JPA_PERFTRACE_SEARCH_FIRST_RESULT_LOADED)
    public void searchFirstResultLoaded(SearchRuntimeDetails theOutcome) {
        this.log("Initial query result returned in {} for query {}", theOutcome.getQueryStopwatch(), theOutcome.getSearchUuid());
    }

    @Hook(value=Pointcut.JPA_PERFTRACE_SEARCH_SELECT_COMPLETE)
    public void searchSelectComplete(SearchRuntimeDetails theOutcome) {
        this.log("SqlQuery found {} matches in {} for query {}", theOutcome.getFoundMatchesCount(), theOutcome.getQueryStopwatch(), theOutcome.getSearchUuid());
    }

    @Hook(value=Pointcut.JPA_PERFTRACE_SEARCH_COMPLETE)
    public void searchComplete(SearchRuntimeDetails theOutcome) {
        this.log("SqlQuery {} is complete in {} - Found {} matches", theOutcome.getSearchUuid(), theOutcome.getQueryStopwatch(), theOutcome.getFoundMatchesCount());
    }

    @Hook(value=Pointcut.JPA_PERFTRACE_SEARCH_PASS_COMPLETE)
    public void searchPassComplete(SearchRuntimeDetails theOutcome) {
        this.log("SqlQuery {} pass complete and set to status {} in {} - Found {} matches", theOutcome.getSearchUuid(), theOutcome.getSearchStatus(), theOutcome.getQueryStopwatch(), theOutcome.getFoundMatchesCount());
    }

    @Hook(value=Pointcut.JPA_PERFTRACE_SEARCH_FAILED)
    public void searchFailed(SearchRuntimeDetails theOutcome) {
        this.log("SqlQuery {} failed in {} - Found {} matches", theOutcome.getSearchUuid(), theOutcome.getQueryStopwatch(), theOutcome.getFoundMatchesCount());
    }

    @Hook(value=Pointcut.JPA_PERFTRACE_INDEXSEARCH_QUERY_COMPLETE)
    public void indexSearchQueryComplete(SearchRuntimeDetails theOutcome) {
        this.log("Index query for {} completed in {} - Found {} matches", theOutcome.getSearchUuid(), theOutcome.getQueryStopwatch(), theOutcome.getFoundIndexMatchesCount());
    }

    @Hook(value=Pointcut.JPA_PERFTRACE_INFO)
    public void info(StorageProcessingMessage theMessage) {
        this.log("[INFO] " + theMessage, new Object[0]);
    }

    @Hook(value=Pointcut.JPA_PERFTRACE_WARNING)
    public void warning(StorageProcessingMessage theMessage) {
        this.log("[WARNING] " + theMessage, new Object[0]);
    }

    private void log(String theMessage, Object ... theArgs) {
        LogUtil.log((Logger)this.myLog, (Level)this.myLevel, (String)theMessage, (Object[])theArgs);
    }
}

