/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.interceptor.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.interceptor.validation.BaseTypedRule;
import ca.uhn.fhir.jpa.interceptor.validation.IRepositoryValidatingRule;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBaseResource;

class RuleRequireProfileDeclaration
extends BaseTypedRule {
    private final Collection<String> myProfileOptions;

    RuleRequireProfileDeclaration(FhirContext theFhirContext, String theType, Collection<String> theProfileOptions) {
        super(theFhirContext, theType);
        this.myProfileOptions = theProfileOptions;
    }

    @Override
    @Nonnull
    public IRepositoryValidatingRule.RuleEvaluation evaluate(RequestDetails theRequestDetails, @Nonnull IBaseResource theResource) {
        Optional<String> matchingProfile = theResource.getMeta().getProfile().stream().map(t -> t.getValueAsString()).filter(t -> this.myProfileOptions.contains(t)).findFirst();
        if (matchingProfile.isPresent()) {
            return IRepositoryValidatingRule.RuleEvaluation.forSuccess(this);
        }
        String msg = this.getFhirContext().getLocalizer().getMessage(RuleRequireProfileDeclaration.class, "noMatchingProfile", new Object[]{this.getResourceType(), this.myProfileOptions});
        return IRepositoryValidatingRule.RuleEvaluation.forFailure((IRepositoryValidatingRule)this, msg);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("resourceType", (Object)this.getResourceType()).append("profiles", this.myProfileOptions).toString();
    }
}

