/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.packages;

import ca.uhn.fhir.jpa.util.JsonDateDeserializer;
import ca.uhn.fhir.jpa.util.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;

@ApiModel(value="Represents an NPM package metadata response")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(creatorVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class NpmPackageMetadataJson {
    @JsonProperty(value="dist-tags")
    private DistTags myDistTags;
    @JsonProperty(value="modified")
    @JsonSerialize(using=JsonDateSerializer.class)
    @JsonDeserialize(using=JsonDateDeserializer.class)
    private Date myModified;
    @JsonProperty(value="name")
    private String myName;
    @JsonProperty(value="versions")
    private Map<String, Version> myVersionIdToVersion;

    public void addVersion(Version theVersion) {
        this.getVersions().put(theVersion.getVersion(), theVersion);
    }

    @Nonnull
    public Map<String, Version> getVersions() {
        if (this.myVersionIdToVersion == null) {
            this.myVersionIdToVersion = new LinkedHashMap<String, Version>();
        }
        return this.myVersionIdToVersion;
    }

    public DistTags getDistTags() {
        return this.myDistTags;
    }

    public void setDistTags(DistTags theDistTags) {
        this.myDistTags = theDistTags;
    }

    public void setModified(Date theModified) {
        this.myModified = theModified;
    }

    public void setName(String theName) {
        this.myName = theName;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonAutoDetect(creatorVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class Version {
        @JsonProperty(value="name")
        private String myName;
        @JsonProperty(value="version")
        private String myVersion;
        @JsonProperty(value="description")
        private String myDescription;
        @JsonProperty(value="fhirVersion")
        private String myFhirVersion;
        @ApiModelProperty(value="The size of this package in bytes", example="1000")
        @JsonProperty(value="_bytes")
        private long myBytes;

        public String getName() {
            return this.myName;
        }

        public void setName(String theName) {
            this.myName = theName;
        }

        public String getDescription() {
            return this.myDescription;
        }

        public void setDescription(String theDescription) {
            this.myDescription = theDescription;
        }

        public String getFhirVersion() {
            return this.myFhirVersion;
        }

        public void setFhirVersion(String theFhirVersion) {
            this.myFhirVersion = theFhirVersion;
        }

        public String getVersion() {
            return this.myVersion;
        }

        public void setVersion(String theVersion) {
            this.myVersion = theVersion;
        }

        public long getBytes() {
            return this.myBytes;
        }

        public void setBytes(long theBytes) {
            this.myBytes = theBytes;
        }
    }

    public static class DistTags {
        @JsonProperty(value="latest")
        private String myLatest;

        public String getLatest() {
            return this.myLatest;
        }

        public DistTags setLatest(String theLatest) {
            this.myLatest = theLatest;
            return this;
        }
    }
}

