/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.packages;

import ca.uhn.fhir.jpa.packages.PackageVersionComparator;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

@ApiModel(value="Represents an NPM package search response")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(creatorVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class NpmPackageSearchResultJson {
    @JsonProperty(value="objects")
    private List<ObjectElement> myObjects;
    @JsonProperty(value="total")
    private int myTotal;

    public List<ObjectElement> getObjects() {
        if (this.myObjects == null) {
            this.myObjects = new ArrayList<ObjectElement>();
        }
        return this.myObjects;
    }

    public ObjectElement addObject() {
        ObjectElement object = new ObjectElement();
        this.getObjects().add(object);
        return object;
    }

    public int getTotal() {
        return this.myTotal;
    }

    public void setTotal(int theTotal) {
        this.myTotal = theTotal;
    }

    public boolean hasPackageWithId(String thePackageId) {
        return this.getObjects().stream().anyMatch(t -> t.getPackage().getName().equals(thePackageId));
    }

    public Package getPackageWithId(String thePackageId) {
        return this.getObjects().stream().map(t -> t.getPackage()).filter(t -> t.getName().equals(thePackageId)).findFirst().orElseThrow(() -> new IllegalArgumentException());
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonAutoDetect(creatorVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class ObjectElement {
        @JsonProperty(value="package")
        private Package myPackage;

        public Package getPackage() {
            if (this.myPackage == null) {
                this.myPackage = new Package();
            }
            return this.myPackage;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonAutoDetect(creatorVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class Package {
        @JsonProperty(value="name")
        private String myName;
        @JsonProperty(value="version")
        private String myVersion;
        @JsonProperty(value="description")
        private String myDescription;
        @JsonProperty(value="fhirVersion")
        private List<String> myFhirVersion;
        @ApiModelProperty(value="The size of this package in bytes", example="1000")
        @JsonProperty(value="_bytes")
        private long myBytes;

        public long getBytes() {
            return this.myBytes;
        }

        public Package setBytes(long theBytes) {
            this.myBytes = theBytes;
            return this;
        }

        public String getName() {
            return this.myName;
        }

        public Package setName(String theName) {
            this.myName = theName;
            return this;
        }

        public String getDescription() {
            return this.myDescription;
        }

        public Package setDescription(String theDescription) {
            this.myDescription = theDescription;
            return this;
        }

        public List<String> getFhirVersion() {
            if (this.myFhirVersion == null) {
                this.myFhirVersion = new ArrayList<String>();
            }
            return this.myFhirVersion;
        }

        public String getVersion() {
            return this.myVersion;
        }

        public Package setVersion(String theVersion) {
            this.myVersion = theVersion;
            return this;
        }

        public Package addFhirVersion(String theFhirVersionId) {
            if (!this.getFhirVersion().contains(theFhirVersionId)) {
                this.getFhirVersion().add(theFhirVersionId);
                this.getFhirVersion().sort(PackageVersionComparator.INSTANCE);
            }
            return this;
        }
    }
}

