/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.packages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

@ApiModel(value="PackageInstallationSpec", description="Defines a set of instructions for package installation")
@JsonPropertyOrder(value={"name", "version", "packageUrl", "installMode", "installResourceTypes", "validationMode"})
@ca.uhn.fhir.model.api.annotation.ExampleSupplier(value={ExampleSupplier.class, ExampleSupplier2.class})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(creatorVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class PackageInstallationSpec {
    @ApiModelProperty(value="The direct package URL")
    @JsonProperty(value="packageUrl")
    private String myPackageUrl;
    @ApiModelProperty(value="The NPM package Name")
    @JsonProperty(value="name")
    private String myName;
    @ApiModelProperty(value="The direct package version")
    @JsonProperty(value="version")
    private String myVersion;
    @ApiModelProperty(value="Should resources from this package be extracted from the package and installed into the repository individually")
    @JsonProperty(value="installMode")
    private InstallModeEnum myInstallMode;
    @ApiModelProperty(value="If resources are being installed individually, this is list provides the resource types to install. By default, all conformance resources will be installed.")
    @JsonProperty(value="installResourceTypes")
    private List<String> myInstallResourceTypes;
    @ApiModelProperty(value="Should dependencies be automatically resolved, fetched and installed with the same settings")
    @JsonProperty(value="fetchDependencies")
    private boolean myFetchDependencies;
    @ApiModelProperty(value="Any values provided here will be interpreted as a regex. Dependencies with an ID matching any regex will be skipped.")
    private List<String> myDependencyExcludes;
    @JsonIgnore
    private byte[] myPackageContents;

    public List<String> getDependencyExcludes() {
        if (this.myDependencyExcludes == null) {
            this.myDependencyExcludes = new ArrayList<String>();
        }
        return this.myDependencyExcludes;
    }

    public void setDependencyExcludes(List<String> theDependencyExcludes) {
        this.myDependencyExcludes = theDependencyExcludes;
    }

    public boolean isFetchDependencies() {
        return this.myFetchDependencies;
    }

    public PackageInstallationSpec setFetchDependencies(boolean theFetchDependencies) {
        this.myFetchDependencies = theFetchDependencies;
        return this;
    }

    public String getPackageUrl() {
        return this.myPackageUrl;
    }

    public PackageInstallationSpec setPackageUrl(String thePackageUrl) {
        this.myPackageUrl = thePackageUrl;
        return this;
    }

    public InstallModeEnum getInstallMode() {
        return this.myInstallMode;
    }

    public PackageInstallationSpec setInstallMode(InstallModeEnum theInstallMode) {
        this.myInstallMode = theInstallMode;
        return this;
    }

    public List<String> getInstallResourceTypes() {
        if (this.myInstallResourceTypes == null) {
            this.myInstallResourceTypes = new ArrayList<String>();
        }
        return this.myInstallResourceTypes;
    }

    public void setInstallResourceTypes(List<String> theInstallResourceTypes) {
        this.myInstallResourceTypes = theInstallResourceTypes;
    }

    public String getName() {
        return this.myName;
    }

    public PackageInstallationSpec setName(String theName) {
        this.myName = theName;
        return this;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public PackageInstallationSpec setVersion(String theVersion) {
        this.myVersion = theVersion;
        return this;
    }

    public byte[] getPackageContents() {
        return this.myPackageContents;
    }

    public PackageInstallationSpec setPackageContents(byte[] thePackageContents) {
        this.myPackageContents = thePackageContents;
        return this;
    }

    public PackageInstallationSpec addDependencyExclude(String theExclude) {
        this.getDependencyExcludes().add(theExclude);
        return this;
    }

    public PackageInstallationSpec addInstallResourceTypes(String ... theResourceTypes) {
        for (String next : theResourceTypes) {
            this.getInstallResourceTypes().add(next);
        }
        return this;
    }

    public static enum InstallModeEnum {
        STORE_ONLY,
        STORE_AND_INSTALL;

    }

    public static class ExampleSupplier2
    implements Supplier<PackageInstallationSpec> {
        @Override
        public PackageInstallationSpec get() {
            return new PackageInstallationSpec().setName("com.example.my-resources").setVersion("1.0").setPackageUrl("classpath:/my-resources.tgz").setInstallMode(InstallModeEnum.STORE_AND_INSTALL).addInstallResourceTypes("Organization", "Medication", "PlanDefinition", "SearchParameter");
        }
    }

    public static class ExampleSupplier
    implements Supplier<PackageInstallationSpec> {
        @Override
        public PackageInstallationSpec get() {
            return new PackageInstallationSpec().setName("hl7.fhir.us.core").setVersion("3.1.0").setInstallMode(InstallModeEnum.STORE_ONLY).setFetchDependencies(true);
        }
    }

    public static enum ValidationModeEnum {
        NOT_AVAILABLE,
        AVAILABLE;

    }
}

