/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.partition;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.entity.PartitionEntity;
import ca.uhn.fhir.jpa.partition.IPartitionLookupSvc;
import ca.uhn.fhir.jpa.partition.PartitionLookupSvcImpl;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.ResourceParam;
import ca.uhn.fhir.util.ParametersUtil;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.springframework.beans.factory.annotation.Autowired;

public class PartitionManagementProvider {
    @Autowired
    private FhirContext myCtx;
    @Autowired
    private IPartitionLookupSvc myPartitionLookupSvc;

    @Operation(name="$partition-management-create-partition")
    public IBaseParameters addPartition(@ResourceParam IBaseParameters theRequest, @OperationParam(name="id", min=1, max=1, typeName="integer") IPrimitiveType<Integer> thePartitionId, @OperationParam(name="name", min=1, max=1, typeName="code") IPrimitiveType<String> thePartitionName, @OperationParam(name="description", min=0, max=1, typeName="string") IPrimitiveType<String> thePartitionDescription) {
        PartitionLookupSvcImpl.validatePartitionIdSupplied(this.myCtx, (Integer)IPrimitiveType.toValueOrNull(thePartitionId));
        PartitionEntity input = this.parseInput(thePartitionId, thePartitionName, thePartitionDescription);
        PartitionEntity output = this.myPartitionLookupSvc.createPartition(input);
        IBaseParameters retVal = this.prepareOutput(output);
        return retVal;
    }

    @Operation(name="$partition-management-read-partition", idempotent=true)
    public IBaseParameters addPartition(@ResourceParam IBaseParameters theRequest, @OperationParam(name="id", min=1, max=1, typeName="integer") IPrimitiveType<Integer> thePartitionId) {
        PartitionLookupSvcImpl.validatePartitionIdSupplied(this.myCtx, (Integer)IPrimitiveType.toValueOrNull(thePartitionId));
        PartitionEntity output = this.myPartitionLookupSvc.getPartitionById((Integer)thePartitionId.getValue());
        return this.prepareOutput(output);
    }

    @Operation(name="$partition-management-update-partition")
    public IBaseParameters updatePartition(@ResourceParam IBaseParameters theRequest, @OperationParam(name="id", min=1, max=1, typeName="integer") IPrimitiveType<Integer> thePartitionId, @OperationParam(name="name", min=1, max=1, typeName="code") IPrimitiveType<String> thePartitionName, @OperationParam(name="description", min=0, max=1, typeName="string") IPrimitiveType<String> thePartitionDescription) {
        PartitionLookupSvcImpl.validatePartitionIdSupplied(this.myCtx, (Integer)IPrimitiveType.toValueOrNull(thePartitionId));
        PartitionEntity input = this.parseInput(thePartitionId, thePartitionName, thePartitionDescription);
        PartitionEntity output = this.myPartitionLookupSvc.updatePartition(input);
        IBaseParameters retVal = this.prepareOutput(output);
        return retVal;
    }

    @Operation(name="$partition-management-delete-partition")
    public IBaseParameters updatePartition(@ResourceParam IBaseParameters theRequest, @OperationParam(name="id", min=1, max=1, typeName="integer") IPrimitiveType<Integer> thePartitionId) {
        PartitionLookupSvcImpl.validatePartitionIdSupplied(this.myCtx, (Integer)IPrimitiveType.toValueOrNull(thePartitionId));
        this.myPartitionLookupSvc.deletePartition((Integer)thePartitionId.getValue());
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.myCtx);
        ParametersUtil.addParameterToParametersString((FhirContext)this.myCtx, (IBaseParameters)retVal, (String)"message", (String)"Success");
        return retVal;
    }

    private IBaseParameters prepareOutput(PartitionEntity theOutput) {
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.myCtx);
        ParametersUtil.addParameterToParametersInteger((FhirContext)this.myCtx, (IBaseParameters)retVal, (String)"id", (int)theOutput.getId());
        ParametersUtil.addParameterToParametersCode((FhirContext)this.myCtx, (IBaseParameters)retVal, (String)"name", (String)theOutput.getName());
        if (StringUtils.isNotBlank((CharSequence)theOutput.getDescription())) {
            ParametersUtil.addParameterToParametersString((FhirContext)this.myCtx, (IBaseParameters)retVal, (String)"description", (String)theOutput.getDescription());
        }
        return retVal;
    }

    @Nonnull
    private PartitionEntity parseInput(@OperationParam(name="id", min=1, max=1, typeName="integer") IPrimitiveType<Integer> thePartitionId, @OperationParam(name="name", min=1, max=1, typeName="code") IPrimitiveType<String> thePartitionName, @OperationParam(name="description", min=0, max=1, typeName="string") IPrimitiveType<String> thePartitionDescription) {
        PartitionEntity input = new PartitionEntity();
        if (thePartitionId != null) {
            input.setId((Integer)thePartitionId.getValue());
        }
        if (thePartitionName != null) {
            input.setName((String)thePartitionName.getValue());
        }
        if (thePartitionDescription != null) {
            input.setDescription((String)thePartitionDescription.getValue());
        }
        return input;
    }
}

