/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.partition;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.ReadPartitionIdRequestDetails;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.entity.PartitionEntity;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.partition.IPartitionLookupSvc;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.partition.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RequestPartitionHelperSvc
implements IRequestPartitionHelperSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(RequestPartitionHelperSvc.class);
    private final HashSet<Object> myNonPartitionableResourceNames = new HashSet();
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private IPartitionLookupSvc myPartitionConfigSvc;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private PartitionSettings myPartitionSettings;

    public RequestPartitionHelperSvc() {
        this.myNonPartitionableResourceNames.add("Subscription");
        this.myNonPartitionableResourceNames.add("SearchParameter");
        this.myNonPartitionableResourceNames.add("StructureDefinition");
        this.myNonPartitionableResourceNames.add("Questionnaire");
        this.myNonPartitionableResourceNames.add("CapabilityStatement");
        this.myNonPartitionableResourceNames.add("CompartmentDefinition");
        this.myNonPartitionableResourceNames.add("OperationDefinition");
        this.myNonPartitionableResourceNames.add("ConceptMap");
        this.myNonPartitionableResourceNames.add("CodeSystem");
        this.myNonPartitionableResourceNames.add("ValueSet");
        this.myNonPartitionableResourceNames.add("NamingSystem");
        this.myNonPartitionableResourceNames.add("StructureMap");
    }

    @Override
    @Nonnull
    public RequestPartitionId determineReadPartitionForRequest(@Nullable RequestDetails theRequest, String theResourceType, ReadPartitionIdRequestDetails theDetails) {
        boolean nonPartitionableResource = this.myNonPartitionableResourceNames.contains(theResourceType);
        if (this.myPartitionSettings.isPartitioningEnabled()) {
            RequestPartitionId requestPartitionId;
            if ((theRequest == null || theRequest instanceof SystemRequestDetails) && nonPartitionableResource) {
                return RequestPartitionId.defaultPartition();
            }
            if (theRequest instanceof SystemRequestDetails && this.systemRequestHasExplicitPartition((SystemRequestDetails)theRequest)) {
                requestPartitionId = this.getSystemRequestPartitionId((SystemRequestDetails)theRequest, nonPartitionableResource);
            } else if (CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.STORAGE_PARTITION_IDENTIFY_READ, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest)) {
                HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(ReadPartitionIdRequestDetails.class, (Object)theDetails);
                requestPartitionId = (RequestPartitionId)CompositeInterceptorBroadcaster.doCallHooksAndReturnObject((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PARTITION_IDENTIFY_READ, (HookParams)params);
            } else {
                requestPartitionId = null;
            }
            this.validateRequestPartitionNotNull(requestPartitionId, Pointcut.STORAGE_PARTITION_IDENTIFY_READ);
            return this.validateNormalizeAndNotifyHooksForRead(requestPartitionId, theRequest, theResourceType);
        }
        return RequestPartitionId.allPartitions();
    }

    private RequestPartitionId getSystemRequestPartitionId(SystemRequestDetails theRequest, boolean theNonPartitionableResource) {
        RequestPartitionId requestPartitionId = this.getSystemRequestPartitionId(theRequest);
        if (theNonPartitionableResource && !requestPartitionId.isDefaultPartition()) {
            throw new InternalErrorException("System call is attempting to write a non-partitionable resource to a partition! This is a bug!");
        }
        return requestPartitionId;
    }

    @Nonnull
    private RequestPartitionId getSystemRequestPartitionId(@Nonnull SystemRequestDetails theRequest) {
        if (theRequest.getRequestPartitionId() != null) {
            return theRequest.getRequestPartitionId();
        }
        if (theRequest.getTenantId() != null) {
            if (theRequest.getTenantId().equals("ALL_PARTITIONS")) {
                return RequestPartitionId.allPartitions();
            }
            return RequestPartitionId.fromPartitionName((String)theRequest.getTenantId());
        }
        return RequestPartitionId.defaultPartition();
    }

    @Override
    @Nonnull
    public RequestPartitionId determineCreatePartitionForRequest(@Nullable RequestDetails theRequest, @Nonnull IBaseResource theResource, @Nonnull String theResourceType) {
        if (this.myPartitionSettings.isPartitioningEnabled()) {
            RequestPartitionId requestPartitionId;
            boolean nonPartitionableResource = this.myNonPartitionableResourceNames.contains(theResourceType);
            if ((theRequest == null || theRequest instanceof SystemRequestDetails) && nonPartitionableResource) {
                return RequestPartitionId.defaultPartition();
            }
            if (theRequest instanceof SystemRequestDetails && this.systemRequestHasExplicitPartition((SystemRequestDetails)theRequest)) {
                requestPartitionId = this.getSystemRequestPartitionId((SystemRequestDetails)theRequest, nonPartitionableResource);
            } else {
                HookParams params = new HookParams().add(IBaseResource.class, (Object)theResource).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
                requestPartitionId = (RequestPartitionId)CompositeInterceptorBroadcaster.doCallHooksAndReturnObject((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PARTITION_IDENTIFY_CREATE, (HookParams)params);
                if (nonPartitionableResource && requestPartitionId == null) {
                    requestPartitionId = RequestPartitionId.defaultPartition();
                }
            }
            String resourceName = this.myFhirContext.getResourceType(theResource);
            this.validateSinglePartitionForCreate(requestPartitionId, resourceName, Pointcut.STORAGE_PARTITION_IDENTIFY_CREATE);
            return this.validateNormalizeAndNotifyHooksForRead(requestPartitionId, theRequest, theResourceType);
        }
        return RequestPartitionId.allPartitions();
    }

    private boolean systemRequestHasExplicitPartition(@Nonnull SystemRequestDetails theRequest) {
        return theRequest.getRequestPartitionId() != null || theRequest.getTenantId() != null;
    }

    @Override
    @Nonnull
    public PartitionablePartitionId toStoragePartition(@Nonnull RequestPartitionId theRequestPartitionId) {
        Integer partitionId = theRequestPartitionId.getFirstPartitionIdOrNull();
        if (partitionId == null) {
            partitionId = this.myPartitionSettings.getDefaultPartitionId();
        }
        return new PartitionablePartitionId(partitionId, theRequestPartitionId.getPartitionDate());
    }

    @Override
    @Nonnull
    public Set<Integer> toReadPartitions(@Nonnull RequestPartitionId theRequestPartitionId) {
        return theRequestPartitionId.getPartitionIds().stream().map(t -> t == null ? this.myPartitionSettings.getDefaultPartitionId() : t).collect(Collectors.toSet());
    }

    @Nonnull
    private RequestPartitionId validateNormalizeAndNotifyHooksForRead(@Nonnull RequestPartitionId theRequestPartitionId, RequestDetails theRequest, String theResourceType) {
        RequestPartitionId retVal = theRequestPartitionId;
        if (retVal.getPartitionNames() != null) {
            retVal = this.validateAndNormalizePartitionNames(retVal);
        } else if (retVal.hasPartitionIds()) {
            retVal = this.validateAndNormalizePartitionIds(retVal);
        }
        if (this.myInterceptorBroadcaster.hasHooks((IPointcut)Pointcut.STORAGE_PARTITION_SELECTED)) {
            RuntimeResourceDefinition runtimeResourceDefinition = this.myFhirContext.getResourceDefinition(theResourceType);
            HookParams params = new HookParams().add(RequestPartitionId.class, (Object)retVal).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(RuntimeResourceDefinition.class, (Object)runtimeResourceDefinition);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PARTITION_SELECTED, (HookParams)params);
        }
        return retVal;
    }

    private RequestPartitionId validateAndNormalizePartitionIds(RequestPartitionId theRequestPartitionId) {
        ArrayList<String> names = null;
        for (int i = 0; i < theRequestPartitionId.getPartitionIds().size(); ++i) {
            PartitionEntity partition;
            Integer id = (Integer)theRequestPartitionId.getPartitionIds().get(i);
            if (id == null) {
                partition = null;
            } else {
                try {
                    partition = this.myPartitionConfigSvc.getPartitionById(id);
                }
                catch (IllegalArgumentException e) {
                    String msg = this.myFhirContext.getLocalizer().getMessage(RequestPartitionHelperSvc.class, "unknownPartitionId", new Object[]{theRequestPartitionId.getPartitionIds().get(i)});
                    throw new ResourceNotFoundException(msg);
                }
            }
            if (theRequestPartitionId.getPartitionNames() != null) {
                if (partition == null) {
                    Validate.isTrue((theRequestPartitionId.getPartitionIds().get(i) == null ? 1 : 0) != 0, (String)"Partition %s must not have an ID", (Object[])new Object[]{"DEFAULT"});
                    continue;
                }
                Validate.isTrue((boolean)Objects.equals(theRequestPartitionId.getPartitionIds().get(i), partition.getId()), (String)"Partition name %s does not match ID %n", (Object[])new Object[]{theRequestPartitionId.getPartitionNames().get(i), theRequestPartitionId.getPartitionIds().get(i)});
                continue;
            }
            if (names == null) {
                names = new ArrayList<String>();
            }
            if (partition != null) {
                names.add(partition.getName());
                continue;
            }
            names.add(null);
        }
        if (names != null) {
            return RequestPartitionId.forPartitionIdsAndNames(names, (List)theRequestPartitionId.getPartitionIds(), (LocalDate)theRequestPartitionId.getPartitionDate());
        }
        return theRequestPartitionId;
    }

    private RequestPartitionId validateAndNormalizePartitionNames(RequestPartitionId theRequestPartitionId) {
        ArrayList<Integer> ids = null;
        for (int i = 0; i < theRequestPartitionId.getPartitionNames().size(); ++i) {
            PartitionEntity partition;
            try {
                partition = this.myPartitionConfigSvc.getPartitionByName((String)theRequestPartitionId.getPartitionNames().get(i));
            }
            catch (IllegalArgumentException e) {
                String msg = this.myFhirContext.getLocalizer().getMessage(RequestPartitionHelperSvc.class, "unknownPartitionName", new Object[]{theRequestPartitionId.getPartitionNames().get(i)});
                throw new ResourceNotFoundException(msg);
            }
            if (theRequestPartitionId.hasPartitionIds()) {
                if (partition == null) {
                    Validate.isTrue((theRequestPartitionId.getPartitionIds().get(i) == null ? 1 : 0) != 0, (String)"Partition %s must not have an ID", (Object[])new Object[]{"DEFAULT"});
                    continue;
                }
                Validate.isTrue((boolean)Objects.equals(theRequestPartitionId.getPartitionIds().get(i), partition.getId()), (String)"Partition name %s does not match ID %n", (Object[])new Object[]{theRequestPartitionId.getPartitionNames().get(i), theRequestPartitionId.getPartitionIds().get(i)});
                continue;
            }
            if (ids == null) {
                ids = new ArrayList<Integer>();
            }
            if (partition != null) {
                ids.add(partition.getId());
                continue;
            }
            ids.add(null);
        }
        if (ids != null) {
            return RequestPartitionId.forPartitionIdsAndNames((List)theRequestPartitionId.getPartitionNames(), ids, (LocalDate)theRequestPartitionId.getPartitionDate());
        }
        return theRequestPartitionId;
    }

    private void validateSinglePartitionForCreate(RequestPartitionId theRequestPartitionId, @Nonnull String theResourceName, Pointcut thePointcut) {
        this.validateRequestPartitionNotNull(theRequestPartitionId, thePointcut);
        if (theRequestPartitionId.hasPartitionIds()) {
            this.validateSinglePartitionIdOrNameForCreate(theRequestPartitionId.getPartitionIds());
        }
        this.validateSinglePartitionIdOrNameForCreate(theRequestPartitionId.getPartitionNames());
        if ((theRequestPartitionId.hasPartitionIds() && !theRequestPartitionId.getPartitionIds().contains(null) || theRequestPartitionId.hasPartitionNames() && !theRequestPartitionId.getPartitionNames().contains("DEFAULT")) && this.myNonPartitionableResourceNames.contains(theResourceName)) {
            String msg = this.myFhirContext.getLocalizer().getMessageSanitized(RequestPartitionHelperSvc.class, "nonDefaultPartitionSelectedForNonPartitionable", new Object[]{theResourceName});
            throw new UnprocessableEntityException(msg);
        }
    }

    private void validateRequestPartitionNotNull(RequestPartitionId theRequestPartitionId, Pointcut theThePointcut) {
        if (theRequestPartitionId == null) {
            throw new InternalErrorException("No interceptor provided a value for pointcut: " + theThePointcut);
        }
    }

    private void validateSinglePartitionIdOrNameForCreate(@Nullable List<?> thePartitionIds) {
        if (thePartitionIds != null && thePartitionIds.size() != 1) {
            throw new InternalErrorException("RequestPartitionId must contain a single partition for create operations, found: " + thePartitionIds);
        }
    }
}

