/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.patch;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.parser.path.EncodeContextPath;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.IModelVisitor2;
import ca.uhn.fhir.util.ParametersUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseEnumeration;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class FhirPatch {
    private final FhirContext myContext;
    private boolean myIncludePreviousValueInDiff;
    private Set<EncodeContextPath> myIgnorePaths = Collections.emptySet();

    public FhirPatch(FhirContext theContext) {
        this.myContext = theContext;
    }

    public void addIgnorePath(String theIgnorePath) {
        Validate.notBlank((CharSequence)theIgnorePath, (String)"theIgnorePath must not be null or empty", (Object[])new Object[0]);
        if (this.myIgnorePaths.isEmpty()) {
            this.myIgnorePaths = new HashSet<EncodeContextPath>();
        }
        this.myIgnorePaths.add(new EncodeContextPath(theIgnorePath));
    }

    public void setIncludePreviousValueInDiff(boolean theIncludePreviousValueInDiff) {
        this.myIncludePreviousValueInDiff = theIncludePreviousValueInDiff;
    }

    public void apply(IBaseResource theResource, IBaseResource thePatch) {
        List opParameters = ParametersUtil.getNamedParameters((FhirContext)this.myContext, (IBaseResource)thePatch, (String)"operation");
        for (IBase nextOp : opParameters) {
            String elementName;
            String containingPath;
            String type = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myContext, (IBase)nextOp, (String)"type");
            String path = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myContext, (IBase)nextOp, (String)"path");
            Optional valuePart = ParametersUtil.getParameterPart((FhirContext)this.myContext, (IBase)nextOp, (String)"value");
            Optional valuePartValue = ParametersUtil.getParameterPartValue((FhirContext)this.myContext, (IBase)nextOp, (String)"value");
            type = StringUtils.defaultString((String)type);
            path = StringUtils.defaultString((String)path);
            Integer removeIndex = null;
            Integer insertIndex = null;
            if ("delete".equals(type)) {
                this.doDelete(theResource, path);
                return;
            }
            if ("add".equals(type)) {
                containingPath = path;
                elementName = ParametersUtil.getParameterPartValueAsString((FhirContext)this.myContext, (IBase)nextOp, (String)"name");
            } else if ("replace".equals(type)) {
                int lastDot = path.lastIndexOf(".");
                containingPath = path.substring(0, lastDot);
                elementName = path.substring(lastDot + 1);
            } else if ("insert".equals(type)) {
                int lastDot = path.lastIndexOf(".");
                containingPath = path.substring(0, lastDot);
                elementName = path.substring(lastDot + 1);
                insertIndex = ParametersUtil.getParameterPartValue((FhirContext)this.myContext, (IBase)nextOp, (String)"index").map(t -> (IPrimitiveType)t).map(t -> (Integer)t.getValue()).orElseThrow(() -> new InvalidRequestException("No index supplied for insert operation"));
            } else if ("move".equals(type)) {
                int lastDot = path.lastIndexOf(".");
                containingPath = path.substring(0, lastDot);
                elementName = path.substring(lastDot + 1);
                insertIndex = ParametersUtil.getParameterPartValue((FhirContext)this.myContext, (IBase)nextOp, (String)"destination").map(t -> (IPrimitiveType)t).map(t -> (Integer)t.getValue()).orElseThrow(() -> new InvalidRequestException("No index supplied for insert operation"));
                removeIndex = ParametersUtil.getParameterPartValue((FhirContext)this.myContext, (IBase)nextOp, (String)"source").map(t -> (IPrimitiveType)t).map(t -> (Integer)t.getValue()).orElseThrow(() -> new InvalidRequestException("No index supplied for insert operation"));
            } else {
                throw new InvalidRequestException("Unknown patch operation type: " + type);
            }
            List paths = this.myContext.newFhirPath().evaluate((IBase)theResource, containingPath, IBase.class);
            for (IBase next : paths) {
                IBase newValue;
                Object msg;
                BaseRuntimeElementDefinition childElement;
                String childName;
                BaseRuntimeElementDefinition elementDef = this.myContext.getElementDefinition(next.getClass());
                BaseRuntimeChildDefinition childDef = elementDef.getChildByName(childName = elementName);
                if (childDef == null) {
                    childName = elementName + "[x]";
                    childDef = elementDef.getChildByName(childName);
                    childElement = childDef.getChildByName((String)childDef.getValidChildNames().iterator().next());
                } else {
                    childElement = childDef.getChildByName(childName);
                }
                if ("move".equals(type)) {
                    ArrayList<IBase> existingValues = new ArrayList<IBase>(childDef.getAccessor().getValues(next));
                    if (removeIndex == null || removeIndex >= existingValues.size()) {
                        String msg2 = this.myContext.getLocalizer().getMessage(FhirPatch.class, "invalidMoveSourceIndex", new Object[]{removeIndex, path, existingValues.size()});
                        throw new InvalidRequestException(msg2);
                    }
                    IBase newValue2 = (IBase)existingValues.remove(removeIndex);
                    if (insertIndex == null || insertIndex > existingValues.size()) {
                        msg = this.myContext.getLocalizer().getMessage(FhirPatch.class, "invalidMoveDestinationIndex", new Object[]{insertIndex, path, existingValues.size()});
                        throw new InvalidRequestException((String)msg);
                    }
                    existingValues.add(insertIndex, newValue2);
                    childDef.getMutator().setValue(next, null);
                    for (IBase nextNewValue : existingValues) {
                        childDef.getMutator().addValue(next, nextNewValue);
                    }
                    continue;
                }
                if (valuePartValue.isPresent()) {
                    newValue = (IBase)valuePartValue.get();
                } else {
                    newValue = childElement.newInstance();
                    if (valuePart.isPresent()) {
                        List valuePartParts = this.myContext.newTerser().getValues((IBase)valuePart.get(), "part");
                        for (IBase nextValuePartPart : valuePartParts) {
                            Optional value;
                            String name = this.myContext.newTerser().getSingleValue(nextValuePartPart, "name", IPrimitiveType.class).map(t -> t.getValueAsString()).orElse(null);
                            if (!StringUtils.isNotBlank((CharSequence)name) || !(value = this.myContext.newTerser().getSingleValue(nextValuePartPart, "value[x]", IBase.class)).isPresent()) continue;
                            BaseRuntimeChildDefinition partChildDef = childElement.getChildByName(name);
                            partChildDef.getMutator().addValue(newValue, (IBase)value.get());
                        }
                    }
                }
                if (IBaseEnumeration.class.isAssignableFrom(childElement.getImplementingClass()) || XhtmlNode.class.isAssignableFrom(childElement.getImplementingClass())) {
                    IPrimitiveType newValueInstance = (IPrimitiveType)childElement.newInstance();
                    newValueInstance.setValueAsString(((IPrimitiveType)newValue).getValueAsString());
                    childDef.getMutator().setValue(next, (IBase)newValueInstance);
                    newValue = newValueInstance;
                }
                if ("insert".equals(type)) {
                    ArrayList<IBase> existingValues = new ArrayList<IBase>(childDef.getAccessor().getValues(next));
                    if (insertIndex == null || insertIndex > existingValues.size()) {
                        msg = this.myContext.getLocalizer().getMessage(FhirPatch.class, "invalidInsertIndex", new Object[]{insertIndex, path, existingValues.size()});
                        throw new InvalidRequestException((String)msg);
                    }
                    existingValues.add(insertIndex, newValue);
                    childDef.getMutator().setValue(next, null);
                    for (IBase nextNewValue : existingValues) {
                        childDef.getMutator().addValue(next, nextNewValue);
                    }
                    continue;
                }
                childDef.getMutator().setValue(next, newValue);
            }
        }
    }

    private void doDelete(IBaseResource theResource, String thePath) {
        List paths = this.myContext.newFhirPath().evaluate((IBase)theResource, thePath, IBase.class);
        for (IBase next : paths) {
            this.myContext.newTerser().visit(next, new IModelVisitor2(){

                public boolean acceptElement(IBase theElement, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
                    if (theElement instanceof IPrimitiveType) {
                        ((IPrimitiveType)theElement).setValueAsString(null);
                    }
                    return true;
                }

                public boolean acceptUndeclaredExtension(IBaseExtension<?, ?> theNextExt, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
                    theNextExt.setUrl(null);
                    theNextExt.setValue(null);
                    return true;
                }
            });
        }
    }

    public IBaseParameters diff(@Nullable IBaseResource theOldValue, @Nonnull IBaseResource theNewValue) {
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.myContext);
        String newValueTypeName = this.myContext.getResourceDefinition(theNewValue).getName();
        if (theOldValue == null) {
            IBase operation = ParametersUtil.addParameterToParameters((FhirContext)this.myContext, (IBaseParameters)retVal, (String)"operation");
            ParametersUtil.addPartCode((FhirContext)this.myContext, (IBase)operation, (String)"type", (String)"insert");
            ParametersUtil.addPartString((FhirContext)this.myContext, (IBase)operation, (String)"path", (String)newValueTypeName);
            ParametersUtil.addPart((FhirContext)this.myContext, (IBase)operation, (String)"value", (IBase)theNewValue);
        } else {
            String oldValueTypeName = this.myContext.getResourceDefinition(theOldValue).getName();
            Validate.isTrue((boolean)oldValueTypeName.equalsIgnoreCase(newValueTypeName), (String)"Resources must be of same type", (Object[])new Object[0]);
            RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theOldValue).getBaseDefinition();
            String path = def.getName();
            EncodeContextPath contextPath = new EncodeContextPath();
            contextPath.pushPath(path, true);
            this.compare(retVal, contextPath, (BaseRuntimeElementDefinition<?>)def, path, path, (IBase)theOldValue, (IBase)theNewValue);
            contextPath.popPath();
            assert (contextPath.getPath().isEmpty());
        }
        return retVal;
    }

    private void compare(IBaseParameters theDiff, EncodeContextPath theSourceEncodeContext, BaseRuntimeElementDefinition<?> theDef, String theSourcePath, String theTargetPath, IBase theOldField, IBase theNewField) {
        boolean pathIsIgnored = this.pathIsIgnored(theSourceEncodeContext);
        if (pathIsIgnored) {
            return;
        }
        BaseRuntimeElementDefinition sourceDef = this.myContext.getElementDefinition(theOldField.getClass());
        BaseRuntimeElementDefinition targetDef = this.myContext.getElementDefinition(theNewField.getClass());
        if (!sourceDef.getName().equals(targetDef.getName())) {
            IBase operation = ParametersUtil.addParameterToParameters((FhirContext)this.myContext, (IBaseParameters)theDiff, (String)"operation");
            ParametersUtil.addPartCode((FhirContext)this.myContext, (IBase)operation, (String)"type", (String)"replace");
            ParametersUtil.addPartString((FhirContext)this.myContext, (IBase)operation, (String)"path", (String)theTargetPath);
            this.addValueToDiff(operation, theOldField, theNewField);
        } else {
            if (theOldField instanceof IPrimitiveType) {
                String newValueAsString;
                IPrimitiveType oldPrimitive = (IPrimitiveType)theOldField;
                IPrimitiveType newPrimitive = (IPrimitiveType)theNewField;
                String oldValueAsString = this.toValue(oldPrimitive);
                if (!Objects.equals(oldValueAsString, newValueAsString = this.toValue(newPrimitive))) {
                    IBase operation = ParametersUtil.addParameterToParameters((FhirContext)this.myContext, (IBaseParameters)theDiff, (String)"operation");
                    ParametersUtil.addPartCode((FhirContext)this.myContext, (IBase)operation, (String)"type", (String)"replace");
                    ParametersUtil.addPartString((FhirContext)this.myContext, (IBase)operation, (String)"path", (String)theTargetPath);
                    this.addValueToDiff(operation, (IBase)oldPrimitive, (IBase)newPrimitive);
                }
            }
            List children = theDef.getChildren();
            for (BaseRuntimeChildDefinition nextChild : children) {
                this.compareField(theDiff, theSourceEncodeContext, theSourcePath, theTargetPath, theOldField, theNewField, nextChild);
            }
        }
    }

    private void compareField(IBaseParameters theDiff, EncodeContextPath theSourceEncodePath, String theSourcePath, String theTargetPath, IBase theOldField, IBase theNewField, BaseRuntimeChildDefinition theChildDef) {
        int targetIndex;
        String elementName = theChildDef.getElementName();
        boolean repeatable = theChildDef.getMax() != 1;
        theSourceEncodePath.pushPath(elementName, false);
        if (this.pathIsIgnored(theSourceEncodePath)) {
            theSourceEncodePath.popPath();
            return;
        }
        List sourceValues = theChildDef.getAccessor().getValues(theOldField);
        List targetValues = theChildDef.getAccessor().getValues(theNewField);
        int sourceIndex = 0;
        for (targetIndex = 0; sourceIndex < sourceValues.size() && targetIndex < targetValues.size(); ++sourceIndex, ++targetIndex) {
            IBase sourceChildField = (IBase)sourceValues.get(sourceIndex);
            Validate.notNull((Object)sourceChildField);
            BaseRuntimeElementDefinition def = this.myContext.getElementDefinition(sourceChildField.getClass());
            IBase targetChildField = (IBase)targetValues.get(targetIndex);
            Validate.notNull((Object)targetChildField);
            String sourcePath = theSourcePath + "." + elementName + (repeatable ? "[" + sourceIndex + "]" : "");
            String targetPath = theSourcePath + "." + elementName + (repeatable ? "[" + targetIndex + "]" : "");
            this.compare(theDiff, theSourceEncodePath, def, sourcePath, targetPath, sourceChildField, targetChildField);
        }
        while (targetIndex < targetValues.size()) {
            String path = theTargetPath + "." + elementName;
            this.addInsertItems(theDiff, targetValues, targetIndex, path, theChildDef);
            ++targetIndex;
        }
        while (sourceIndex < sourceValues.size()) {
            IBase operation = ParametersUtil.addParameterToParameters((FhirContext)this.myContext, (IBaseParameters)theDiff, (String)"operation");
            ParametersUtil.addPartCode((FhirContext)this.myContext, (IBase)operation, (String)"type", (String)"delete");
            ParametersUtil.addPartString((FhirContext)this.myContext, (IBase)operation, (String)"path", (String)(theTargetPath + "." + elementName + (repeatable ? "[" + targetIndex + "]" : "")));
            ++sourceIndex;
            ++targetIndex;
        }
        theSourceEncodePath.popPath();
    }

    private void addInsertItems(IBaseParameters theDiff, List<? extends IBase> theTargetValues, int theTargetIndex, String thePath, BaseRuntimeChildDefinition theChildDefinition) {
        IBase operation = ParametersUtil.addParameterToParameters((FhirContext)this.myContext, (IBaseParameters)theDiff, (String)"operation");
        ParametersUtil.addPartCode((FhirContext)this.myContext, (IBase)operation, (String)"type", (String)"insert");
        ParametersUtil.addPartString((FhirContext)this.myContext, (IBase)operation, (String)"path", (String)thePath);
        ParametersUtil.addPartInteger((FhirContext)this.myContext, (IBase)operation, (String)"index", (Integer)theTargetIndex);
        IBase value = theTargetValues.get(theTargetIndex);
        BaseRuntimeElementDefinition valueDef = this.myContext.getElementDefinition(value.getClass());
        if (valueDef.isStandardType()) {
            ParametersUtil.addPart((FhirContext)this.myContext, (IBase)operation, (String)"value", (IBase)value);
        } else {
            for (BaseRuntimeChildDefinition nextChild : valueDef.getChildren()) {
                List childValues = nextChild.getAccessor().getValues(value);
                for (int index = 0; index < childValues.size(); ++index) {
                    boolean childRepeatable = theChildDefinition.getMax() != 1;
                    String elementName = nextChild.getChildNameByDatatype(((IBase)childValues.get(index)).getClass());
                    String targetPath = thePath + (childRepeatable ? "[" + index + "]" : "") + "." + elementName;
                    this.addInsertItems(theDiff, childValues, index, targetPath, nextChild);
                }
            }
        }
    }

    private void addValueToDiff(IBase theOperationPart, IBase theOldValue, IBase theNewValue) {
        if (this.myIncludePreviousValueInDiff) {
            IBase oldValue = this.massageValueForDiff(theOldValue);
            ParametersUtil.addPart((FhirContext)this.myContext, (IBase)theOperationPart, (String)"previousValue", (IBase)oldValue);
        }
        IBase newValue = this.massageValueForDiff(theNewValue);
        ParametersUtil.addPart((FhirContext)this.myContext, (IBase)theOperationPart, (String)"value", (IBase)newValue);
    }

    private boolean pathIsIgnored(EncodeContextPath theSourceEncodeContext) {
        boolean pathIsIgnored = false;
        for (EncodeContextPath next : this.myIgnorePaths) {
            if (!theSourceEncodeContext.startsWith(next, false)) continue;
            pathIsIgnored = true;
            break;
        }
        return pathIsIgnored;
    }

    private IBase massageValueForDiff(IBase theNewValue) {
        if (theNewValue instanceof XhtmlNode) {
            String xhtmlString = ((XhtmlNode)theNewValue).getValueAsString();
            theNewValue = this.myContext.getElementDefinition("string").newInstance((Object)xhtmlString);
        }
        if (theNewValue instanceof IIdType) {
            String idPart = ((IIdType)theNewValue).getIdPart();
            theNewValue = this.myContext.getElementDefinition("id").newInstance((Object)idPart);
        }
        return theNewValue;
    }

    private String toValue(IPrimitiveType<?> theOldPrimitive) {
        if (theOldPrimitive instanceof IIdType) {
            return ((IIdType)theOldPrimitive).getIdPart();
        }
        return theOldPrimitive.getValueAsString();
    }
}

