/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.patch;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.StringUtil;
import com.github.dnault.xmlpatch.Patcher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class XmlPatchUtils {
    public static <T extends IBaseResource> T apply(FhirContext theCtx, T theResourceToUpdate, String thePatchBody) {
        Class<?> clazz = theResourceToUpdate.getClass();
        String inputResource = theCtx.newXmlParser().encodeResourceToString(theResourceToUpdate);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            Patcher.patch((InputStream)new ByteArrayInputStream(inputResource.getBytes(Constants.CHARSET_UTF8)), (InputStream)new ByteArrayInputStream(thePatchBody.getBytes(Constants.CHARSET_UTF8)), (OutputStream)result);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        String resultString = StringUtil.toUtf8String((byte[])result.toByteArray());
        IBaseResource retVal = theCtx.newXmlParser().parseResource(clazz, resultString);
        return (T)retVal;
    }
}

