/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.api.model.ExpungeOptions;
import ca.uhn.fhir.jpa.api.model.ExpungeOutcome;
import ca.uhn.fhir.jpa.provider.BaseJpaProvider;
import ca.uhn.fhir.jpa.provider.IJpaSystemProvider;
import ca.uhn.fhir.jpa.search.reindex.IResourceReindexingSvc;
import ca.uhn.fhir.rest.annotation.At;
import ca.uhn.fhir.rest.annotation.History;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.Since;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class BaseJpaSystemProvider<T, MT>
extends BaseJpaProvider
implements IJpaSystemProvider {
    @Deprecated
    public static final String MARK_ALL_RESOURCES_FOR_REINDEXING = "$mark-all-resources-for-reindexing";
    @Deprecated
    public static final String PERFORM_REINDEXING_PASS = "$perform-reindexing-pass";
    private IFhirSystemDao<T, MT> myDao;
    @Autowired
    private IResourceReindexingSvc myResourceReindexingSvc;

    protected IResourceReindexingSvc getResourceReindexingSvc() {
        return this.myResourceReindexingSvc;
    }

    @Operation(name="$expunge", idempotent=false, returnParameters={@OperationParam(name="count", typeName="integer")})
    public IBaseParameters expunge(@OperationParam(name="limit", typeName="integer") IPrimitiveType<Integer> theLimit, @OperationParam(name="expungeDeletedResources", typeName="boolean") IPrimitiveType<Boolean> theExpungeDeletedResources, @OperationParam(name="expungePreviousVersions", typeName="boolean") IPrimitiveType<Boolean> theExpungeOldVersions, @OperationParam(name="expungeEverything", typeName="boolean") IPrimitiveType<Boolean> theExpungeEverything, RequestDetails theRequestDetails) {
        ExpungeOptions options = this.createExpungeOptions(theLimit, theExpungeDeletedResources, theExpungeOldVersions, theExpungeEverything);
        ExpungeOutcome outcome = this.getDao().expunge(options, theRequestDetails);
        return this.createExpungeResponse(outcome);
    }

    protected IBaseParameters doExpunge(IPrimitiveType<? extends Integer> theLimit, IPrimitiveType<? extends Boolean> theExpungeDeletedResources, IPrimitiveType<? extends Boolean> theExpungeOldVersions, IPrimitiveType<? extends Boolean> theExpungeEverything, RequestDetails theRequestDetails) {
        ExpungeOptions options = this.createExpungeOptions(theLimit, theExpungeDeletedResources, theExpungeOldVersions, theExpungeEverything);
        ExpungeOutcome outcome = this.getDao().expunge(options, theRequestDetails);
        return this.createExpungeResponse(outcome);
    }

    protected IFhirSystemDao<T, MT> getDao() {
        return this.myDao;
    }

    @Required
    public void setDao(IFhirSystemDao<T, MT> theDao) {
        this.myDao = theDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @History
    public IBundleProvider historyServer(HttpServletRequest theRequest, @Offset Integer theOffset, @Since Date theDate, @At DateRangeParam theAt, RequestDetails theRequestDetails) {
        this.startRequest(theRequest);
        try {
            DateRangeParam range = super.processSinceOrAt(theDate, theAt);
            IBundleProvider iBundleProvider = this.myDao.history(range.getLowerBoundAsInstant(), range.getUpperBoundAsInstant(), theOffset, theRequestDetails);
            return iBundleProvider;
        }
        finally {
            this.endRequest(theRequest);
        }
    }
}

