/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.patch.FhirPatch;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DiffProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(DiffProvider.class);
    @Autowired
    private FhirContext myContext;
    @Autowired
    private DaoRegistry myDaoRegistry;

    @Description(value="This operation examines two resource versions (can be two versions of the same resource, or two different resources) and generates a FHIR Patch document showing the differences.", shortDefinition="Comparte two resources or two versions of a single resource")
    @Operation(name="$diff", global=true, idempotent=true)
    public IBaseParameters diff(@IdParam IIdType theResourceId, @Description(value="The resource ID and version to diff from", example={"Patient/example/version/1"}) @OperationParam(name="fromVersion", typeName="string", min=0, max=1) IPrimitiveType<?> theFromVersion, @Description(value="Should differences in the Resource.meta element be included in the diff", example={"false"}) @OperationParam(name="includeMeta", typeName="boolean", min=0, max=1) IPrimitiveType<Boolean> theIncludeMeta, RequestDetails theRequestDetails) {
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theResourceId.getResourceType());
        IBaseResource targetResource = dao.read(theResourceId, theRequestDetails);
        IBaseResource sourceResource = null;
        Long versionId = targetResource.getIdElement().getVersionIdPartAsLong();
        if (theFromVersion == null || theFromVersion.getValueAsString() == null) {
            while ((versionId = Long.valueOf(versionId - 1L)) > 0L && sourceResource == null) {
                IIdType nextVersionedId = theResourceId.withVersion(Long.toString(versionId));
                try {
                    sourceResource = dao.read(nextVersionedId, theRequestDetails);
                }
                catch (ResourceNotFoundException e) {
                    ourLog.trace("Resource version {} can not be found, most likely it was expunged", (Object)nextVersionedId);
                }
            }
        } else {
            long fromVersion = Long.parseLong(theFromVersion.getValueAsString());
            sourceResource = dao.read(theResourceId.withVersion(Long.toString(fromVersion)), theRequestDetails);
        }
        FhirPatch fhirPatch = this.newPatch(theIncludeMeta);
        return fhirPatch.diff(sourceResource, targetResource);
    }

    @Description(value="This operation examines two resource versions (can be two versions of the same resource, or two different resources) and generates a FHIR Patch document showing the differences.")
    @Operation(name="$diff", idempotent=true)
    public IBaseParameters diff(@Description(value="The resource ID and version to diff from", example={"Patient/example/version/1"}) @OperationParam(name="from", typeName="id", min=1, max=1) IIdType theFromVersion, @Description(value="The resource ID and version to diff to", example={"Patient/example/version/2"}) @OperationParam(name="to", typeName="id", min=1, max=1) IIdType theToVersion, @Description(value="Should differences in the Resource.meta element be included in the diff", example={"false"}) @OperationParam(name="includeMeta", typeName="boolean", min=0, max=1) IPrimitiveType<Boolean> theIncludeMeta, RequestDetails theRequestDetails) {
        if (!Objects.equal((Object)theFromVersion.getResourceType(), (Object)theToVersion.getResourceType())) {
            String msg = this.myContext.getLocalizer().getMessage(DiffProvider.class, "cantDiffDifferentTypes", new Object[0]);
            throw new InvalidRequestException(msg);
        }
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theFromVersion.getResourceType());
        IBaseResource sourceResource = dao.read(theFromVersion, theRequestDetails);
        IBaseResource targetResource = dao.read(theToVersion, theRequestDetails);
        FhirPatch fhirPatch = this.newPatch(theIncludeMeta);
        return fhirPatch.diff(sourceResource, targetResource);
    }

    @Nonnull
    public FhirPatch newPatch(IPrimitiveType<Boolean> theIncludeMeta) {
        FhirPatch fhirPatch = new FhirPatch(this.myContext);
        fhirPatch.setIncludePreviousValueInDiff(true);
        if (theIncludeMeta != null && ((Boolean)theIncludeMeta.getValue()).booleanValue()) {
            ourLog.trace("Including resource metadata in patch");
        } else {
            fhirPatch.addIgnorePath("*.meta");
        }
        return fhirPatch;
    }
}

