/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.provider.BaseJpaSystemProviderDstu2Plus;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.dstu2.composite.MetaDt;
import ca.uhn.fhir.model.dstu2.resource.Bundle;
import ca.uhn.fhir.model.dstu2.resource.Parameters;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.Transaction;
import ca.uhn.fhir.rest.annotation.TransactionParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ObjectUtils;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Parameters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class JpaSystemProviderDstu2
extends BaseJpaSystemProviderDstu2Plus<Bundle, MetaDt> {
    @Autowired
    @Qualifier(value="mySystemDaoDstu2")
    private IFhirSystemDao<Bundle, MetaDt> mySystemDao;

    @Operation(name="$get-resource-counts", idempotent=true, returnParameters={@OperationParam(name="AllergyIntolerance", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Appointment", type=IntegerDt.class, min=0, max=1), @OperationParam(name="AppointmentResponse", type=IntegerDt.class, min=0, max=1), @OperationParam(name="AuditEvent", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Basic", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Binary", type=IntegerDt.class, min=0, max=1), @OperationParam(name="BodySite", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Bundle", type=IntegerDt.class, min=0, max=1), @OperationParam(name="CarePlan", type=IntegerDt.class, min=0, max=1), @OperationParam(name="CarePlan2", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Claim", type=IntegerDt.class, min=0, max=1), @OperationParam(name="ClaimResponse", type=IntegerDt.class, min=0, max=1), @OperationParam(name="ClinicalImpression", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Communication", type=IntegerDt.class, min=0, max=1), @OperationParam(name="CommunicationRequest", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Composition", type=IntegerDt.class, min=0, max=1), @OperationParam(name="ConceptMap", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Condition", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Conformance", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Contract", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Contraindication", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Coverage", type=IntegerDt.class, min=0, max=1), @OperationParam(name="DataElement", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Device", type=IntegerDt.class, min=0, max=1), @OperationParam(name="DeviceComponent", type=IntegerDt.class, min=0, max=1), @OperationParam(name="DeviceMetric", type=IntegerDt.class, min=0, max=1), @OperationParam(name="DeviceUseRequest", type=IntegerDt.class, min=0, max=1), @OperationParam(name="DeviceUseStatement", type=IntegerDt.class, min=0, max=1), @OperationParam(name="DiagnosticOrder", type=IntegerDt.class, min=0, max=1), @OperationParam(name="DiagnosticReport", type=IntegerDt.class, min=0, max=1), @OperationParam(name="DocumentManifest", type=IntegerDt.class, min=0, max=1), @OperationParam(name="DocumentReference", type=IntegerDt.class, min=0, max=1), @OperationParam(name="EligibilityRequest", type=IntegerDt.class, min=0, max=1), @OperationParam(name="EligibilityResponse", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Encounter", type=IntegerDt.class, min=0, max=1), @OperationParam(name="EnrollmentRequest", type=IntegerDt.class, min=0, max=1), @OperationParam(name="EnrollmentResponse", type=IntegerDt.class, min=0, max=1), @OperationParam(name="EpisodeOfCare", type=IntegerDt.class, min=0, max=1), @OperationParam(name="ExplanationOfBenefit", type=IntegerDt.class, min=0, max=1), @OperationParam(name="FamilyMemberHistory", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Flag", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Goal", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Group", type=IntegerDt.class, min=0, max=1), @OperationParam(name="HealthcareService", type=IntegerDt.class, min=0, max=1), @OperationParam(name="ImagingObjectSelection", type=IntegerDt.class, min=0, max=1), @OperationParam(name="ImagingStudy", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Immunization", type=IntegerDt.class, min=0, max=1), @OperationParam(name="ImmunizationRecommendation", type=IntegerDt.class, min=0, max=1), @OperationParam(name="ListResource", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Location", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Media", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Medication", type=IntegerDt.class, min=0, max=1), @OperationParam(name="MedicationAdministration", type=IntegerDt.class, min=0, max=1), @OperationParam(name="MedicationDispense", type=IntegerDt.class, min=0, max=1), @OperationParam(name="MedicationPrescription", type=IntegerDt.class, min=0, max=1), @OperationParam(name="MedicationStatement", type=IntegerDt.class, min=0, max=1), @OperationParam(name="MessageHeader", type=IntegerDt.class, min=0, max=1), @OperationParam(name="NamingSystem", type=IntegerDt.class, min=0, max=1), @OperationParam(name="NutritionOrder", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Observation", type=IntegerDt.class, min=0, max=1), @OperationParam(name="OperationDefinition", type=IntegerDt.class, min=0, max=1), @OperationParam(name="OperationOutcome", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Order", type=IntegerDt.class, min=0, max=1), @OperationParam(name="OrderResponse", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Organization", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Parameters", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Patient", type=IntegerDt.class, min=0, max=1), @OperationParam(name="PaymentNotice", type=IntegerDt.class, min=0, max=1), @OperationParam(name="PaymentReconciliation", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Person", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Practitioner", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Procedure", type=IntegerDt.class, min=0, max=1), @OperationParam(name="ProcedureRequest", type=IntegerDt.class, min=0, max=1), @OperationParam(name="ProcessRequest", type=IntegerDt.class, min=0, max=1), @OperationParam(name="ProcessResponse", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Provenance", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Questionnaire", type=IntegerDt.class, min=0, max=1), @OperationParam(name="QuestionnaireAnswers", type=IntegerDt.class, min=0, max=1), @OperationParam(name="ReferralRequest", type=IntegerDt.class, min=0, max=1), @OperationParam(name="RelatedPerson", type=IntegerDt.class, min=0, max=1), @OperationParam(name="RiskAssessment", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Schedule", type=IntegerDt.class, min=0, max=1), @OperationParam(name="SearchParameter", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Slot", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Specimen", type=IntegerDt.class, min=0, max=1), @OperationParam(name="StructureDefinition", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Subscription", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Substance", type=IntegerDt.class, min=0, max=1), @OperationParam(name="Supply", type=IntegerDt.class, min=0, max=1), @OperationParam(name="ValueSet", type=IntegerDt.class, min=0, max=1), @OperationParam(name="VisionPrescription", type=IntegerDt.class, min=0, max=1)})
    @Description(shortDefinition="Provides the number of resources currently stored on the server, broken down by resource type")
    public ca.uhn.fhir.model.dstu2.resource.Parameters getResourceCounts() {
        ca.uhn.fhir.model.dstu2.resource.Parameters retVal = new ca.uhn.fhir.model.dstu2.resource.Parameters();
        TreeMap counts = this.mySystemDao.getResourceCountsFromCache();
        counts = (Map)ObjectUtils.defaultIfNull((Object)counts, Collections.emptyMap());
        counts = new TreeMap(counts);
        for (Map.Entry nextEntry : counts.entrySet()) {
            retVal.addParameter().setName(new StringDt((String)nextEntry.getKey())).setValue((IDatatype)new IntegerDt(((Long)nextEntry.getValue()).intValue()));
        }
        return retVal;
    }

    @Operation(name="$meta", idempotent=true, returnParameters={@OperationParam(name="return", type=MetaDt.class)})
    public ca.uhn.fhir.model.dstu2.resource.Parameters meta(RequestDetails theRequestDetails) {
        ca.uhn.fhir.model.dstu2.resource.Parameters parameters = new ca.uhn.fhir.model.dstu2.resource.Parameters();
        parameters.addParameter().setName("return").setValue((IDatatype)this.getDao().metaGetOperation(theRequestDetails));
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transaction
    public Bundle transaction(RequestDetails theRequestDetails, @TransactionParam Bundle theResources) {
        this.startRequest(((ServletRequestDetails)theRequestDetails).getServletRequest());
        try {
            Bundle bundle = (Bundle)this.getDao().transaction(theRequestDetails, (Object)theResources);
            return bundle;
        }
        finally {
            this.endRequest(((ServletRequestDetails)theRequestDetails).getServletRequest());
        }
    }

    public static ca.uhn.fhir.model.dstu2.resource.Parameters toExpungeResponse(Parameters theRetVal) {
        Integer count = (Integer)((IntegerType)theRetVal.getParameterFirstRep().getValue()).getValue();
        return new ca.uhn.fhir.model.dstu2.resource.Parameters().addParameter(new Parameters.Parameter().setName("count").setValue((IDatatype)new IntegerDt(count.intValue())));
    }
}

