/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider.dstu3;

import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoCodeSystem;
import ca.uhn.fhir.jpa.provider.dstu3.JpaResourceProviderDstu3;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class BaseJpaResourceProviderCodeSystemDstu3
extends JpaResourceProviderDstu3<CodeSystem> {
    @Operation(name="$lookup", idempotent=true, returnParameters={@OperationParam(name="name", type=StringType.class, min=1), @OperationParam(name="version", type=StringType.class, min=0), @OperationParam(name="display", type=StringType.class, min=1), @OperationParam(name="abstract", type=BooleanType.class, min=1)})
    public Parameters lookup(HttpServletRequest theServletRequest, @OperationParam(name="code", min=0, max=1) CodeType theCode, @OperationParam(name="system", min=0, max=1) UriType theSystem, @OperationParam(name="coding", min=0, max=1) Coding theCoding, @OperationParam(name="version", min=0, max=1) StringType theVersion, @OperationParam(name="property", min=0, max=-1) List<CodeType> theProperties, RequestDetails theRequestDetails) {
        this.startRequest(theServletRequest);
        try {
            IFhirResourceDaoCodeSystem dao = (IFhirResourceDaoCodeSystem)this.getDao();
            IValidationSupport.LookupCodeResult result = theVersion != null ? dao.lookupCode((IPrimitiveType)theCode, (IPrimitiveType)new UriType((String)theSystem.getValue() + "|" + theVersion), (Object)theCoding, theRequestDetails) : dao.lookupCode((IPrimitiveType)theCode, (IPrimitiveType)theSystem, (Object)theCoding, theRequestDetails);
            result.throwNotFoundIfAppropriate();
            Parameters parameters = (Parameters)result.toParameters(theRequestDetails.getFhirContext(), theProperties);
            return parameters;
        }
        catch (FHIRException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$subsumes", idempotent=true, returnParameters={@OperationParam(name="outcome", type=CodeType.class, min=1)})
    public Parameters subsumes(HttpServletRequest theServletRequest, @OperationParam(name="codeA", min=0, max=1) CodeType theCodeA, @OperationParam(name="codeB", min=0, max=1) CodeType theCodeB, @OperationParam(name="system", min=0, max=1) UriType theSystem, @OperationParam(name="codingA", min=0, max=1) Coding theCodingA, @OperationParam(name="codingB", min=0, max=1) Coding theCodingB, @OperationParam(name="version", min=0, max=1) StringType theVersion, RequestDetails theRequestDetails) {
        this.startRequest(theServletRequest);
        try {
            IFhirResourceDaoCodeSystem dao = (IFhirResourceDaoCodeSystem)this.getDao();
            if (theVersion != null) {
                theSystem = new UriType(theSystem.asStringValue() + "|" + theVersion.toString());
            }
            IFhirResourceDaoCodeSystem.SubsumesResult result = dao.subsumes((IPrimitiveType)theCodeA, (IPrimitiveType)theCodeB, (IPrimitiveType)theSystem, (Object)theCodingA, (Object)theCodingB, theRequestDetails);
            Parameters parameters = (Parameters)result.toParameters(theRequestDetails.getFhirContext());
            return parameters;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }
}

