/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider.dstu3;

import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoComposition;
import ca.uhn.fhir.jpa.provider.dstu3.JpaResourceProviderDstu3;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.Composition;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.UnsignedIntType;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class BaseJpaResourceProviderCompositionDstu3
extends JpaResourceProviderDstu3<Composition> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$document", idempotent=true, bundleType=BundleTypeEnum.DOCUMENT)
    public IBaseBundle getDocumentForComposition(HttpServletRequest theServletRequest, @IdParam IdType theId, @Description(formalDefinition="Results from this method are returned across multiple pages. This parameter controls the size of those pages.") @OperationParam(name="_count") UnsignedIntType theCount, @Description(formalDefinition="Results from this method are returned across multiple pages. This parameter controls the offset when fetching a page.") @OperationParam(name="_offset") UnsignedIntType theOffset, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OperationParam(name="_lastUpdated", min=0, max=1) DateRangeParam theLastUpdated, @Sort SortSpec theSortSpec, RequestDetails theRequestDetails) {
        this.startRequest(theServletRequest);
        try {
            IBundleProvider bundleProvider = ((IFhirResourceDaoComposition)this.getDao()).getDocumentForComposition(theServletRequest, (IIdType)theId, (IPrimitiveType)theCount, (IPrimitiveType)theOffset, theLastUpdated, theSortSpec, theRequestDetails);
            List resourceList = bundleProvider.getAllResources();
            boolean foundCompositionResource = false;
            Bundle bundle = new Bundle().setType(Bundle.BundleType.DOCUMENT);
            for (IBaseResource resource : resourceList) {
                bundle.addEntry(new Bundle.BundleEntryComponent().setResource((Resource)resource));
            }
            Bundle bundle2 = bundle;
            return bundle2;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }
}

