/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider.dstu3;

import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoStructureDefinition;
import ca.uhn.fhir.jpa.provider.dstu3.JpaResourceProviderDstu3;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.ValidateUtil;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class BaseJpaResourceProviderStructureDefinitionDstu3
extends JpaResourceProviderDstu3<StructureDefinition> {
    @Operation(name="$snapshot", idempotent=true)
    public StructureDefinition snapshot(@IdParam(optional=true) IdType theId, @OperationParam(name="definition") StructureDefinition theStructureDefinition, @OperationParam(name="url") StringType theUrl, RequestDetails theRequestDetails) {
        StructureDefinition sd;
        ValidateUtil.exactlyOneNotNullOrThrowInvalidRequestException((Object[])new Object[]{theId, theStructureDefinition, theUrl}, (String)"Must supply either an ID or a StructureDefinition or a URL (but not more than one of these things)");
        if (theId == null && theStructureDefinition != null && theUrl == null) {
            sd = theStructureDefinition;
        } else if (theId != null && theStructureDefinition == null) {
            sd = (StructureDefinition)this.getDao().read((IIdType)theId, theRequestDetails);
        } else {
            SearchParameterMap map = new SearchParameterMap();
            map.setLoadSynchronousUpTo(Integer.valueOf(2));
            map.add("url", (IQueryParameterType)new UriParam((String)theUrl.getValue()));
            IBundleProvider outcome = this.getDao().search(map, theRequestDetails);
            if (outcome.size() == 0) {
                throw new ResourceNotFoundException("No StructureDefiniton found with url = '" + (String)theUrl.getValue() + "'");
            }
            sd = (StructureDefinition)outcome.getResources(0, 1).get(0);
        }
        return (StructureDefinition)this.getDao().generateSnapshot((IBaseResource)sd, null, null, null);
    }

    @Override
    public IFhirResourceDaoStructureDefinition<StructureDefinition> getDao() {
        return (IFhirResourceDaoStructureDefinition)super.getDao();
    }
}

