/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider.r4;

import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoConceptMap;
import ca.uhn.fhir.jpa.api.model.TranslationRequest;
import ca.uhn.fhir.jpa.provider.r4.JpaResourceProviderR4;
import ca.uhn.fhir.jpa.term.TermConceptMappingSvcImpl;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import javax.servlet.http.HttpServletRequest;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;

public class BaseJpaResourceProviderConceptMapR4
extends JpaResourceProviderR4<ConceptMap> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$translate", idempotent=true, returnParameters={@OperationParam(name="result", type=BooleanType.class, min=1, max=1), @OperationParam(name="message", type=StringType.class, min=0, max=1)})
    public Parameters translate(HttpServletRequest theServletRequest, @IdParam(optional=true) IdType theId, @OperationParam(name="url", min=0, max=1) UriType theUrl, @OperationParam(name="conceptMapVersion", min=0, max=1) StringType theConceptMapVersion, @OperationParam(name="code", min=0, max=1) CodeType theSourceCode, @OperationParam(name="system", min=0, max=1) UriType theSourceCodeSystem, @OperationParam(name="version", min=0, max=1) StringType theSourceCodeSystemVersion, @OperationParam(name="source", min=0, max=1) UriType theSourceValueSet, @OperationParam(name="coding", min=0, max=1) Coding theSourceCoding, @OperationParam(name="codeableConcept", min=0, max=1) CodeableConcept theSourceCodeableConcept, @OperationParam(name="target", min=0, max=1) UriType theTargetValueSet, @OperationParam(name="targetsystem", min=0, max=1) UriType theTargetCodeSystem, @OperationParam(name="reverse", min=0, max=1) BooleanType theReverse, RequestDetails theRequestDetails) {
        boolean haveId;
        boolean haveUrl = theUrl != null && theUrl.hasValue();
        boolean haveConceptMapVersion = theConceptMapVersion != null && theConceptMapVersion.hasValue();
        boolean haveSourceCode = theSourceCode != null && theSourceCode.hasCode();
        boolean haveSourceCodeSystem = theSourceCodeSystem != null && theSourceCodeSystem.hasValue();
        boolean haveSourceCodeSystemVersion = theSourceCodeSystemVersion != null && theSourceCodeSystemVersion.hasValue();
        boolean haveSourceValueSet = theSourceValueSet != null && theSourceValueSet.hasValue();
        boolean haveSourceCoding = theSourceCoding != null && theSourceCoding.hasCode();
        boolean haveSourceCodeableConcept = theSourceCodeableConcept != null && theSourceCodeableConcept.hasCoding() && theSourceCodeableConcept.getCodingFirstRep().hasCode();
        boolean haveTargetValueSet = theTargetValueSet != null && theTargetValueSet.hasValue();
        boolean haveTargetCodeSystem = theTargetCodeSystem != null && theTargetCodeSystem.hasValue();
        boolean haveReverse = theReverse != null;
        boolean bl = haveId = theId != null && theId.hasIdPart();
        if (!haveSourceCode && !haveSourceCoding && !haveSourceCodeableConcept || BaseJpaResourceProviderConceptMapR4.moreThanOneTrue(haveSourceCode, haveSourceCoding, haveSourceCodeableConcept)) {
            throw new InvalidRequestException("One (and only one) of the in parameters (code, coding, codeableConcept) must be provided, to identify the code that is to be translated.");
        }
        TranslationRequest translationRequest = new TranslationRequest();
        if (haveUrl) {
            translationRequest.setUrl(theUrl);
        }
        if (haveConceptMapVersion) {
            translationRequest.setConceptMapVersion(theConceptMapVersion);
        }
        if (haveSourceCode) {
            translationRequest.getCodeableConcept().addCoding().setCodeElement(theSourceCode);
            if (haveSourceCodeSystem) {
                translationRequest.getCodeableConcept().getCodingFirstRep().setSystemElement(theSourceCodeSystem);
            }
            if (haveSourceCodeSystemVersion) {
                translationRequest.getCodeableConcept().getCodingFirstRep().setVersionElement(theSourceCodeSystemVersion);
            }
        } else if (haveSourceCoding) {
            translationRequest.getCodeableConcept().addCoding(theSourceCoding);
        } else {
            translationRequest.setCodeableConcept(theSourceCodeableConcept);
        }
        if (haveSourceValueSet) {
            translationRequest.setSource(theSourceValueSet);
        }
        if (haveTargetValueSet) {
            translationRequest.setTarget(theTargetValueSet);
        }
        if (haveTargetCodeSystem) {
            translationRequest.setTargetSystem(theTargetCodeSystem);
        }
        if (haveReverse) {
            translationRequest.setReverse(theReverse);
        }
        if (haveId) {
            translationRequest.setResourceId(theId.getIdPartAsLong());
        }
        this.startRequest(theServletRequest);
        try {
            IFhirResourceDaoConceptMap dao = (IFhirResourceDaoConceptMap)this.getDao();
            TranslateConceptResults result = dao.translate(translationRequest, theRequestDetails);
            Parameters parameters = TermConceptMappingSvcImpl.toParameters(result);
            return parameters;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    private static boolean moreThanOneTrue(boolean ... theBooleans) {
        boolean haveOne = false;
        for (boolean next : theBooleans) {
            if (!next) continue;
            if (haveOne) {
                return true;
            }
            haveOne = true;
        }
        return false;
    }
}

