/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider.r4;

import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoValueSet;
import ca.uhn.fhir.jpa.provider.BaseJpaResourceProviderValueSetDstu2;
import ca.uhn.fhir.jpa.provider.r4.JpaResourceProviderR4;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.ValueSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseJpaResourceProviderValueSetR4
extends JpaResourceProviderR4<ValueSet> {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseJpaResourceProviderValueSetR4.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$expand", idempotent=true)
    public ValueSet expand(HttpServletRequest theServletRequest, @IdParam(optional=true) IdType theId, @OperationParam(name="valueSet", min=0, max=1) ValueSet theValueSet, @OperationParam(name="url", min=0, max=1) UriType theUrl, @OperationParam(name="valueSetVersion", min=0, max=1) StringType theValueSetVersion, @OperationParam(name="filter", min=0, max=1) StringType theFilter, @OperationParam(name="offset", min=0, max=1) IntegerType theOffset, @OperationParam(name="count", min=0, max=1) IntegerType theCount, @OperationParam(name="includeHierarchy", min=0, max=1, typeName="boolean") IPrimitiveType<Boolean> theIncludeHierarchy, RequestDetails theRequestDetails) {
        boolean haveValueSetVersion;
        boolean haveId = theId != null && theId.hasIdPart();
        boolean haveIdentifier = theUrl != null && StringUtils.isNotBlank((CharSequence)((CharSequence)theUrl.getValue()));
        boolean haveValueSet = theValueSet != null && !theValueSet.isEmpty();
        boolean bl = haveValueSetVersion = theValueSetVersion != null && !theValueSetVersion.isEmpty();
        if (!(haveId || haveIdentifier || haveValueSet)) {
            throw new InvalidRequestException("$expand operation at the type level (no ID specified) requires a url or a valueSet as a part of the request.");
        }
        if (BaseJpaResourceProviderValueSetR4.moreThanOneTrue(haveId, haveIdentifier, haveValueSet)) {
            throw new InvalidRequestException("$expand must EITHER be invoked at the instance level, or have a url specified, or have a ValueSet specified. Can not combine these options.");
        }
        ValueSetExpansionOptions options = BaseJpaResourceProviderValueSetR4.createValueSetExpansionOptions(this.myDaoConfig, (IPrimitiveType<Integer>)theOffset, (IPrimitiveType<Integer>)theCount, theIncludeHierarchy, (IPrimitiveType<String>)theFilter);
        this.startRequest(theServletRequest);
        try {
            IFhirResourceDaoValueSet dao = (IFhirResourceDaoValueSet)this.getDao();
            if (haveId) {
                ValueSet valueSet = (ValueSet)dao.expand((IIdType)theId, options, theRequestDetails);
                return valueSet;
            }
            if (haveIdentifier) {
                if (haveValueSetVersion) {
                    ValueSet valueSet = (ValueSet)dao.expandByIdentifier((String)theUrl.getValue() + "|" + (String)theValueSetVersion.getValue(), options);
                    return valueSet;
                }
                ValueSet valueSet = (ValueSet)dao.expandByIdentifier((String)theUrl.getValue(), options);
                return valueSet;
            }
            ValueSet valueSet = (ValueSet)dao.expand((IBaseResource)theValueSet, options);
            return valueSet;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$validate-code", idempotent=true, returnParameters={@OperationParam(name="result", type=BooleanType.class, min=1), @OperationParam(name="message", type=StringType.class), @OperationParam(name="display", type=StringType.class)})
    public Parameters validateCode(HttpServletRequest theServletRequest, @IdParam(optional=true) IdType theId, @OperationParam(name="url", min=0, max=1) UriType theValueSetUrl, @OperationParam(name="valueSetVersion", min=0, max=1) StringType theValueSetVersion, @OperationParam(name="code", min=0, max=1) CodeType theCode, @OperationParam(name="system", min=0, max=1) UriType theSystem, @OperationParam(name="systemVersion", min=0, max=1) StringType theSystemVersion, @OperationParam(name="display", min=0, max=1) StringType theDisplay, @OperationParam(name="coding", min=0, max=1) Coding theCoding, @OperationParam(name="codeableConcept", min=0, max=1) CodeableConcept theCodeableConcept, RequestDetails theRequestDetails) {
        this.startRequest(theServletRequest);
        try {
            IFhirResourceDaoValueSet dao = (IFhirResourceDaoValueSet)this.getDao();
            UriType valueSetIdentifier = theValueSetVersion != null ? new UriType((String)theValueSetUrl.getValue() + "|" + theValueSetVersion) : theValueSetUrl;
            UriType codeSystemIdentifier = theSystemVersion != null ? new UriType((String)theSystem.getValue() + "|" + theSystemVersion) : theSystem;
            IValidationSupport.CodeValidationResult result = dao.validateCode((IPrimitiveType)valueSetIdentifier, (IIdType)theId, (IPrimitiveType)theCode, (IPrimitiveType)codeSystemIdentifier, (IPrimitiveType)theDisplay, (Object)theCoding, (Object)theCodeableConcept, theRequestDetails);
            Parameters parameters = (Parameters)BaseJpaResourceProviderValueSetDstu2.toValidateCodeResult(this.getContext(), result);
            return parameters;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    public static ValueSetExpansionOptions createValueSetExpansionOptions(DaoConfig theDaoConfig, IPrimitiveType<Integer> theOffset, IPrimitiveType<Integer> theCount, IPrimitiveType<Boolean> theIncludeHierarchy, IPrimitiveType<String> theFilter) {
        int countMax;
        int offset = theDaoConfig.getPreExpandValueSetsDefaultOffset();
        if (theOffset != null && theOffset.hasValue()) {
            if ((Integer)theOffset.getValue() >= 0) {
                offset = (Integer)theOffset.getValue();
            } else {
                throw new InvalidRequestException("offset parameter for $expand operation must be >= 0 when specified. offset: " + theOffset.getValue());
            }
        }
        int count = theDaoConfig.getPreExpandValueSetsDefaultCount();
        if (theCount != null && theCount.hasValue()) {
            if ((Integer)theCount.getValue() >= 0) {
                count = (Integer)theCount.getValue();
            } else {
                throw new InvalidRequestException("count parameter for $expand operation must be >= 0 when specified. count: " + theCount.getValue());
            }
        }
        if (count > (countMax = theDaoConfig.getPreExpandValueSetsMaxCount())) {
            ourLog.warn("count parameter for $expand operation of {} exceeds maximum value of {}; using maximum value.", (Object)count, (Object)countMax);
            count = countMax;
        }
        ValueSetExpansionOptions options = ValueSetExpansionOptions.forOffsetAndCount((int)offset, (int)count);
        if (theIncludeHierarchy != null && Boolean.TRUE.equals(theIncludeHierarchy.getValue())) {
            options.setIncludeHierarchy(true);
        }
        if (theFilter != null) {
            options.setFilter((String)theFilter.getValue());
        }
        return options;
    }

    private static boolean moreThanOneTrue(boolean ... theBooleans) {
        boolean haveOne = false;
        for (boolean next : theBooleans) {
            if (!next) continue;
            if (haveOne) {
                return true;
            }
            haveOne = true;
        }
        return false;
    }
}

