/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider.r5;

import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoCodeSystem;
import ca.uhn.fhir.jpa.provider.BaseJpaResourceProviderValueSetDstu2;
import ca.uhn.fhir.jpa.provider.r5.JpaResourceProviderR5;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.UriType;

public class BaseJpaResourceProviderCodeSystemR5
extends JpaResourceProviderR5<CodeSystem> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$lookup", idempotent=true, returnParameters={@OperationParam(name="name", type=StringType.class, min=1), @OperationParam(name="version", type=StringType.class, min=0), @OperationParam(name="display", type=StringType.class, min=1), @OperationParam(name="abstract", type=BooleanType.class, min=1)})
    public Parameters lookup(HttpServletRequest theServletRequest, @OperationParam(name="code", min=0, max=1) CodeType theCode, @OperationParam(name="system", min=0, max=1) UriType theSystem, @OperationParam(name="coding", min=0, max=1) Coding theCoding, @OperationParam(name="version", min=0, max=1) StringType theVersion, @OperationParam(name="property", min=0, max=-1) List<CodeType> theProperties, RequestDetails theRequestDetails) {
        this.startRequest(theServletRequest);
        try {
            IFhirResourceDaoCodeSystem dao = (IFhirResourceDaoCodeSystem)this.getDao();
            IValidationSupport.LookupCodeResult result = theVersion != null ? dao.lookupCode((IPrimitiveType)theCode, (IPrimitiveType)new UriType((String)theSystem.getValue() + "|" + theVersion), (Object)theCoding, theRequestDetails) : dao.lookupCode((IPrimitiveType)theCode, (IPrimitiveType)theSystem, (Object)theCoding, theRequestDetails);
            result.throwNotFoundIfAppropriate();
            Parameters parameters = (Parameters)result.toParameters(theRequestDetails.getFhirContext(), theProperties);
            return parameters;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$subsumes", idempotent=true, returnParameters={@OperationParam(name="outcome", type=CodeType.class, min=1)})
    public Parameters subsumes(HttpServletRequest theServletRequest, @OperationParam(name="codeA", min=0, max=1) CodeType theCodeA, @OperationParam(name="codeB", min=0, max=1) CodeType theCodeB, @OperationParam(name="system", min=0, max=1) UriType theSystem, @OperationParam(name="codingA", min=0, max=1) Coding theCodingA, @OperationParam(name="codingB", min=0, max=1) Coding theCodingB, @OperationParam(name="version", min=0, max=1) StringType theVersion, RequestDetails theRequestDetails) {
        this.startRequest(theServletRequest);
        try {
            IFhirResourceDaoCodeSystem dao = (IFhirResourceDaoCodeSystem)this.getDao();
            if (theVersion != null) {
                theSystem = new UriType(theSystem.asStringValue() + "|" + theVersion.toString());
            }
            IFhirResourceDaoCodeSystem.SubsumesResult result = dao.subsumes((IPrimitiveType)theCodeA, (IPrimitiveType)theCodeB, (IPrimitiveType)theSystem, (Object)theCodingA, (Object)theCodingB, theRequestDetails);
            Parameters parameters = (Parameters)result.toParameters(theRequestDetails.getFhirContext());
            return parameters;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$validate-code", idempotent=true, returnParameters={@OperationParam(name="result", type=BooleanType.class, min=1), @OperationParam(name="message", type=StringType.class), @OperationParam(name="display", type=StringType.class)})
    public Parameters validateCode(HttpServletRequest theServletRequest, @IdParam(optional=true) IdType theId, @OperationParam(name="url", min=0, max=1) UriType theCodeSystemUrl, @OperationParam(name="version", min=0, max=1) StringType theVersion, @OperationParam(name="code", min=0, max=1) CodeType theCode, @OperationParam(name="display", min=0, max=1) StringType theDisplay, @OperationParam(name="coding", min=0, max=1) Coding theCoding, @OperationParam(name="codeableConcept", min=0, max=1) CodeableConcept theCodeableConcept, RequestDetails theRequestDetails) {
        this.startRequest(theServletRequest);
        try {
            IFhirResourceDaoCodeSystem dao = (IFhirResourceDaoCodeSystem)this.getDao();
            IValidationSupport.CodeValidationResult result = dao.validateCode((IIdType)theId, (IPrimitiveType)theCodeSystemUrl, (IPrimitiveType)theVersion, (IPrimitiveType)theCode, (IPrimitiveType)theDisplay, (Object)theCoding, (Object)theCodeableConcept, theRequestDetails);
            Parameters parameters = (Parameters)BaseJpaResourceProviderValueSetDstu2.toValidateCodeResult(this.getContext(), result);
            return parameters;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }
}

