/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider.r5;

import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoPatient;
import ca.uhn.fhir.jpa.provider.r5.JpaResourceProviderR5;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.StringOrListParam;
import ca.uhn.fhir.rest.param.StringParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.UnsignedIntType;

public class BaseJpaResourceProviderPatientR5
extends JpaResourceProviderR5<Patient> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$everything", idempotent=true, bundleType=BundleTypeEnum.SEARCHSET)
    public IBundleProvider patientInstanceEverything(HttpServletRequest theServletRequest, @IdParam IdType theId, @Description(formalDefinition="Results from this method are returned across multiple pages. This parameter controls the size of those pages.") @OperationParam(name="_count") UnsignedIntType theCount, @Description(formalDefinition="Results from this method are returned across multiple pages. This parameter controls the offset when fetching a page.") @OperationParam(name="_offset") UnsignedIntType theOffset, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OperationParam(name="_lastUpdated", min=0, max=1) DateRangeParam theLastUpdated, @Description(shortDefinition="Filter the resources to return only resources matching the given _content filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_content", min=0, max=-1) List<StringType> theContent, @Description(shortDefinition="Filter the resources to return only resources matching the given _text filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_text", min=0, max=-1) List<StringType> theNarrative, @Description(shortDefinition="Filter the resources to return only resources matching the given _filter filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_filter", min=0, max=-1) List<StringType> theFilter, @Sort SortSpec theSortSpec, RequestDetails theRequestDetails) {
        this.startRequest(theServletRequest);
        try {
            IBundleProvider iBundleProvider = ((IFhirResourceDaoPatient)this.getDao()).patientInstanceEverything(theServletRequest, (IIdType)theId, (IPrimitiveType)theCount, (IPrimitiveType)theOffset, theLastUpdated, theSortSpec, this.toStringAndList(theContent), this.toStringAndList(theNarrative), this.toStringAndList(theFilter), theRequestDetails);
            return iBundleProvider;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$everything", idempotent=true, bundleType=BundleTypeEnum.SEARCHSET)
    public IBundleProvider patientTypeEverything(HttpServletRequest theServletRequest, @Description(formalDefinition="Results from this method are returned across multiple pages. This parameter controls the size of those pages.") @OperationParam(name="_count") UnsignedIntType theCount, @Description(formalDefinition="Results from this method are returned across multiple pages. This parameter controls the offset when fetching a page.") @OperationParam(name="_offset") UnsignedIntType theOffset, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OperationParam(name="_lastUpdated", min=0, max=1) DateRangeParam theLastUpdated, @Description(shortDefinition="Filter the resources to return only resources matching the given _content filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_content", min=0, max=-1) List<StringType> theContent, @Description(shortDefinition="Filter the resources to return only resources matching the given _text filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_text", min=0, max=-1) List<StringType> theNarrative, @Description(shortDefinition="Filter the resources to return only resources matching the given _filter filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_filter", min=0, max=-1) List<StringType> theFilter, @Sort SortSpec theSortSpec, RequestDetails theRequestDetails) {
        this.startRequest(theServletRequest);
        try {
            IBundleProvider iBundleProvider = ((IFhirResourceDaoPatient)this.getDao()).patientTypeEverything(theServletRequest, (IPrimitiveType)theCount, (IPrimitiveType)theOffset, theLastUpdated, theSortSpec, this.toStringAndList(theContent), this.toStringAndList(theNarrative), this.toStringAndList(theFilter), theRequestDetails);
            return iBundleProvider;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    private StringAndListParam toStringAndList(List<StringType> theNarrative) {
        StringAndListParam retVal = new StringAndListParam();
        if (theNarrative != null) {
            for (StringType next : theNarrative) {
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)next.getValue()))) continue;
                retVal.addAnd(new StringOrListParam().addOr(new StringParam((String)next.getValue())));
            }
        }
        if (retVal.getValuesAsQueryTokens().isEmpty()) {
            return null;
        }
        return retVal;
    }
}

