/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.reindex;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.batch.api.IBatchJobSubmitter;
import ca.uhn.fhir.jpa.batch.job.PartitionedUrlValidator;
import ca.uhn.fhir.jpa.batch.job.model.RequestListJson;
import ca.uhn.fhir.jpa.batch.reader.CronologicalBatchAllResourcePidReader;
import ca.uhn.fhir.jpa.batch.reader.ReverseCronologicalBatchResourcePidReader;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IReindexJobSubmitter;
import ca.uhn.fhir.rest.server.exceptions.ForbiddenOperationException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import java.util.List;
import javax.transaction.Transactional;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ReindexJobSubmitterImpl
implements IReindexJobSubmitter {
    @Autowired
    PartitionedUrlValidator myPartitionedUrlValidator;
    @Autowired
    DaoConfig myDaoConfig;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    private IBatchJobSubmitter myBatchJobSubmitter;
    @Autowired
    @Qualifier(value="reindexJob")
    private Job myReindexJob;
    @Autowired
    @Qualifier(value="reindexEverythingJob")
    private Job myReindexEverythingJob;

    @Transactional(value=Transactional.TxType.NEVER)
    public JobExecution submitJob(Integer theBatchSize, List<String> theUrlsToReindex, RequestDetails theRequest) throws JobParametersInvalidException {
        if (theBatchSize == null) {
            theBatchSize = this.myDaoConfig.getReindexBatchSize();
        }
        RequestListJson requestListJson = this.myPartitionedUrlValidator.buildRequestListJson(theRequest, theUrlsToReindex);
        if (!this.myDaoConfig.isReindexEnabled()) {
            throw new ForbiddenOperationException("Reindexing is disabled on this server.");
        }
        this.mySearchParamRegistry.forceRefresh();
        JobParameters jobParameters = ReverseCronologicalBatchResourcePidReader.buildJobParameters("$reindex", theBatchSize, requestListJson);
        return this.myBatchJobSubmitter.runJob(this.myReindexJob, jobParameters);
    }

    @Transactional(value=Transactional.TxType.NEVER)
    public JobExecution submitEverythingJob(Integer theBatchSize, RequestDetails theRequest) throws JobParametersInvalidException {
        if (theBatchSize == null) {
            theBatchSize = this.myDaoConfig.getReindexBatchSize();
        }
        RequestPartitionId requestPartitionId = this.myPartitionedUrlValidator.requestPartitionIdFromRequest(theRequest);
        if (!this.myDaoConfig.isReindexEnabled()) {
            throw new ForbiddenOperationException("Reindexing is disabled on this server.");
        }
        this.mySearchParamRegistry.forceRefresh();
        JobParameters jobParameters = CronologicalBatchAllResourcePidReader.buildJobParameters(theBatchSize, requestPartitionId);
        return this.myBatchJobSubmitter.runJob(this.myReindexEverythingJob, jobParameters);
    }
}

