/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.reindex.job;

import ca.uhn.fhir.jpa.batch.listener.PidReaderCounterListener;
import ca.uhn.fhir.jpa.batch.reader.CronologicalBatchAllResourcePidReader;
import ca.uhn.fhir.jpa.reindex.job.ReindexWriter;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.listener.ExecutionContextPromotionListener;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class ReindexEverythingJobConfig {
    public static final String REINDEX_EVERYTHING_STEP_NAME = "reindex-everything-step";
    @Autowired
    private StepBuilderFactory myStepBuilderFactory;
    @Autowired
    private JobBuilderFactory myJobBuilderFactory;

    @Bean(name={"reindexEverythingJob"})
    @Lazy
    public Job reindexJob() {
        return this.myJobBuilderFactory.get("reindexEverythingJob").start(this.reindexEverythingStep()).build();
    }

    @Bean
    public Step reindexEverythingStep() {
        return ((AbstractTaskletStepBuilder)this.myStepBuilderFactory.get(REINDEX_EVERYTHING_STEP_NAME).chunk(1).reader((ItemReader)this.cronologicalBatchAllResourcePidReader()).writer((ItemWriter)this.reindexWriter()).listener((Object)this.reindexEverythingPidCountRecorderListener()).listener((StepExecutionListener)this.reindexEverythingPromotionListener())).build();
    }

    @Bean
    @StepScope
    public CronologicalBatchAllResourcePidReader cronologicalBatchAllResourcePidReader() {
        return new CronologicalBatchAllResourcePidReader();
    }

    @Bean
    @StepScope
    public ReindexWriter reindexWriter() {
        return new ReindexWriter();
    }

    @Bean
    @StepScope
    public PidReaderCounterListener reindexEverythingPidCountRecorderListener() {
        return new PidReaderCounterListener();
    }

    @Bean
    public ExecutionContextPromotionListener reindexEverythingPromotionListener() {
        ExecutionContextPromotionListener listener = new ExecutionContextPromotionListener();
        listener.setKeys(new String[]{"resource.total.processed"});
        return listener;
    }
}

