/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.reindex.job;

import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.batch.job.MultiUrlProcessorJobConfig;
import ca.uhn.fhir.jpa.reindex.job.ReindexWriter;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.listener.ExecutionContextPromotionListener;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class ReindexJobConfig
extends MultiUrlProcessorJobConfig {
    public static final String REINDEX_URL_LIST_STEP_NAME = "reindex-url-list-step";
    @Autowired
    private StepBuilderFactory myStepBuilderFactory;
    @Autowired
    private JobBuilderFactory myJobBuilderFactory;

    @Bean(name={"reindexJob"})
    @Lazy
    public Job reindexJob(MatchUrlService theMatchUrlService, DaoRegistry theDaoRegistry) {
        return ((JobBuilder)this.myJobBuilderFactory.get("reindexJob").validator(this.multiUrlProcessorParameterValidator(theMatchUrlService, theDaoRegistry))).start(this.reindexUrlListStep()).build();
    }

    @Bean
    public Step reindexUrlListStep() {
        return ((AbstractTaskletStepBuilder)this.myStepBuilderFactory.get(REINDEX_URL_LIST_STEP_NAME).chunk(1).reader((ItemReader)this.reverseCronologicalBatchResourcePidReader()).writer((ItemWriter)this.reindexWriter()).listener((Object)this.pidCountRecorderListener()).listener((StepExecutionListener)this.reindexPromotionListener())).build();
    }

    @Bean
    @StepScope
    public ReindexWriter reindexWriter() {
        return new ReindexWriter();
    }

    @Bean
    public ExecutionContextPromotionListener reindexPromotionListener() {
        ExecutionContextPromotionListener listener = new ExecutionContextPromotionListener();
        listener.setKeys(new String[]{"resource.total.processed"});
        return listener;
    }
}

