/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.reindex.job;

import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.dao.expunge.PartitionRunner;
import ca.uhn.fhir.jpa.search.reindex.ResourceReindexer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class ReindexWriter
implements ItemWriter<List<Long>> {
    private static final Logger ourLog = LoggerFactory.getLogger(ReindexWriter.class);
    public static final String PROCESS_NAME = "Reindexing";
    public static final String THREAD_PREFIX = "reindex";
    @Autowired
    ResourceReindexer myResourceReindexer;
    @Autowired
    DaoConfig myDaoConfig;
    @Autowired
    protected PlatformTransactionManager myTxManager;

    public void write(List<? extends List<Long>> thePidLists) throws Exception {
        PartitionRunner partitionRunner = new PartitionRunner(PROCESS_NAME, THREAD_PREFIX, this.myDaoConfig.getReindexBatchSize(), this.myDaoConfig.getReindexThreadCount());
        for (List<Long> list : thePidLists) {
            partitionRunner.runInPartitionedThreads((Slice<Long>)new SliceImpl(list), pids -> this.reindexPids((List<Long>)pids));
        }
    }

    private void reindexPids(List<Long> pidList) {
        TransactionTemplate txTemplate = new TransactionTemplate(this.myTxManager);
        txTemplate.executeWithoutResult(t -> pidList.forEach(pid -> this.myResourceReindexer.readAndReindexResourceByPid((Long)pid)));
    }
}

