/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.dstu2;

import ca.uhn.fhir.jpa.provider.JpaResourceProviderDstu2;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LocationResourceProvider
extends JpaResourceProviderDstu2<Location> {
    @Override
    public Class<Location> getResourceType() {
        return Location.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") StringAndListParam the_id, @Description(shortDefinition="The language of the resource") @OptionalParam(name="_language") StringAndListParam the_language, @Description(shortDefinition="A (part of the) address of the location") @OptionalParam(name="address") StringAndListParam theAddress, @Description(shortDefinition="A city specified in an address") @OptionalParam(name="address-city") StringAndListParam theAddress_city, @Description(shortDefinition="A country specified in an address") @OptionalParam(name="address-country") StringAndListParam theAddress_country, @Description(shortDefinition="A postal code specified in an address") @OptionalParam(name="address-postalcode") StringAndListParam theAddress_postalcode, @Description(shortDefinition="A state specified in an address") @OptionalParam(name="address-state") StringAndListParam theAddress_state, @Description(shortDefinition="A use code specified in an address") @OptionalParam(name="address-use") TokenAndListParam theAddress_use, @Description(shortDefinition="") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="A (portion of the) name of the location") @OptionalParam(name="name") StringAndListParam theName, @Description(shortDefinition="The coordinates expressed as [lat],[long] (using the WGS84 datum, see notes) to find locations near to (servers may search using a square rather than a circle for efficiency)") @OptionalParam(name="near") TokenAndListParam theNear, @Description(shortDefinition="A distance quantity to limit the near search to locations within a specific distance") @OptionalParam(name="near-distance") TokenAndListParam theNear_distance, @Description(shortDefinition="Searches for locations that are managed by the provided organization") @OptionalParam(name="organization", targetTypes={}) ReferenceAndListParam theOrganization, @Description(shortDefinition="The location of which this location is a part") @OptionalParam(name="partof", targetTypes={}) ReferenceAndListParam thePartof, @Description(shortDefinition="Searches for locations with a specific kind of status") @OptionalParam(name="status") TokenAndListParam theStatus, @Description(shortDefinition="A code for the type of location") @OptionalParam(name="type") TokenAndListParam theType, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        this.startRequest(theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("_language", (IQueryParameterAnd)the_language);
            paramMap.add("address", (IQueryParameterAnd)theAddress);
            paramMap.add("address-city", (IQueryParameterAnd)theAddress_city);
            paramMap.add("address-country", (IQueryParameterAnd)theAddress_country);
            paramMap.add("address-postalcode", (IQueryParameterAnd)theAddress_postalcode);
            paramMap.add("address-state", (IQueryParameterAnd)theAddress_state);
            paramMap.add("address-use", (IQueryParameterAnd)theAddress_use);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("name", (IQueryParameterAnd)theName);
            paramMap.add("near", (IQueryParameterAnd)theNear);
            paramMap.add("near-distance", (IQueryParameterAnd)theNear_distance);
            paramMap.add("organization", (IQueryParameterAnd)theOrganization);
            paramMap.add("partof", (IQueryParameterAnd)thePartof);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.add("type", (IQueryParameterAnd)theType);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }
}

