/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r4;

import ca.uhn.fhir.jpa.provider.r4.JpaResourceProviderR4;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r4.model.OrganizationAffiliation;

public class OrganizationAffiliationResourceProvider
extends JpaResourceProviderR4<OrganizationAffiliation> {
    @Override
    public Class<OrganizationAffiliation> getResourceType() {
        return OrganizationAffiliation.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="The language of the resource") @OptionalParam(name="_language") StringAndListParam the_language, @Description(shortDefinition="Whether this organization affiliation record is in active use") @OptionalParam(name="active") TokenAndListParam theActive, @Description(shortDefinition="The period during which the participatingOrganization is affiliated with the primary organization") @OptionalParam(name="date") DateRangeParam theDate, @Description(shortDefinition="A value in an email contact") @OptionalParam(name="email") TokenAndListParam theEmail, @Description(shortDefinition="Technical endpoints providing access to services operated for this role") @OptionalParam(name="endpoint", targetTypes={}) ReferenceAndListParam theEndpoint, @Description(shortDefinition="An organization affiliation's Identifier") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="The location(s) at which the role occurs") @OptionalParam(name="location", targetTypes={}) ReferenceAndListParam theLocation, @Description(shortDefinition="Health insurance provider network in which the participatingOrganization provides the role's services (if defined) at the indicated locations (if defined)") @OptionalParam(name="network", targetTypes={}) ReferenceAndListParam theNetwork, @Description(shortDefinition="The organization that provides services to the primary organization") @OptionalParam(name="participating-organization", targetTypes={}) ReferenceAndListParam theParticipating_organization, @Description(shortDefinition="A value in a phone contact") @OptionalParam(name="phone") TokenAndListParam thePhone, @Description(shortDefinition="The organization that receives the services from the participating organization") @OptionalParam(name="primary-organization", targetTypes={}) ReferenceAndListParam thePrimary_organization, @Description(shortDefinition="Definition of the role the participatingOrganization plays") @OptionalParam(name="role") TokenAndListParam theRole, @Description(shortDefinition="Healthcare services provided through the role") @OptionalParam(name="service", targetTypes={}) ReferenceAndListParam theService, @Description(shortDefinition="Specific specialty of the participatingOrganization in the context of the role") @OptionalParam(name="specialty") TokenAndListParam theSpecialty, @Description(shortDefinition="The value in any kind of contact") @OptionalParam(name="telecom") TokenAndListParam theTelecom, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        this.startRequest(theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("_language", (IQueryParameterAnd)the_language);
            paramMap.add("active", (IQueryParameterAnd)theActive);
            paramMap.add("date", (IQueryParameterAnd)theDate);
            paramMap.add("email", (IQueryParameterAnd)theEmail);
            paramMap.add("endpoint", (IQueryParameterAnd)theEndpoint);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("location", (IQueryParameterAnd)theLocation);
            paramMap.add("network", (IQueryParameterAnd)theNetwork);
            paramMap.add("participating-organization", (IQueryParameterAnd)theParticipating_organization);
            paramMap.add("phone", (IQueryParameterAnd)thePhone);
            paramMap.add("primary-organization", (IQueryParameterAnd)thePrimary_organization);
            paramMap.add("role", (IQueryParameterAnd)theRole);
            paramMap.add("service", (IQueryParameterAnd)theService);
            paramMap.add("specialty", (IQueryParameterAnd)theSpecialty);
            paramMap.add("telecom", (IQueryParameterAnd)theTelecom);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }
}

