/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r5;

import ca.uhn.fhir.jpa.provider.r5.JpaResourceProviderR5;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.NumberAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.SpecialAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r5.model.ResearchStudy;

public class ResearchStudyResourceProvider
extends JpaResourceProviderR5<ResearchStudy> {
    @Override
    public Class<ResearchStudy> getResourceType() {
        return ResearchStudy.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="The language of the resource") @OptionalParam(name="_language") StringAndListParam the_language, @Description(shortDefinition="Search on the narrative of the resource") @OptionalParam(name="_text") SpecialAndListParam the_text, @Description(shortDefinition="Classifications for the study") @OptionalParam(name="category") TokenAndListParam theCategory, @Description(shortDefinition="Condition being studied") @OptionalParam(name="condition") TokenAndListParam theCondition, @Description(shortDefinition="When the study began and ended") @OptionalParam(name="date") DateRangeParam theDate, @Description(shortDefinition="Drugs, devices, etc. under study") @OptionalParam(name="focus") TokenAndListParam theFocus, @Description(shortDefinition="Business Identifier for study") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="Used to search for the study") @OptionalParam(name="keyword") TokenAndListParam theKeyword, @Description(shortDefinition="Geographic region(s) for study") @OptionalParam(name="location") TokenAndListParam theLocation, @Description(shortDefinition="Part of larger study") @OptionalParam(name="partof", targetTypes={}) ReferenceAndListParam thePartof, @Description(shortDefinition="Researcher who oversees multiple aspects of the study") @OptionalParam(name="principalinvestigator", targetTypes={}) ReferenceAndListParam thePrincipalinvestigator, @Description(shortDefinition="Steps followed in executing study") @OptionalParam(name="protocol", targetTypes={}) ReferenceAndListParam theProtocol, @Description(shortDefinition="Actual number of participants enrolled in study across all groups") @OptionalParam(name="recruitment_actual") NumberAndListParam theRecruitment_actual, @Description(shortDefinition="Target number of participants enrolled in study across all groups") @OptionalParam(name="recruitment_target") NumberAndListParam theRecruitment_target, @Description(shortDefinition="Facility where study activities are conducted") @OptionalParam(name="site", targetTypes={}) ReferenceAndListParam theSite, @Description(shortDefinition="Organization that initiates and is legally responsible for the study") @OptionalParam(name="sponsor", targetTypes={}) ReferenceAndListParam theSponsor, @Description(shortDefinition="active | administratively-completed | approved | closed-to-accrual | closed-to-accrual-and-intervention | completed | disapproved | in-review | temporarily-closed-to-accrual | temporarily-closed-to-accrual-and-intervention | withdrawn") @OptionalParam(name="status") TokenAndListParam theStatus, @Description(shortDefinition="Name for this study") @OptionalParam(name="title") StringAndListParam theTitle, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        this.startRequest(theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("_language", (IQueryParameterAnd)the_language);
            paramMap.add("_text", (IQueryParameterAnd)the_text);
            paramMap.add("category", (IQueryParameterAnd)theCategory);
            paramMap.add("condition", (IQueryParameterAnd)theCondition);
            paramMap.add("date", (IQueryParameterAnd)theDate);
            paramMap.add("focus", (IQueryParameterAnd)theFocus);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("keyword", (IQueryParameterAnd)theKeyword);
            paramMap.add("location", (IQueryParameterAnd)theLocation);
            paramMap.add("partof", (IQueryParameterAnd)thePartof);
            paramMap.add("principalinvestigator", (IQueryParameterAnd)thePrincipalinvestigator);
            paramMap.add("protocol", (IQueryParameterAnd)theProtocol);
            paramMap.add("recruitment_actual", (IQueryParameterAnd)theRecruitment_actual);
            paramMap.add("recruitment_target", (IQueryParameterAnd)theRecruitment_target);
            paramMap.add("site", (IQueryParameterAnd)theSite);
            paramMap.add("sponsor", (IQueryParameterAnd)theSponsor);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.add("title", (IQueryParameterAnd)theTitle);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }
}

