/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r5;

import ca.uhn.fhir.jpa.provider.r5.JpaResourceProviderR5;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.NumberAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.SpecialAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r5.model.RiskAssessment;

public class RiskAssessmentResourceProvider
extends JpaResourceProviderR5<RiskAssessment> {
    @Override
    public Class<RiskAssessment> getResourceType() {
        return RiskAssessment.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="The language of the resource") @OptionalParam(name="_language") StringAndListParam the_language, @Description(shortDefinition="Search on the narrative of the resource") @OptionalParam(name="_text") SpecialAndListParam the_text, @Description(shortDefinition="Condition assessed") @OptionalParam(name="condition", targetTypes={}) ReferenceAndListParam theCondition, @Description(shortDefinition="Multiple Resources: * [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded* [CarePlan](careplan.html): Time period plan covers* [CareTeam](careteam.html): A date within the coverage time period.* [ClinicalImpression](clinicalimpression.html): When the assessment was documented* [Composition](composition.html): Composition editing time* [Consent](consent.html): When consent was agreed to* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report* [Encounter](encounter.html): A date within the period the Encounter lasted* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated* [Flag](flag.html): Time period when flag is active* [Immunization](immunization.html): Vaccination  (non)-Administration Date* [List](list.html): When the list was prepared* [Observation](observation.html): Obtained date/time. If the obtained element is a period, a date that falls in the period* [Procedure](procedure.html): When the procedure occurred or is occurring* [RiskAssessment](riskassessment.html): When was assessment made?* [SupplyRequest](supplyrequest.html): When the request was made") @OptionalParam(name="date") DateRangeParam theDate, @Description(shortDefinition="Multiple Resources: * [Composition](composition.html): Context of the Composition* [DeviceRequest](devicerequest.html): Encounter during which request was created* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made* [DocumentReference](documentreference.html): Context of the document  content* [Flag](flag.html): Alert relevant during encounter* [List](list.html): Context in which list created* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier* [Observation](observation.html): Encounter related to the observation* [Procedure](procedure.html): The Encounter during which this Procedure was created* [RiskAssessment](riskassessment.html): Where was assessment performed?* [ServiceRequest](servicerequest.html): An encounter in which this request is made* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier") @OptionalParam(name="encounter", targetTypes={}) ReferenceAndListParam theEncounter, @Description(shortDefinition="Multiple Resources: * [AllergyIntolerance](allergyintolerance.html): External ids for this item* [CarePlan](careplan.html): External Ids for this plan* [CareTeam](careteam.html): External Ids for this team* [Composition](composition.html): Version-independent identifier for the Composition* [Condition](condition.html): A unique identifier of the condition record* [Consent](consent.html): Identifier for this record (external references)* [DetectedIssue](detectedissue.html): Unique id for the detected issue* [DeviceRequest](devicerequest.html): Business identifier for request/order* [DiagnosticReport](diagnosticreport.html): An identifier for the report* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents* [DocumentReference](documentreference.html): Identifier of the attachment binary* [Encounter](encounter.html): Identifier(s) by which this encounter is known* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier* [Goal](goal.html): External Ids for this goal* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID* [Immunization](immunization.html): Business identifier* [List](list.html): Business identifier* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier* [MedicationUsage](medicationusage.html): Return statements with this external identifier* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier* [Observation](observation.html): The unique id for a particular observation* [Procedure](procedure.html): A unique identifier for a procedure* [RiskAssessment](riskassessment.html): Unique identifier for the assessment* [ServiceRequest](servicerequest.html): Identifiers assigned to this order* [SupplyDelivery](supplydelivery.html): External identifier* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="Evaluation mechanism") @OptionalParam(name="method") TokenAndListParam theMethod, @Description(shortDefinition="Multiple Resources: * [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for* [CarePlan](careplan.html): Who the care plan is for* [CareTeam](careteam.html): Who care team is for* [ClinicalImpression](clinicalimpression.html): Patient or group assessed* [Composition](composition.html): Who and/or what the composition is about* [Condition](condition.html): Who has the condition?* [Consent](consent.html): Who the consent applies to* [DetectedIssue](detectedissue.html): Associated patient* [DeviceRequest](devicerequest.html): Individual the service is ordered for* [DeviceUsage](deviceusage.html): Search by subject - a patient* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient* [DocumentManifest](documentmanifest.html): The subject of the set of documents* [DocumentReference](documentreference.html): Who/what is the subject of the document* [Encounter](encounter.html): The patient or group present at the encounter* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for* [Flag](flag.html): The identity of a subject to list flags for* [Goal](goal.html): Who this goal is intended for* [ImagingStudy](imagingstudy.html): Who the study is about* [Immunization](immunization.html): The patient for the vaccination record* [List](list.html): If all resources have the same subject* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement* [Observation](observation.html): The subject that the observation is about (if patient)* [Procedure](procedure.html): Search by subject - a patient* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?* [ServiceRequest](servicerequest.html): Search by subject - a patient* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for") @OptionalParam(name="patient", targetTypes={}) ReferenceAndListParam thePatient, @Description(shortDefinition="Who did assessment?") @OptionalParam(name="performer", targetTypes={}) ReferenceAndListParam thePerformer, @Description(shortDefinition="Likelihood of specified outcome") @OptionalParam(name="probability") NumberAndListParam theProbability, @Description(shortDefinition="Likelihood of specified outcome as a qualitative value") @OptionalParam(name="risk") TokenAndListParam theRisk, @Description(shortDefinition="Who/what does assessment apply to?") @OptionalParam(name="subject", targetTypes={}) ReferenceAndListParam theSubject, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        this.startRequest(theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("_language", (IQueryParameterAnd)the_language);
            paramMap.add("_text", (IQueryParameterAnd)the_text);
            paramMap.add("condition", (IQueryParameterAnd)theCondition);
            paramMap.add("date", (IQueryParameterAnd)theDate);
            paramMap.add("encounter", (IQueryParameterAnd)theEncounter);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("method", (IQueryParameterAnd)theMethod);
            paramMap.add("patient", (IQueryParameterAnd)thePatient);
            paramMap.add("performer", (IQueryParameterAnd)thePerformer);
            paramMap.add("probability", (IQueryParameterAnd)theProbability);
            paramMap.add("risk", (IQueryParameterAnd)theRisk);
            paramMap.add("subject", (IQueryParameterAnd)theSubject);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }
}

