/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.sched;

import java.util.Date;
import org.hl7.fhir.r5.model.InstantType;
import org.quartz.JobKey;
import org.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;

public class AutowiringSpringBeanJobFactory
extends SpringBeanJobFactory
implements ApplicationContextAware {
    private transient AutowireCapableBeanFactory myBeanFactory;
    private ApplicationContext myAppCtx;
    private static final Logger ourLog = LoggerFactory.getLogger(AutowiringSpringBeanJobFactory.class);

    public void setApplicationContext(ApplicationContext theApplicationContext) {
        this.myAppCtx = theApplicationContext;
        this.myBeanFactory = theApplicationContext.getAutowireCapableBeanFactory();
    }

    protected Object createJobInstance(TriggerFiredBundle bundle) throws Exception {
        String prev = this.toString(bundle.getPrevFireTime());
        String scheduled = this.toString(bundle.getScheduledFireTime());
        String next = this.toString(bundle.getNextFireTime());
        String fireInstanceId = bundle.getTrigger().getFireInstanceId();
        JobKey key = bundle.getJobDetail().getKey();
        ourLog.debug("Firing job[{}] ID[{}] - Previous[{}] Scheduled[{}] Next[{}]", new Object[]{key, fireInstanceId, prev, scheduled, next});
        Object job = super.createJobInstance(bundle);
        this.myBeanFactory.autowireBean(job);
        if (job instanceof ApplicationContextAware) {
            ((ApplicationContextAware)job).setApplicationContext(this.myAppCtx);
        }
        return job;
    }

    private String toString(Date theDate) {
        if (theDate == null) {
            return null;
        }
        return new InstantType(theDate).getValueAsString();
    }
}

